<?php
include 'includes/conn.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), HR Admin Director (9)
if ($user_level === 0 || !in_array($user_level, [1,2,9], true)) {
  header('Location: login.php');
  exit;
}
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($id <= 0) {
  header('Location: teachers.php');
  exit;
}
    $employee = mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id={$id}");
    $row = $employee ? mysqli_fetch_assoc($employee) : null;
    $teacher_id = (int) ($row['teacher_id'] ?? 0);
    $fullname = $row['fullname'] ?? '';
              ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo $fullname; ?>  Weekly TimeTable</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body style="background: #fff;">

        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-10 col-lg-offset-1">
         
                    <header class="panel-heading">
               <h2><?php echo htmlspecialchars($fullname);?> Weekly TimeTable </h2>    
                    </header>
                          <div class="panel-body">
                         <?php
                              $getdays = mysqli_query($con, "SELECT * FROM days");
                              if ($getdays) {
                                  while ($roww = mysqli_fetch_assoc($getdays)) {
                                      $day = $roww['day'] ?? '';
                                      $short = $roww['short'] ?? '';
                                      $timetable = mysqli_query($con, "SELECT * FROM `timetables` WHERE `day`='{$short}' ORDER BY `position`");
                                      if ($timetable && mysqli_num_rows($timetable) > 0) {
                                                     ?>
                              <h4 style="color: #333;font-weight: bold;text-transform: uppercase"><?php echo htmlspecialchars($day); ?></h4>
                            
                              <table  class="display table  table-bordered" style="margin-bottom: 20px;">
        <thead>
            <tr>
                <?php
                    while ($row = mysqli_fetch_assoc($timetable)) {
                      $starttime = $row['starttime'] ?? '';
                      $endtime = $row['endtime'] ?? '';
                      $activity = (int) ($row['activity'] ?? 0);
                      $teacher_subjects = mysqli_query($con, "SELECT * FROM teacher_subjects WHERE teacher_id={$id} AND class_sub_id={$activity}");
                           if ($teacher_subjects && mysqli_num_rows($teacher_subjects) > 0) {
                ?>
                <th><?php echo htmlspecialchars($starttime . ' - ' . $endtime); ?></th>
                    <?php }
                    }
                    ?>
            </tr>
            </thead>
        <tbody>
              <tr class="gradeA">
                     <?php
                            $timetable2 = mysqli_query($con, "SELECT * FROM `timetables` WHERE `day`='{$short}' ORDER BY `position`");
                    while ($row = mysqli_fetch_assoc($timetable2)) {
                      $activity = (int) ($row['activity'] ?? 0);
                      $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_sub_id={$activity}");
                      $row1 = $class_subjects ? mysqli_fetch_assoc($class_subjects) : null;
                      $subject_id = (int) ($row1['subject_id'] ?? 0);
                      $class_id = (int) ($row1['class_id'] ?? 0);
                      $getsubjects = mysqli_query($con, "SELECT * FROM subjects WHERE subject_id={$subject_id}");
                      $row3 = $getsubjects ? mysqli_fetch_assoc($getsubjects) : null;
                      $subject = $row3['subject'] ?? '';
                      $teacher_subjects = mysqli_query($con, "SELECT * FROM teacher_subjects WHERE teacher_id={$id} AND class_sub_id={$activity}");
                           if ($teacher_subjects && mysqli_num_rows($teacher_subjects) > 0) {
                ?>
    <td>
      <?php
          echo htmlspecialchars($subject);
     ?>
           </td>
                    <?php }
                    }
                    ?>
                                        </tr>
                 <tr class="gradeA">
                     <?php
                            $timetable3 = mysqli_query($con, "SELECT * FROM `timetables` WHERE `day`='{$short}' ORDER BY `position`");
                    while ($row = mysqli_fetch_assoc($timetable3)) {
                      $activity = (int) ($row['activity'] ?? 0);
                      $stream_id = (int) ($row['stream_id'] ?? 0);
                      $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_sub_id={$activity}");
                      $row1 = $class_subjects ? mysqli_fetch_assoc($class_subjects) : null;
                      $subject_id = (int) ($row1['subject_id'] ?? 0);
                      $class_id2 = (int) ($row1['class_id'] ?? 0);
                      $getclass = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id2}");
                      $row2 = $getclass ? mysqli_fetch_assoc($getclass) : null;
                      $class = $row2['class'] ?? '';
                      $getstream = mysqli_query($con, "SELECT * FROM streams WHERE stream_id={$stream_id}");
                      $row4 = $getstream ? mysqli_fetch_assoc($getstream) : null;
                      $stream = $row4['stream'] ?? '';
                      $teacher_subjects = mysqli_query($con, "SELECT * FROM teacher_subjects WHERE teacher_id={$id} AND class_sub_id={$activity}");
                           if ($teacher_subjects && mysqli_num_rows($teacher_subjects) > 0) {
                ?>
    <td>
      <?php
          echo htmlspecialchars($class . ' ' . $stream);
     ?>
           </td>
                    <?php }
                    }
                    ?>
                                        </tr>
           
        </tbody>
                        </table>
                                                            <?php }
                                  }
                              }
                              ?>
         
                          </div>
                          </div>
   
        </div>
    

        </div>
   
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>
<script type="text/javascript">
        window.print();
    </script>
</body>
</html>
