<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location: login.php');
    exit;
}
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($id <= 0) {
    header('Location: teacherattendance.php');
    exit;
}
$attendance = mysqli_query($con, "SELECT * FROM teacherattendance WHERE status=1 AND teacherattendance_id={$id}");
if (!$attendance) {
    header('Location: teacherattendance.php');
    exit;
}
$row1 = mysqli_fetch_assoc($attendance);
if (!$row1) {
    header('Location: teacherattendance.php');
    exit;
}
$date_str = $row1['date'] ?? '';
$time = $row1['time'] ?? '';
$attendance_id = (int) ($row1['teacherattendance_id'] ?? 0);

// Handle DATE format (Y-m-d)
$date_display = '';
if (!empty($date_str)) {
    if (is_numeric($date_str)) {
        $date_display = date('d/M/Y', (int)$date_str);
    } else {
        $dt = DateTime::createFromFormat('Y-m-d', $date_str);
        $date_display = $dt ? $dt->format('d/M/Y') : htmlspecialchars($date_str);
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>Attendance for <?php echo $date_display; ?></title>
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
        <?php include 'includes/header.php'; ?>

        <section class="wrapper">
            <!-- page start-->

            <div class="row">
            <header class="panel-heading">
              
              <a href="printteacherattendancedetails.php?attendance=<?php echo $id; ?>&print=1" class="btn  btn-info pull-right" onclick="window.open(this.href, '_blank', 'toolbar=0,location=0,menubar=0,width=900,height=700'); return false;">Print</a>
            </header>
                <div class="col-lg-4">
                    <section class="panel">
                        <header class="panel-heading">
                            Attendees for <?php echo $date_display . ' ' . $time; ?>
                        </header>
                        <div class="panel-body">
                            <table class="display table  table-striped">
                                <thead>
                                    <tr>
                                        <th>Fullname</th>
                                        <!-- <th>Details</th> -->

                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                    $attendees = mysqli_query($con, "SELECT * FROM teacherattendancedetails WHERE teacherattendance_id={$id} AND status=1");
                                    if ($attendees) {
                                        while ($row1 = mysqli_fetch_assoc($attendees)) {
                                            $student_id = (int) ($row1['teacher_id'] ?? 0);
                                            $students = mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id={$student_id}");
                                            $row = $students ? mysqli_fetch_assoc($students) : null;
                                            $fullname = $row['fullname'] ?? '';
                                            // details and gender may not exist for every record; provide safe defaults
                                            $details = $row1['details'] ?? '';
                                            $gender = $row['gender'] ?? ($row['gender'] ?? '');
                                    ?>
                                        <tr class="gradeA">
                                            <td>
                                                <?php echo htmlspecialchars($fullname); ?>
                                            </td>

                                            <!-- <td>
                                                <?php
                                                echo $details;
                                                ?></td> -->

                                        </tr>
                                    <?php }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>
                <div class="col-lg-4">
                    <section class="panel">
                        <header class="panel-heading">
                            Late for <?php echo $date_display . ' ' . $time; ?>
                        </header>
                        <div class="panel-body">
                            <table class="display table  table-striped">
                                <thead>
                                    <tr>
                                        <th>Fullname</th>
                                        <!-- <th>Gender</th> -->
                                        <th>&nbsp;</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                    $attendees_l = mysqli_query($con, "SELECT * FROM teacherattendancedetails WHERE teacherattendance_id={$id} AND status=2");
                                    if ($attendees_l) {
                                    while ($row1 = mysqli_fetch_assoc($attendees_l)) {
                                        $student_id = (int) ($row1['teacher_id'] ?? 0);
                                        $details = $row1['details'] ?? '';
                                        $students = mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id={$student_id}");
                                        $row = $students ? mysqli_fetch_assoc($students) : null;
                                        $fullname = $row['fullname'] ?? '';
                                        $gender = $row['gender'] ?? '';

                                    ?>
                                        <tr class="gradeA">
                                            <td>
                                                <?php echo htmlspecialchars($fullname); ?>
                                            </td>
                                            <!-- <td>
                                                <?php
                                                echo $gender;
                                                ?></td> -->
                                            <td>
                                                <?php
                                                echo htmlspecialchars($details);
                                                ?></td>

                                        </tr>
                                    <?php }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                </div>
                <div class="col-lg-4">
                    <section class="panel">
                        <header class="panel-heading">
                            Absentees for <?php echo $date_display . ' ' . $time; ?>
                        </header>
                        <div class="panel-body">
                            <table class="display table  table-striped">
                                <thead>
                                    <tr>
                                        <th>Fullname</th>
                                        <!-- <th>Gender</th> -->
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                    $attendees = mysqli_query($con, "SELECT * FROM teacherattendancedetails WHERE teacherattendance_id={$id} AND status=0");
                                    if ($attendees) {
                                    while ($row1 = mysqli_fetch_assoc($attendees)) {
                                        $student_id = (int) ($row1['teacher_id'] ?? 0);
                                        $details = $row1['details'] ?? '';
                                        $students = mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id={$student_id}");
                                        $row = $students ? mysqli_fetch_assoc($students) : null;

                                        $fullname = $row['fullname'] ?? '';
                                        $gender = $row['gender'] ?? '';

                                    ?>
                                        <tr class="gradeA">
                                            <td>
                                                <?php echo htmlspecialchars($fullname); ?>
                                            </td>

                                            <!-- <td>
                                                <?php
                                                echo $gender;
                                                ?></td> -->
                                            <td>
                                                <?php
                                                echo htmlspecialchars($details);
                                                ?></td>

                                        </tr>
                                    <?php }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>

            </div>


            </div>
            <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->

        <!--footer section end-->


        </div>
        <!-- main content end-->
    </section>

    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
    <!--common scripts for all pages-->
    <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>

</html>