<?php
include 'includes/conn.php';

// Only Super Admin can change teacher passwords from this page
$isSuperAdmin = (($_SESSION['secusyslevel'] ?? 0) == 1) || (($_SESSION['schoolsyslevel'] ?? 0) == 1);
if (!$isSuperAdmin) {
  header('Location: login');
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $teacher_id = isset($_POST['teacher_id']) ? (int)$_POST['teacher_id'] : 0;
  $newpass = isset($_POST['newpass']) ? trim($_POST['newpass']) : '';
  $newpass2 = isset($_POST['newpass2']) ? trim($_POST['newpass2']) : '';

  $errors = [];
  
  if ($teacher_id <= 0) {
    $errors[] = 'Invalid teacher ID';
  }
  
  if (empty($newpass)) {
    $errors[] = 'Password cannot be empty';
  }
  
  if ($newpass !== $newpass2) {
    $errors[] = 'Passwords do not match';
  }
  
  if (strlen($newpass) < 6) {
    $errors[] = 'Password must be at least 6 characters';
  }

  if (empty($errors)) {
    // Hash the password
    $hashed_password = password_hash($newpass, PASSWORD_DEFAULT);
    
    // Update the teacher's password
    $stmt = mysqli_prepare($con, "UPDATE teachers SET password = ? WHERE teacher_id = ?");
    if ($stmt) {
      mysqli_stmt_bind_param($stmt, 'si', $hashed_password, $teacher_id);
      $success = mysqli_stmt_execute($stmt);
      mysqli_stmt_close($stmt);
      
      if ($success) {
        $_SESSION['msg'] = 'Teacher password updated successfully';
      } else {
        $_SESSION['msg'] = 'Failed to update password';
      }
    } else {
      $_SESSION['msg'] = 'Database error';
    }
  } else {
    $_SESSION['msg'] = implode(', ', $errors);
  }
}

header('Location: users.php');
exit;
