<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location:login');
}
// validate and cast id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$id = $id ? (int)$id : 0;
// helper: accept integer timestamp or YYYY-MM-DD date string and return formatted date or empty string
function normalize_date_for_display($val)
{
  if (empty($val) && $val !== '0') {
    return '';
  }
  if (is_numeric($val)) {
    $ts = (int) $val;
    if ($ts <= 0) return '';
    return date('d/M/Y', $ts);
  }
  $d = DateTime::createFromFormat('Y-m-d', $val);
  if (!$d) $d = DateTime::createFromFormat('Y/m/d', $val);
  if (!$d) $d = DateTime::createFromFormat('d-m-Y', $val);
  if (!$d) $d = DateTime::createFromFormat('d/m/Y', $val);
  if (!$d) {
    $ts = strtotime($val);
    if ($ts === false || $ts <= 0) return '';
    return date('d/M/Y', $ts);
  }
  return $d->format('d/M/Y');
}
?>
<!DOCTYPE html>
<html>

<head>
  <style type="text/css" media="print">
    @page {
      size: auto;
      /* auto is the initial value */
      margin: 0;
      /* this affects the margin in the printer settings */
    }
  </style>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Subject Weekly Plan</title>
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/bootstrap.min.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/animate.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/style.css" rel="stylesheet">


  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="white-bg">
  <div class="wrapper wrapper-content p-xl">
    <div class="ibox-content p-xl">
      <div class="row" style="margin-bottom:30px;">
        <img src="<?php echo BASE_URL; ?>/images/schoollogo.JPG" style="width: 80px; height: 80px; margin-right: 10px; margin-bottom: 10px; float: left;">
        <div style="float: left; margin-top: 10px; margin-left: 5px;">
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">THE KING'S SCHOOL</p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">P.O. BOX 1560, Bujumbura, Burundi</p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">TEL: (+257) 22 27 96 78/69 84 04 78</p>
          <!-- <p style="margin: 0px; font-size: 11px; font-weight: bold;">EMAIL: secondary.school@thekingsschool.edu.bl</p> -->
        </div>
        <div style="float: left; margin-top: 10px; margin-left: 20px;">
          <p style="margin: 0px; font-size:15px; font-weight: bold;">Print No. <span style="text-transform: uppercase;"> <?php echo $id * 23; ?></span></p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">Print Date: <?php echo htmlspecialchars(normalize_date_for_display($timenow)); ?></p>
          <!-- <p style="margin: 0px; font-size: 15px; font-weight: bold;">TERM DATES: <?php echo date('d/M/y', $startdate_4) ?> to <?php echo date('d/M/y', $enddate_4); ?></p>
                                <p style="margin: 0px; font-size: 15px; font-weight: bold;">FORM TUTOR: <?php echo $teachername; ?></p> -->
        </div>
      </div>
      <!-- <div class="row">
        <div class="col-sm-2"><img src="<?php echo BASE_URL; ?>/images/schoollogo.JPG" class="img img-responsive"></div>
        <div class="col-sm-4">
          <address>
            THE KING'S SCHOOL,<br>
            P.O. BOX 1560, Bujumbura, Burundi<br>
            TEL: (+257) 22 27 96 78/69 84 04 78<br>

          </address>
        </div>

        <div class="col-sm-6 text-right">
          <h4>Print No.</h4>
          <h4 class="text-navy"><?php echo $id * 23; ?></h4>
          <address>

            <span><strong>Print Date:</strong> <?php echo date('M d,Y', $timenow); ?></span><br />
          </address>



        </div>

      </div> -->

      <div class="table-responsive m-t">
    <?php
    // fetch weekly plan with class/subject via joins
    $weeklyplan = null;
    $wp_stmt = mysqli_prepare($con, "SELECT wp.weeklyplan_id, wp.startdate, wp.teacher_id, wp.enddate, wp.class_sub_id, wp.bookpages, wp.periodsperweek, wp.year AS wp_year, wp.term AS term_value, wp.weeklyplandoc, c.class, c.category_id, s.subject
      FROM weeklyplans wp
      LEFT JOIN class_subjects cs ON wp.class_sub_id = cs.class_sub_id
      LEFT JOIN classes c ON cs.class_id = c.class_id
      LEFT JOIN subjects s ON cs.subject_id = s.subject_id
      WHERE wp.weeklyplan_id = ? AND wp.status = 1 LIMIT 1");
    if ($wp_stmt) {
      mysqli_stmt_bind_param($wp_stmt, 'i', $id);
      mysqli_stmt_execute($wp_stmt);
      $res = mysqli_stmt_get_result($wp_stmt);
      if ($res) {
        $weeklyplan = mysqli_fetch_assoc($res);
      }
      mysqli_stmt_close($wp_stmt);
    }

  $weeklyplan_id = $weeklyplan['weeklyplan_id'] ?? 0;
  // keep raw date strings for accurate printing
  $startdate = isset($weeklyplan['startdate']) ? $weeklyplan['startdate'] : '';
  $teacher_id = isset($weeklyplan['teacher_id']) ? (int)$weeklyplan['teacher_id'] : 0;
  $enddate = isset($weeklyplan['enddate']) ? $weeklyplan['enddate'] : '';
    $class_sub_id = isset($weeklyplan['class_sub_id']) ? (int)$weeklyplan['class_sub_id'] : 0;
    $bookpages = $weeklyplan['bookpages'] ?? '';
    $periodsperweek = $weeklyplan['periodsperweek'] ?? '';
    $year = $weeklyplan['wp_year'] ?? '';
    $term_value = isset($weeklyplan['term_value']) ? (int)$weeklyplan['term_value'] : 0;
    $class = $weeklyplan['class'] ?? '';
    $category_id = $weeklyplan['category_id'] ?? '';
    $subject = $weeklyplan['subject'] ?? '';
    $weeklyplandoc = $weeklyplan['weeklyplandoc'] ?? '';

    // fetch term
    $term = '';
    if ($term_value) {
      $term_stmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE status = 1 AND financialterm_id = ? LIMIT 1");
      if ($term_stmt) {
        mysqli_stmt_bind_param($term_stmt, 'i', $term_value);
        mysqli_stmt_execute($term_stmt);
        $tres = mysqli_stmt_get_result($term_stmt);
        if ($tres && ($trow = mysqli_fetch_assoc($tres))) {
          $term = $trow['term'] ?? '';
          $year = $trow['year'] ?? $year;
        }
        mysqli_stmt_close($term_stmt);
      }
    }
    ?>
        <h2 class="text-center" style=" font-weight: bold; text-transform: uppercase;"> <?php echo $subject . ':' . $class . ' Week Plan'; ?></h2>
        <!-- <div class="row" style="margin-bottom:20px">
          <div class="col-sm-6"><strong>Week Start : </strong><span><?php echo htmlspecialchars(normalize_date_for_display($startdate), ENT_QUOTES); ?></span></div>
          <div class="col-sm-6"><strong>Week End : </strong><span><?php echo htmlspecialchars(normalize_date_for_display($enddate), ENT_QUOTES); ?></span></div>
          <?php
          if ($category_id == 3) { ?>
            <div class="col-sm-6"><strong>Book Pages : </strong><span><?php echo $bookpages; ?></span></div>
          <?php } else { ?>
            <div class="col-sm-6"><strong>Periods per Week : </strong><span><?php echo $periodsperweek; ?></span></div>
            <div class="col-sm-6"><strong>Year : </strong><span><?php echo $year; ?></span></div>
          <?php } ?>

          <div class="col-sm-6"><strong>Term : </strong><span><?php echo $term; ?></span></div>
        </div> -->

        <?php
        // fetch lesson plans
        $lp_stmt = mysqli_prepare($con, "SELECT learning_objectives, resources, teaching_summary, main_activity, plenary, additional_activity FROM plan_details WHERE weekly_plan_id = ? AND status = 1 ORDER BY id DESC");
        if ($lp_stmt) {
            mysqli_stmt_bind_param($lp_stmt, 'i', $id);
            mysqli_stmt_execute($lp_stmt);
            $lp_res = mysqli_stmt_get_result($lp_stmt);
            while ($row = mysqli_fetch_assoc($lp_res)) {
                $learning_objectives = $row['learning_objectives'] ?? '';
                $resources = $row['resources'] ?? '';
                $teaching_summary = $row['teaching_summary'] ?? '';
                $main_activity = $row['main_activity'] ?? '';
                $plenary = $row['plenary'] ?? '';
                $additional_activity = $row['additional_activity'] ?? '';
        ?>
          <section class="panel">
            <header class="panel-heading">
              <h3>Weekly Plan </h3>
            </header>
            <div class="panel-body">
              <?php
              // use already-fetched $weeklyplandoc
              if (!empty($weeklyplandoc)) {
                $pdf_path = "../uploads/weekly_plans/" . $weeklyplandoc;
                if (file_exists($pdf_path)) {
              ?>
                  <div class="pdf-container" style="width: 100%; height: 800px;">
                    <iframe
                      src="<?php echo htmlspecialchars($pdf_path, ENT_QUOTES); ?>"
                      width="100%"
                      height="100%"
                      style="border: none;"
                      type="application/pdf">
                    </iframe>
                  </div>
              <?php
                } else {
                  echo '<div class="alert alert-warning">PDF file not found.</div>';
                }
              } else {
                echo '<div class="alert alert-info">No document uploaded for this weekly plan.</div>';
              }
              ?>
            </div>
          </section>
        <?php }
            mysqli_stmt_close($lp_stmt);
        } ?>

      </div><!-- /table-responsive -->



      <div class="well m-t">
        <strong style="font-style: italic">School System</strong>
      </div>
    </div>

  </div>

  <!-- Mainly scripts -->
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>

  <!-- Custom and plugin javascript -->
  <script src="js/inspinia.js"></script>

  <script type="text/javascript">
    window.print();
  </script>

</body>

</html>