<?php
include '../includes/conn.php';

// session guard
if (!isset($_SESSION['teachersys'])) {
    header('Location:login.php');
    exit;
}

// cast teacher id
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);
?>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Unseen Inquiries | School Manager</title>

    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Data Tables -->
    <link href="<?php echo BASE_URL; ?>/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

        
        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
         
        </div>
            <ul class="nav navbar-top-links navbar-right">
             
              
                                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">                
                <div class="col-lg-10">
                    <h2>Unseen Inquiries</h2>
                    <ol class="breadcrumb">
                         <li> <a href=""><i class="fa fa-home"></i> Home</a></li>
                                  
                        <li class="active">
                            <strong>View Inquiries</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content animated fadeInRight">
            <div class="row">
               
                <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Unseen Inquiries <small>Sort, search</small></h5>
                                  </div>
                    <div class="ibox-content">
                        <?php
                        // fetch unseen inquiries for this teacher
                        $inq_stmt = mysqli_prepare($con, "SELECT inquiry_id, parent_id, type, recipient, inquiry, timestamp FROM inquiries WHERE status = 2 AND recipient = ? AND type = 'teacher' ORDER BY timestamp DESC");
                        if ($inq_stmt) {
                            mysqli_stmt_bind_param($inq_stmt, 'i', $teacher_id);
                            mysqli_stmt_execute($inq_stmt);
                            $getinquiries = mysqli_stmt_get_result($inq_stmt);
                        } else {
                            $getinquiries = null;
                        }

                        if ($getinquiries && mysqli_num_rows($getinquiries) > 0) {
                        ?>
                    <table class="table table-striped table-bordered table-hover dataTables-example" >
                   <thead>
                                        <tr>
                                              <th>Date</th>
                                            <th>Parent</th>
                                             <th>Inquiry</th>
                                             <th>Action</th>
                                        </tr>
                                    </thead>
                    <tbody>
              <?php
                        // prepared stmt for parent lookup
                        $parent_stmt = mysqli_prepare($con, "SELECT parent_name FROM parents WHERE parent_id = ? LIMIT 1");
                        while ($row = mysqli_fetch_assoc($getinquiries)) {
                            $inquiry_id = (int)($row['inquiry_id'] ?? 0);
                            $parent_id = (int)($row['parent_id'] ?? 0);
                            $inquiry = strip_tags($row['inquiry'] ?? '');
                            $timestamp = (int)($row['timestamp'] ?? 0);

                            $fullname = '';
                            if ($parent_stmt) {
                                mysqli_stmt_bind_param($parent_stmt, 'i', $parent_id);
                                mysqli_stmt_execute($parent_stmt);
                                $pres = mysqli_stmt_get_result($parent_stmt);
                                if ($pres && ($prow = mysqli_fetch_assoc($pres))) {
                                    $fullname = $prow['parent_name'] ?? '';
                                }
                            }
                                                                                       ?>
               
             <tr class="gradeA">
                                   <td>
                                   <?php echo $timestamp ? date('d/M/Y', $timestamp) : ''; ?>
                               </td>
                        <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
                                         
                        <td><?php echo htmlspecialchars(mb_substr($inquiry, 0, 100) . '...', ENT_QUOTES); ?></td>
                                            
                        <td><a href="inquiry?id=<?php echo htmlspecialchars($inquiry_id, ENT_QUOTES); ?>" class="btn btn-success btn-xs">Details</a>
                                            </td>
                    </tr>
         <?php }
            if ($parent_stmt) mysqli_stmt_close($parent_stmt);
            if ($inq_stmt) mysqli_stmt_close($inq_stmt);
            ?>
                    </tbody>
                                    </table>
 <?php }else{
     echo '<div class="alert alert-danger">No New Inquiries Yet</div>';
 }?>
                    </div>
                </div>
            </div>
            </div>
          
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <script src="<?php echo BASE_URL; ?>/js/plugins/jeditable/jquery.jeditable.js"></script>

    <!-- Data Tables -->
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/dataTables.bootstrap.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() {
            $('.dataTables-example').dataTable();

            /* Init DataTables */
            var oTable = $('#editable').dataTable();

            /* Apply the jEditable handlers to the table */
            oTable.$('td').editable( 'http://webapplayers.com/example_ajax.php', {
                "callback": function( sValue, y ) {
                    var aPos = oTable.fnGetPosition( this );
                    oTable.fnUpdate( sValue, aPos[0], aPos[1] );
                },
                "submitdata": function ( value, settings ) {
                    return {
                        "row_id": this.parentNode.getAttribute('id'),
                        "column": oTable.fnGetPosition( this )[2]
                    };
                },

                "width": "90%"
            } );


        });

        function fnClickAddRow() {
            $('#editable').dataTable().fnAddData( [
                "Custom row",
                "New row",
                "New row",
                "New row",
                "New row" ] );

        }
    </script>
</body>


<!-- Mirrored from webapplayers.com/inspinia_admin-v1.2/table_data_tables.html by HTTrack Website Copier/3.x [XR&CO'2013], Sun, 15 Jun 2014 11:38:48 GMT -->
</html>