<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] ?? '') !== 'yes') {
  header('Location: login.php');
  exit;
}

$class_param = isset($_GET['class']) ? (string)$_GET['class'] : '';
if ($class_param === '') {
  echo '<div class="alert alert-danger">Missing class parameter</div>';
  exit;
}
$split = explode('_', $class_param);
$class_id = (int)(current($split) ?? 0);
$stream_id = (int)(end($split) ?? 0);

$class_name = '';
if ($class_id > 0) {
  $stmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id=? LIMIT 1");
  if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $class_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    if ($result && $row2 = mysqli_fetch_assoc($result)) {
      $class_name = $row2['class'] ?? '';
    }
    mysqli_stmt_close($stmt);
  }
}

$stream = '';
if ($stream_id > 0) {
  $stmt = mysqli_prepare($con, "SELECT stream FROM streams WHERE stream_id=? LIMIT 1");
  if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $stream_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    if ($result && $row = mysqli_fetch_assoc($result)) {
      $stream = $row['stream'] ?? '';
    }
    mysqli_stmt_close($stmt);
  }
}
// Teacher's assigned class id (if any) — used to control Add/Edit visibility for class teachers
$teacher_class_id = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo htmlspecialchars($class_name . ' ' . $stream); ?> TimeTable</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <section class="panel">
              <header class="panel-heading">
              <?php echo htmlspecialchars($class_name . ' ' . $stream); ?> TimeTable
              <a href="printtimetable?class=<?php echo htmlspecialchars($class_id . '_' . $stream_id); ?>" class="btn  btn-info pull-right" target="_blank">Print</a>
            </header>
            <div class="panel-body">
              <?php
              // Get all unique time slots for this class using GROUP BY for better duplicate handling
              // Handle stream_id=0 as "any stream" or no stream filter
              if ($stream_id > 0) {
                $time_stmt = mysqli_prepare($con, "SELECT starttime, endtime 
                                                      FROM timetables 
                                                      WHERE class_id=? AND stream_id=? 
                                                      GROUP BY starttime, endtime
                                                      ORDER BY starttime");
              } else {
                $time_stmt = mysqli_prepare($con, "SELECT starttime, endtime 
                                                      FROM timetables 
                                                      WHERE class_id=? 
                                                      GROUP BY starttime, endtime
                                                      ORDER BY starttime");
              }
              
              $time_slots_query = null;
              $has_time_slots = false;
              if ($time_stmt) {
                if ($stream_id > 0) {
                  mysqli_stmt_bind_param($time_stmt, 'ii', $class_id, $stream_id);
                } else {
                  mysqli_stmt_bind_param($time_stmt, 'i', $class_id);
                }
                mysqli_stmt_execute($time_stmt);
                $time_slots_query = mysqli_stmt_get_result($time_stmt);
                if ($time_slots_query) {
                  $has_time_slots = mysqli_num_rows($time_slots_query) > 0;
                }
              }

              // Get all days in correct week order
              $days_stmt = mysqli_prepare($con, "SELECT short FROM days ORDER BY FIELD(day, 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday')");
              $days = array();
              if ($days_stmt) {
                mysqli_stmt_execute($days_stmt);
                $days_query = mysqli_stmt_get_result($days_stmt);
                if ($days_query) {
                  while ($day_row = mysqli_fetch_assoc($days_query)) {
                    $days[] = $day_row['short'] ?? '';
                  }
                }
                mysqli_stmt_close($days_stmt);
              }
              
              // Fallback if no days in database
              if (empty($days)) {
                $days = ['Mon', 'Tue', 'Wed', 'Thur', 'Fri'];
              }

              // Display message if no timetable data
              if (!$has_time_slots) {
                echo '<div class="alert alert-info">No timetable has been created for this class yet.</div>';
              }
              ?>

              <?php if ($has_time_slots): ?>
              <div class="table-responsive">
                <table class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>Time</th>
                      <?php foreach ($days as $day): ?>
                        <th><?php echo htmlspecialchars(strtoupper($day)); ?></th>
                      <?php endforeach; ?>
                    </tr>
                  </thead>
                  <tbody>
                    <?php if ($time_slots_query): ?>
                    <?php while ($time_slot = mysqli_fetch_assoc($time_slots_query)): ?>
                      <tr>
                        <td><?php echo htmlspecialchars(($time_slot['starttime'] ?? '') . ' - ' . ($time_slot['endtime'] ?? '')); ?></td>
                        <?php foreach ($days as $day): ?>
                          <td>
                            <?php
                            // Build query based on whether we have a stream_id
                            if ($stream_id > 0) {
                              $subject_stmt = mysqli_prepare($con, "SELECT t.activity, s.subject 
                                                                FROM timetables t 
                                                                LEFT JOIN class_subjects cs ON t.activity = cs.class_sub_id 
                                                                LEFT JOIN subjects s ON cs.subject_id = s.subject_id 
                                                                WHERE t.class_id=? 
                                                                AND t.stream_id=? 
                                                                AND t.day=? 
                                                                AND t.starttime=? 
                                                                AND t.endtime=? LIMIT 1");
                            } else {
                              $subject_stmt = mysqli_prepare($con, "SELECT t.activity, s.subject 
                                                                FROM timetables t 
                                                                LEFT JOIN class_subjects cs ON t.activity = cs.class_sub_id 
                                                                LEFT JOIN subjects s ON cs.subject_id = s.subject_id 
                                                                WHERE t.class_id=? 
                                                                AND t.day=? 
                                                                AND t.starttime=? 
                                                                AND t.endtime=? LIMIT 1");
                            }
                            
                            if ($subject_stmt) {
                              $start_time = (string)($time_slot['starttime'] ?? '');
                              $end_time = (string)($time_slot['endtime'] ?? '');
                              
                              if ($stream_id > 0) {
                                mysqli_stmt_bind_param($subject_stmt, 'iisss', $class_id, $stream_id, $day, $start_time, $end_time);
                              } else {
                                mysqli_stmt_bind_param($subject_stmt, 'isss', $class_id, $day, $start_time, $end_time);
                              }
                              
                              mysqli_stmt_execute($subject_stmt);
                              $subject_result = mysqli_stmt_get_result($subject_stmt);
                              
                              if ($subject_result && mysqli_num_rows($subject_result) > 0) {
                                $subject_row = mysqli_fetch_assoc($subject_result);
                                if (!empty($subject_row['subject'])) {
                                  echo htmlspecialchars($subject_row['subject']);
                                } else {
                                  echo htmlspecialchars($subject_row['activity'] ?? '-');
                                }
                              } else {
                                echo '-';
                              }
                              mysqli_stmt_close($subject_stmt);
                            } else {
                              echo '-';
                            }
                            ?>
                          </td>
                        <?php endforeach; ?>
                      </tr>
                    <?php endwhile; ?>
                    <?php endif; ?>
                    <?php if ($time_stmt) mysqli_stmt_close($time_stmt); ?>
                  </tbody>
                </table>
              </div>
              <?php endif; ?>

              <?php
              // Only show Add/Edit to class teachers when they're viewing their own class timetable
              $is_class_teacher = (isset($_SESSION['classteacher']) && $_SESSION['classteacher'] === 'yes');
              if ($is_class_teacher && $teacher_class_id === (int)$class_id): ?>
                <div class="text-center" style="margin-top: 20px;">
                  <a href="addtimetable?cl=<?php echo $class_id; ?>&&st=<?php echo $stream_id; ?>" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Add/Edit Timetable
                  </a>
                </div>
              <?php endif; ?>

            </div>
          </section>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <!-- Placed js at the end of the document so the pages load faster -->
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>

</html>