<?php
include '../includes/conn.php';

// session guard
if (!isset($_SESSION['teachersys'])) {
    header('Location:login.php');
    exit;
}

// cast teacher id
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);

// validate and cast id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$id = $id === false || $id === null ? 0 : (int)$id;

// fetch subject details safely
$subjectdetails_id = 0;
$subject_id = 0;
$term = '';
$description = '';
$subject = '';
$class = '';

$sd_stmt = mysqli_prepare($con, "SELECT subjectdetails_id, subject_id, term, description FROM subjectdetails WHERE subjectdetails_id = ? AND status = 1 LIMIT 1");
if ($sd_stmt) {
    mysqli_stmt_bind_param($sd_stmt, 'i', $id);
    mysqli_stmt_execute($sd_stmt);
    $sres = mysqli_stmt_get_result($sd_stmt);
    if ($sres && ($srow = mysqli_fetch_assoc($sres))) {
        $subjectdetails_id = (int)($srow['subjectdetails_id'] ?? 0);
        $subject_id = (int)($srow['subject_id'] ?? 0);
        $term = $srow['term'] ?? '';
        $description = $srow['description'] ?? '';
    }
    mysqli_stmt_close($sd_stmt);
}

// fetch subject and class
$sc_stmt = mysqli_prepare($con, "SELECT s.subject, s.class_id, c.class FROM subjects s LEFT JOIN classes c ON c.class_id = s.class_id WHERE s.subject_id = ? LIMIT 1");
if ($sc_stmt) {
    mysqli_stmt_bind_param($sc_stmt, 'i', $subject_id);
    mysqli_stmt_execute($sc_stmt);
    $scres = mysqli_stmt_get_result($sc_stmt);
    if ($scres && ($scrow = mysqli_fetch_assoc($scres))) {
        $subject = $scrow['subject'] ?? '';
        $class = $scrow['class'] ?? '';
    }
    mysqli_stmt_close($sc_stmt);
}
?>
<!DOCTYPE html>
<html>


<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Term Subject Details | Teacher Manager</title>

    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

        <?php include 'nav.php'; ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <nav class="navbar navbar-static-top  " role="navigation" style="margin-bottom: 0">
                    <div class="navbar-header">
                        <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>

                    </div>
                    <ul class="nav navbar-top-links navbar-right">


                        <li>
                            <a href="logout">
                                <i class="fa fa-sign-out"></i> Log out
                            </a>
                        </li>
                    </ul>

                </nav>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-9">
                    <h2><?php echo $class . ' : ' . $subject . ' for Term ' . $term; ?></h2>

                </div>
            </div>
            <div class="wrapper wrapper-content animated fadeInRight">

                <div class="row">

                    <div class="col-md-12">
                        <?php
                        // check if logged-in teacher teaches this subject
                        $can_edit = false;
                        $ts_check = mysqli_prepare($con, "SELECT 1 FROM teacher_subjects WHERE teacher_id = ? AND subject_id = ? LIMIT 1");
                        if ($ts_check) {
                            mysqli_stmt_bind_param($ts_check, 'ii', $teacher_id, $subject_id);
                            mysqli_stmt_execute($ts_check);
                            $tres = mysqli_stmt_get_result($ts_check);
                            if ($tres && mysqli_fetch_assoc($tres)) {
                                $can_edit = true;
                            }
                            mysqli_stmt_close($ts_check);
                        }
                        if ($can_edit) {
                        ?>
                            <a href="edittermsubject?id=<?php echo htmlspecialchars($id, ENT_QUOTES); ?>" class="btn btn-primary">Edit Term Details</a>
                        <?php } ?>
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5>Term Details</h5>
                                <?php ?>
                            </div>

                            <div class="ibox-content">
                                <?php
                                // escape description (was raw HTML)
                                echo htmlspecialchars($description, ENT_QUOTES);

                                // fetch attachments
                                $attach_stmt = mysqli_prepare($con, "SELECT subjectdoc_id, ext FROM subjectdocs WHERE subdetails_id = ? AND status = 1 ORDER BY subjectdoc_id DESC");
                                if ($attach_stmt) {
                                    mysqli_stmt_bind_param($attach_stmt, 'i', $id);
                                    mysqli_stmt_execute($attach_stmt);
                                    $attach_res = mysqli_stmt_get_result($attach_stmt);
                                } else {
                                    $attach_res = null;
                                }
                                if ($attach_res && mysqli_num_rows($attach_res) > 0) {
                                ?>
                                    <div class="attachments-area" style="margin-top: 20px;width: 100%;">
                                        <h2>Attachments</h2>
                                        <table class="table table-responsive table-bordered table-condensed">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Type</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $count = 0;
                                                if ($attach_res) {
                                                while ($row = mysqli_fetch_assoc($attach_res)) {
                                                    $subjectdoc_id = (int)($row['subjectdoc_id'] ?? 0);
                                                    $ext = $row['ext'] ?? '';
                                                    $count++;
                                                ?>
                                                    <tr>
                                                        <td><?php echo 'Attachments ' . $count; ?></td>
                                                        <td><?php if (($ext == 'pdf') || ($ext == 'doc') || ($ext == 'docx') || ($ext == 'xls') || ($ext == 'xlsx')) {
                                                                echo 'Document';
                                                            } else {
                                                                echo 'Image';
                                                            }
                                                            ?></td>
                                                        <td>
                                                            <a href="https://parent.harvestacademy.ac.ug/download?path=attachments/subdocs/<?php echo htmlspecialchars(md5($subjectdoc_id) . '.' . $ext, ENT_QUOTES); ?>" class="btn btn-xs btn-primary">View</a>
                                                            <?php if ($can_edit) { ?>
                                                                <a href="removesubjectdoc?id=<?php echo htmlspecialchars($subjectdoc_id, ENT_QUOTES); ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $subjectdoc_id; ?>()">Remove</a>
                                                                <script type="text/javascript">
                                                                    function confirm_delete<?php echo $subjectdoc_id; ?>() {
                                                                        return confirm('You are about To Remove this Item. Are you sure you want to proceed?');
                                                                    }
                                                                </script>
                                                            <?php } ?>
                                                        </td>
                                                    </tr>
                                                <?php }
                                                if ($attach_stmt) mysqli_stmt_close($attach_stmt);
                                                } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </div>

        <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
        <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
        <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

        <!-- Custom and plugin javascript -->
        <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
        <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>


</body>

</html>