<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: ../login.php');
  exit;
}
$teacher_id = (int)$_SESSION['teachersys'];

// fetch active and upcoming substitutions for this teacher
$q = mysqli_prepare($con, "SELECT s.substitution_id, s.date, s.starttime, s.endtime, s.class_id, s.stream_id, s.class_sub_id, s.original_teacher_id, s.status, c.class AS class_name, st.stream AS stream_name, t1.fullname AS original_name, t2.fullname AS substitute_name FROM substitutions s LEFT JOIN classes c ON s.class_id=c.class_id LEFT JOIN streams st ON s.stream_id=st.stream_id LEFT JOIN teachers t1 ON s.original_teacher_id=t1.teacher_id LEFT JOIN teachers t2 ON s.substitute_teacher_id=t2.teacher_id WHERE s.substitute_teacher_id = ? ORDER BY s.date DESC LIMIT 100");
if ($q) {
  mysqli_stmt_bind_param($q, 'i', $teacher_id);
  mysqli_stmt_execute($q);
  $res = mysqli_stmt_get_result($q);
} else {
  $res = false;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>My Substitutions</title>
  <link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/bootstrap-fullcalendar.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
</head>
<body class="sticky-header">
  <section>
    <?php include 'nav.php'; ?>
    <div class="wrapper">
      <div class="row">
        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">My Substitutions</header>
            <div class="panel-body">
              <?php if ($res && mysqli_num_rows($res) > 0): ?>
                <div class="table-responsive">
                <table class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>Ref</th>
                      <th>Date</th>
                      <th>Time</th>
                      <th>Class</th>
                      <!-- <th>Stream</th> -->
                      <th>Subject</th>
                      <!-- <th>Original Teacher</th> -->
                      <th>Notes</th>
                      <th>Status</th>
                    </tr>
                  </thead>
                  <tbody>
                  <?php while ($r = mysqli_fetch_assoc($res)):
                    $sub_subject = '';
                    $csid = (int)($r['class_sub_id'] ?? 0);
                    if ($csid > 0) {
                      $ss = mysqli_query($con, "SELECT subject_id FROM class_subjects WHERE class_sub_id='" . $csid . "' LIMIT 1");
                      if ($ss && $srr = mysqli_fetch_assoc($ss)) {
                        $sid = (int)($srr['subject_id'] ?? 0);
                        if ($sid > 0) {
                          $snameq = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id='" . $sid . "' LIMIT 1");
                          if ($snameq && $sn = mysqli_fetch_assoc($snameq)) $sub_subject = $sn['subject'] ?? '';
                        }
                      }
                    }
                    
                    // Get notes from full query
                    $notes_query = mysqli_prepare($con, "SELECT notes FROM substitutions WHERE substitution_id = ? LIMIT 1");
                    $notes = '';
                    if ($notes_query) {
                      $sub_id = (int)$r['substitution_id'];
                      mysqli_stmt_bind_param($notes_query, 'i', $sub_id);
                      mysqli_stmt_execute($notes_query);
                      $notes_res = mysqli_stmt_get_result($notes_query);
                      if ($notes_res && $notes_row = mysqli_fetch_assoc($notes_res)) {
                        $notes = $notes_row['notes'] ?? '';
                      }
                      mysqli_stmt_close($notes_query);
                    }
                  ?>
                    <tr>
                      <td><?php echo (int)$r['substitution_id']; ?></td>
                      <td><?php echo htmlspecialchars($r['date'] ?? ''); ?></td>
                      <td><?php echo htmlspecialchars(($r['starttime'] ?? '') . ' - ' . ($r['endtime'] ?? '')); ?></td>
                      <td><?php echo htmlspecialchars($r['class_name'] ?? ''); ?></td>
                      <!-- <td><?php echo htmlspecialchars($r['stream_name'] ?? ''); ?></td> -->
                      <td><?php echo htmlspecialchars($sub_subject); ?></td>
                      <!-- <td><?php echo htmlspecialchars($r['original_name'] ?? 'N/A'); ?></td> -->
                      <td><?php echo !empty($notes) ? nl2br(htmlspecialchars($notes)) : '-'; ?></td>
                      <td><?php echo ((int)($r['status'] ?? 0) === 1) ? '<span class="label label-success">Active</span>' : '<span class="label label-default">Cancelled</span>'; ?></td>
                    </tr>
                  <?php endwhile; ?>
                  </tbody>
                </table>
                </div>
              <?php else: ?>
                <div class="alert alert-info">You have no substitutions assigned.</div>
              <?php endif; ?>
            </div>
          </section>
        </div>
      </div>
    </div>
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>
</html>