<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: ../login.php');
  exit;
}
$teacher_id = (int)$_SESSION['teachersys'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  header('Location: substitutions.php');
  exit;
}

// Prepare and execute safely; catch DB errors (e.g., missing table) to avoid HTTP 500
try {
  $q = mysqli_prepare($con, "SELECT s.*, t1.fullname AS original_name, t2.fullname AS substitute_name, c.class AS class_name, st.stream AS stream_name, cs.class_sub_id, sub.subject AS subject_name, u.fullname AS created_by_name FROM substitutions s LEFT JOIN teachers t1 ON s.original_teacher_id=t1.teacher_id LEFT JOIN teachers t2 ON s.substitute_teacher_id=t2.teacher_id LEFT JOIN classes c ON s.class_id=c.class_id LEFT JOIN streams st ON s.stream_id=st.stream_id LEFT JOIN class_subjects cs ON s.class_sub_id=cs.class_sub_id LEFT JOIN subjects sub ON cs.subject_id=sub.subject_id LEFT JOIN users u ON s.created_by = u.user_id WHERE s.substitution_id = ? LIMIT 1");
  if ($q) {
    mysqli_stmt_bind_param($q, 'i', $id);
    mysqli_stmt_execute($q);
    $res = mysqli_stmt_get_result($q);
    if ($res && mysqli_num_rows($res) > 0) {
      $r = mysqli_fetch_assoc($res);
    } else {
      header('Location: substitutions.php');
      exit;
    }
    mysqli_stmt_close($q);
  } else {
    // prepare failed but did not throw — redirect safely
    header('Location: substitutions.php');
    exit;
  }
} catch (Throwable $e) {
  // Log the error for debugging and show a friendly message instead of HTTP 500
  error_log('Substitution details DB error: ' . $e->getMessage());
  // redirect back to substitutions list with an error flag
  header('Location: substitutions.php?error=1');
  exit;
}
// Optional debug output for developers: append &debug=1 to the URL to see the raw row
if (isset($_GET['debug']) && $_GET['debug'] == '1' && !empty($r) && is_array($r)) {
  echo '<pre style="background:#fff;padding:10px;border:1px solid #ccc;">';
  echo "DEBUG: substitution row (escaped)\n";
  // show a safe, escaped dump
  foreach ($r as $k => $v) {
    echo htmlspecialchars((string)$k) . ' => ' . htmlspecialchars((string)(is_null($v) ? 'NULL' : $v)) . "\n";
  }
  echo '</pre>';
}

// Show whether the logged-in teacher is the substitute for this record (helps debug access/ownership)
$is_substitute = (!empty($r) && isset($r['substitute_teacher_id']) && ((int)$r['substitute_teacher_id'] === $teacher_id));
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Substitution Details</title>
  <link rel="stylesheet" href="../css/style.css">
  <link rel="stylesheet" href="../css/style-responsive.css">
  <script src="../js/jquery-1.11.3.min.js"></script>
</head>
<body class="sticky-header">
  <section>
    <?php include 'nav.php'; ?>
    <div class="wrapper">
      <div class="row">
        <div class="col-lg-8">
          <section class="panel">
            <header class="panel-heading">Substitution Details</header>
            <div class="panel-body">
              <?php if (!empty($r) && is_array($r)): ?>
              <?php if ($is_substitute): ?>
                <div class="alert alert-success">You are the substitute for this class.</div>
              <?php endif; ?>
              <table class="table table-bordered">
                <tr><th>Reference ID</th><td><?php echo (int)($r['substitution_id'] ?? 0); ?></td></tr>
                <tr><th>Date</th><td><?php echo htmlspecialchars($r['date'] ?? ''); ?></td></tr>
                <tr><th>Time</th><td><?php echo htmlspecialchars(($r['starttime'] ?? '') . ' - ' . ($r['endtime'] ?? '')); ?></td></tr>
                <tr><th>Class</th><td><?php echo htmlspecialchars($r['class_name'] ?? ''); ?></td></tr>
                <tr><th>Stream</th><td><?php echo htmlspecialchars($r['stream_name'] ?? ''); ?></td></tr>
                <tr><th>Subject</th><td><?php echo htmlspecialchars($r['subject_name'] ?? ($r['class_sub_id'] ?? '')); ?></td></tr>
                <tr><th>Original Teacher</th><td><?php echo htmlspecialchars($r['original_name'] ?? ''); ?></td></tr>
                <tr><th>Substitute Teacher</th><td><?php echo htmlspecialchars($r['substitute_name'] ?? ''); ?></td></tr>
                <tr><th>Assigned By</th><td><?php echo htmlspecialchars($r['created_by_name'] ?? ($r['created_by'] ?? '')); ?></td></tr>
                <tr><th>Created At</th><td><?php echo htmlspecialchars($r['created_at'] ?? ''); ?></td></tr>
                <tr><th>Notes</th><td><?php echo nl2br(htmlspecialchars($r['notes'] ?? '')); ?></td></tr>
                <tr><th>Status</th><td><?php echo ((int)($r['status'] ?? 0) === 1) ? 'Active' : 'Cancelled'; ?></td></tr>
              </table>
              <p><a href="substitutions.php">Back to My Substitutions</a></p>
              <?php else: ?>
                <div class="alert alert-warning">Substitution not found or you do not have access to it.</div>
                <p><a href="substitutions.php">Back to My Substitutions</a></p>
              <?php endif; ?>
            </div>
          </section>
        </div>
      </div>
    </div>
  </section>
  <script src="../js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="../js/bootstrap.min.js"></script>
  <script src="../js/scripts.js"></script>
</body>
</html>
