<?php
include '../includes/conn.php';

// session guard
if (!isset($_SESSION['teachersys'])) {
  header('Location:login.php');
  exit;
}

// cast session values
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);
?>
      
<body>
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                      <section class="panel">
                    <header class="panel-heading">
                      My Subjects
                    </header>
                          <div class="panel-body">
                                 <table  class="display table  table-striped" id="dynamic-table">
            <?php
            // Fetch teacher subjects via join
            $ts_stmt = mysqli_prepare($con, "
              SELECT s.subject_id, s.subject, c.class_id, c.class
              FROM teacher_subjects ts
              JOIN class_subjects cs ON ts.class_sub_id = cs.class_sub_id
              JOIN subjects s ON cs.subject_id = s.subject_id
              JOIN classes c ON cs.class_id = c.class_id
              WHERE ts.teacher_id = ?
            ");
            if ($ts_stmt) {
              mysqli_stmt_bind_param($ts_stmt, 'i', $teacher_id);
              mysqli_stmt_execute($ts_stmt);
              $ts_res = mysqli_stmt_get_result($ts_stmt);
              while ($row = mysqli_fetch_assoc($ts_res)) {
                $subject_id = (int)($row['subject_id'] ?? 0);
                $subject = $row['subject'] ?? '';
                $class = $row['class'] ?? '';
            ?>
                <tr class="gradeA">
                  <td><?php echo htmlspecialchars($subject, ENT_QUOTES); ?></td>
                  <td><?php echo htmlspecialchars($class, ENT_QUOTES); ?></td>
                  <td>
                    <a href="subject?id=<?php echo htmlspecialchars($subject_id, ENT_QUOTES); ?>" class="btn btn-success btn-xs">Lesson Plans</a>
                    <a href="editsubject?id=<?php echo htmlspecialchars($subject_id, ENT_QUOTES); ?>" class="btn btn-info btn-xs">Lesson Reports</a>
                  </td>
                </tr>
            <?php
              }
              mysqli_stmt_close($ts_stmt);
            }
            ?>
          </tbody>
                                    </table>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
    
    <!-- Mainly scripts -->
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

    
</body>

</html>