<?php
include '../includes/conn.php';

if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// cast class id from session
$id = (int)($_SESSION['class_id'] ?? 0);

// prepared statement to fetch class name
$class = '';
$class_stmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
if ($class_stmt) {
  mysqli_stmt_bind_param($class_stmt, 'i', $id);
  mysqli_stmt_execute($class_stmt);
  $cres = mysqli_stmt_get_result($class_stmt);
  $crow = mysqli_fetch_assoc($cres);
  $class = $crow['class'] ?? '';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>All <?php echo htmlspecialchars($class, ENT_QUOTES);?> Students</title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

                    <header class="panel-heading">
                      All <?php echo htmlspecialchars($class, ENT_QUOTES);?> Students
                    </header>
                          <div class="panel-body">
                            <table  class="display table  table-striped" id="dynamic-table">
        <thead>
        <tr>
             <th>Student No</th>
                                            <th>Full Names</th>
                                            <th>Nationality</th>
                                                              <th>Gender</th>
                                                                   <th>Action</th>
                  </tr>
        </thead>
        <tbody>

      <?php
            // load all terms once
            $terms = [];
            $terms_stmt = mysqli_prepare($con, "SELECT financialterm_id, term, year FROM financialterms ORDER BY year DESC, term DESC");
            if ($terms_stmt) {
              mysqli_stmt_execute($terms_stmt);
              $tres = mysqli_stmt_get_result($terms_stmt);
              while ($trow = mysqli_fetch_assoc($tres)) {
                $terms[] = $trow;
              }
              mysqli_stmt_close($terms_stmt);
            }

            // prepared statement to fetch students for this class
            $students_stmt = mysqli_prepare($con, "SELECT regnumber, student_id, fullname, gender, class_id, status, nationality, ext FROM students WHERE status = 1 AND class_id = ? ORDER BY fullname ASC");
            if ($students_stmt) {
              mysqli_stmt_bind_param($students_stmt, 'i', $id);
              mysqli_stmt_execute($students_stmt);
              $sres = mysqli_stmt_get_result($students_stmt);
            } else {
              die('DB prepare failed: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES));
            }

            // prepared statement to check if marks exist for a term and student
            $checkterm_stmt = mysqli_prepare($con, "SELECT 1 FROM marks WHERE term_id = ? AND student_id = ? LIMIT 1");

            // buffer for modal HTML to be printed after the table (avoid placing divs inside tbody)
            $modals = '';

            while ($row = mysqli_fetch_assoc($sres)) {
              $regnumber = $row['regnumber'] ?? '';
              $student_id = (int)($row['student_id'] ?? 0);
              $fullname = $row['fullname'] ?? '';
              $gender = $row['gender'] ?? '';
              $class_id = (int)($row['class_id'] ?? 0);
              $status = $row['status'] ?? '';
              $nationality = $row['nationality'] ?? '';
              $ext = $row['ext'] ?? '';
             ?>
         <tr class="gradeA">
                                 <td>
                                 <?php echo htmlspecialchars($regnumber, ENT_QUOTES); ?>
                             </td>
                      <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
                      <td>
                        <?php
                      echo htmlspecialchars($nationality, ENT_QUOTES);
                      ?></td>
                                    <td><?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
                                                                                    <td><a data-toggle="modal" href="#modal-form<?php echo $student_id; ?>" class="btn btn-success btn-xs"><i class="fa fa-edit"></i> View Report Card</a>
                                                                                </td>
                    </tr>
                    <?php
                    // Buffer modal markup so it can be printed after the table (valid DOM)
                    ob_start();
                    ?>
                    <div id="modal-form<?php echo $student_id; ?>" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                      <div class="modal-dialog">
                        <div class="modal-content">
                          <div class="modal-body">
                            <div class="row">
                              <div class="col-sm-12">
                                <h3 class="m-t-none m-b">Generate Report For <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></h3>
                                <form role="form" method="GET" action="progressreport" enctype="multipart/form-data">
                                  <input type="hidden" value="<?php echo $student_id;?>" name="std" >
                                  <div class="form-group">
                                    <label for="tm" class="control-label">Select Term and Year</label>
                                    <select id="tm" class="form-control" name="tm">
                                      <?php
                                      foreach ($terms as $t) {
                                        $financialterm_id = (int)$t['financialterm_id'];
                                        $term = $t['term'];
                                        $year = $t['year'];
                                        // check if marks exist for this student and term
                                        if ($checkterm_stmt) {
                                          mysqli_stmt_bind_param($checkterm_stmt, 'ii', $financialterm_id, $student_id);
                                          mysqli_stmt_execute($checkterm_stmt);
                                          $cres = mysqli_stmt_get_result($checkterm_stmt);
                                          if ($cres && mysqli_num_rows($cres) > 0) {
                                            echo '<option value="'.htmlspecialchars($financialterm_id, ENT_QUOTES).'">'.htmlspecialchars($term.' '.$year, ENT_QUOTES).'</option>';
                                          }
                                        }
                                      }
                                      ?>
                                    </select>
                                  </div>
                                  <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit"><strong>Proceed</strong></button>
                                </form>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <?php
                    $modals .= ob_get_clean();
                    ?>
            <?php }

            // close statements
            if ($checkterm_stmt) mysqli_stmt_close($checkterm_stmt);
            if ($students_stmt) mysqli_stmt_close($students_stmt);
            ?>
        </tbody>
      </table>
    </div>
    <?php
    // print any buffered modals here so they are outside the table/tbody
    if (!empty($modals)) echo $modals;
    ?>
    
<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL;?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>

<!-- Debug / fallback: ensure modal triggers work. This logs clicks and forces the modal to open. Remove in production if not needed. -->
<script>
  (function(){
    if (typeof jQuery === 'undefined') return;
    jQuery(function($){
      $(document).on('click', 'a[data-toggle="modal"]', function(e){
        try {
          var href = $(this).attr('href');
          if (!href) return;
          // support anchors like #modal-form123
          if (href.charAt(0) === '#') {
            e.preventDefault();
            console.log('Modal trigger clicked, target=', href);
            var target = $(href);
            if (target.length) {
              // ensure it's appended to body (Bootstrap expects modal as direct child of body)
              if (!$.contains(document.body, target[0])) {
                target.appendTo('body');
              }
              // try Bootstrap modal show
              if (typeof target.modal === 'function') {
                target.modal('show');
              } else {
                console.warn('Bootstrap modal plugin not available; toggling class manually');
                target.addClass('in').show();
              }
            } else {
              console.warn('Modal target not found in DOM:', href);
            }
          }
        } catch (err) {
          console.error('Modal fallback handler error:', err);
        }
      });
    });
  })();
</script>

</body>
</html>
