<?php
include '../includes/conn.php';

// session guard: redirect and exit if not logged in
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// validate and cast GET id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: students.php');
  exit;
}

// current teacher id from session
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Comments-School Manager</title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
                <div class="col-lg-3">
                        <?php
                        // prepared statement to fetch student
                        $student_stmt = mysqli_prepare($con, "SELECT regnumber, student_id, fullname, gender, number, class_id, nationality, ext FROM students WHERE status = 1 AND student_id = ? LIMIT 1");
                        if ($student_stmt) {
                            mysqli_stmt_bind_param($student_stmt, 'i', $id);
                            mysqli_stmt_execute($student_stmt);
                            $sres = mysqli_stmt_get_result($student_stmt);
                            $srow = mysqli_fetch_assoc($sres);
                            $regnumber = $srow['regnumber'] ?? '';
                            $student_id = (int)($srow['student_id'] ?? 0);
                            $fullname = $srow['fullname'] ?? '';
                            $gender = $srow['gender'] ?? '';
                            $number = $srow['number'] ?? '';
                            $class_id = (int)($srow['class_id'] ?? 0);
                            $nationality = $srow['nationality'] ?? '';
                            $ext = $srow['ext'] ?? '';
                        } else {
                            die('DB prepare failed: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES));
                        }
                        ?>
                      <section class="panel">
                    <header class="panel-heading">
                     <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                    </header>
                          <div class="panel-body">      
                                 <img src="<?php echo BASE_URL;?>/images/students/<?php echo md5($id).'.'.htmlspecialchars($ext, ENT_QUOTES).'?'.time(); ?>" class="img img-responsive">
                              </div>
                              </div>
    <div class="col-lg-9">
                      <section class="panel">
                    <header class="panel-heading">
                  My Comments
                    </header>
                          <div class="panel-body">      
           
      <table  class="display table  table-striped" id="dynamic-table">
        <thead>
        <tr>
                                                   <th>Date</th>
                                            <th>Comment</th>
                                                                                                            
                                                                   <th>Action</th>
                  </tr>
        </thead>
        <tbody>
             <?php
                         // prepared statement to fetch comments for this student by this teacher
                         $comments_stmt = mysqli_prepare($con, "SELECT tcomment_id, comment, date FROM tcomments WHERE student_id = ? AND teacher_id = ? AND status = 1 ORDER BY date DESC");
                         if ($comments_stmt) {
                             mysqli_stmt_bind_param($comments_stmt, 'ii', $id, $teacher_id);
                             mysqli_stmt_execute($comments_stmt);
                             $cres = mysqli_stmt_get_result($comments_stmt);
                             while ($row = mysqli_fetch_assoc($cres)) {
                                 $tcomment_id = (int)($row['tcomment_id'] ?? 0);
                                 $comment = $row['comment'] ?? '';
                                 $date = (int)($row['date'] ?? 0);
                             ?>
            <tr>
                <td><?php echo date('d/M/Y', $date); ?></td>
                <td><?php echo nl2br(htmlspecialchars($comment, ENT_QUOTES)); ?></td>
                <td>
                    <a href="edittcomment?id=<?php echo $tcomment_id;?>" class="btn btn-xs btn-info">Edit</a>
                    <a href="removetcomment?id=<?php echo $tcomment_id;?>" class="btn btn-xs btn-danger" onclick="return confirm('You are about To Remove this Item. Are you sure you want to proceed?')">Remove</a>
                </td>
            </tr>
            <?php
                             }
                         } else {
                             echo '<tr><td colspan="3">Unable to load comments.</td></tr>';
                         }
                                 ?>
        </tbody>
        </table>
                       </div>
                          </div>
   
        </div>


        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL;?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>
  
</body>

</html>
 