<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  echo '<div class="alert alert-danger">Invalid report id</div>';
  exit;
}

// Fetch report (use limited columns and associative fetch)
// fetch report using prepared statement
$report = '';
$term = '';
$year = '';
$timestamp = '';
$term_id = 0;
$stmt = mysqli_prepare($con, "SELECT report_id, report, timestamp, term_id FROM reports WHERE report_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $row2 = mysqli_fetch_assoc($res);
    mysqli_stmt_close($stmt);
} else {
    $row2 = null;
}

if ($row2) {
    $report_id = (int)($row2['report_id'] ?? 0);
    $report = $row2['report'] ?? '';
    $timestamp = $row2['timestamp'] ?? '';
    $term_id = (int)($row2['term_id'] ?? 0);

    // fetch term info via prepared statement
    $stmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'i', $term_id);
        mysqli_stmt_execute($stmt);
        $res = mysqli_stmt_get_result($stmt);
        if ($row1 = mysqli_fetch_assoc($res)) {
            $term = $row1['term'] ?? '';
            $year = $row1['year'] ?? '';
        }
        mysqli_stmt_close($stmt);
    }
} else {
    echo '<div class="alert alert-danger">Report not found</div>';
    exit;
}
              ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>     End of  Term <?php echo $term.' '.$year;?>  Report</title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
              End of Term <?php echo $term.' '.$year;?>  Report
                    </header>
                          <div class="panel-body">
                 <?php
                               echo $report;
                 ?>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL;?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>

</body>
</html>
