<?php
// ensure session started
if (session_status() !== PHP_SESSION_ACTIVE) {
   session_start();
}
include '../includes/conn.php';

// require authenticated teacher
if (!isset($_SESSION['teachersys'])) {
   header('Location: login.php');
   exit;
}

// validate id (GET)
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
   $redirect = $_SERVER['HTTP_REFERER'] ?? 'weeklyplan.php';
   header('Location: ' . $redirect);
   exit;
}

// use prepared statement to soft-delete the weekly plan
$stmt = mysqli_prepare($con, "UPDATE weeklyplans SET status = 0 WHERE weeklyplan_id = ? LIMIT 1");
if ($stmt) {
   mysqli_stmt_bind_param($stmt, 'i', $id);
   mysqli_stmt_execute($stmt);
   mysqli_stmt_close($stmt);
}

$redirect = $_SERVER['HTTP_REFERER'] ?? 'weeklyplan.php';
header('Location: ' . $redirect);
exit;
?>