<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location:login.php');
    exit;
}

// validate inputs
$classs_id = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
$subjects_id = filter_input(INPUT_GET, 'sub', FILTER_VALIDATE_INT);
$tm = filter_input(INPUT_GET, 'tm', FILTER_VALIDATE_INT);
$date = isset($_GET['dt']) ? trim((string)$_GET['dt']) : '';

if (!$classs_id || !$subjects_id || !$tm || !$date) {
    $redirect = $_SERVER['HTTP_REFERER'] ?? 'reports.php';
    header('Location: ' . $redirect);
    exit;
}

// use prepared statement with escaped date (to avoid DATE column binding issues)
$date_escaped = mysqli_real_escape_string($con, $date);
$sql = "UPDATE marks SET status = 0 WHERE class_id = ? AND subject_id = ? AND term_id = ? AND date = '$date_escaped'";
$stmt = mysqli_prepare($con, $sql);
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'iii', $classs_id, $subjects_id, $tm);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

$redirect = $_SERVER['HTTP_REFERER'] ?? 'reports.php';
header('Location: ' . $redirect);
exit;
?>