<?php
include '../includes/conn.php';
// ensure teacher is logged in; if not, redirect to login and stop
if (!isset($_SESSION['teachersys'])) {
   header('Location: login.php');
   exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
   $redirect = $_SERVER['HTTP_REFERER'] ?? 'longtermplan.php';
   header('Location: ' . $redirect);
   exit;
}

// use prepared statement
$stmt = mysqli_prepare($con, "UPDATE longterm_plans SET status = 0 WHERE long_term_id = ? LIMIT 1");
if ($stmt) {
   mysqli_stmt_bind_param($stmt, 'i', $id);
   mysqli_stmt_execute($stmt);
   mysqli_stmt_close($stmt);
}

$redirect = $_SERVER['HTTP_REFERER'] ?? 'longtermplan.php';
header('Location: ' . $redirect);
exit;
?>