<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}

// validate and parse class parameter (expected format: "{class_id}_{stream_id}")
$classParam = filter_input(INPUT_GET, 'class', FILTER_SANITIZE_STRING);
if (!$classParam) {
    echo '<div class="alert alert-danger">Invalid class parameter.</div>';
    exit;
}
$parts = explode('_', $classParam);
$class_id = isset($parts[0]) ? (int)$parts[0] : 0;
$stream_id = isset($parts[1]) ? (int)$parts[1] : 0;

// fetch class name
$class = '';
$cstmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
if ($cstmt) {
    mysqli_stmt_bind_param($cstmt, 'i', $class_id);
    mysqli_stmt_execute($cstmt);
    $cres = mysqli_stmt_get_result($cstmt);
    if ($cres && mysqli_num_rows($cres) > 0) {
        $crow = mysqli_fetch_assoc($cres);
        $class = $crow['class'] ?? '';
    }
    mysqli_stmt_close($cstmt);
}

// fetch stream name
$stream = '';
$sstmt = mysqli_prepare($con, "SELECT stream FROM streams WHERE stream_id = ? LIMIT 1");
if ($sstmt) {
    mysqli_stmt_bind_param($sstmt, 'i', $stream_id);
    mysqli_stmt_execute($sstmt);
    $sres = mysqli_stmt_get_result($sstmt);
    if ($sres && mysqli_num_rows($sres) > 0) {
        $srow = mysqli_fetch_assoc($sres);
        $stream = $srow['stream'] ?? '';
    }
    mysqli_stmt_close($sstmt);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">

    <title><?php echo $class . ' ' . $stream; ?> Weekly TimeTable</title>
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body style="background: #fff;">

    <!-- page start-->

    <div class="row">

        <div class="col-lg-10 col-lg-offset-1">

            <header class="panel-heading">
                <h2 style="text-align: center;"><?php echo $class . ' ' . $stream; ?> Weekly TimeTable </h2>
            </header>
            <div class="panel-body">
                <?php
                // Get all unique time slots for this class
                // Handle stream_id=0 as "any stream" or no stream filter
                if ($stream_id > 0) {
                    $tsStmt = mysqli_prepare($con, "SELECT DISTINCT starttime, endtime FROM timetables WHERE class_id = ? AND stream_id = ? ORDER BY starttime");
                } else {
                    $tsStmt = mysqli_prepare($con, "SELECT DISTINCT starttime, endtime FROM timetables WHERE class_id = ? ORDER BY starttime");
                }
                
                if ($tsStmt) {
                    if ($stream_id > 0) {
                        mysqli_stmt_bind_param($tsStmt, 'ii', $class_id, $stream_id);
                    } else {
                        mysqli_stmt_bind_param($tsStmt, 'i', $class_id);
                    }
                    mysqli_stmt_execute($tsStmt);
                    $time_slots_query = mysqli_stmt_get_result($tsStmt);
                } else {
                    $time_slots_query = null;
                }

                // Get all days (use short column) in correct week order
                $days = array();
                $dstmt = mysqli_prepare($con, "SELECT short FROM days ORDER BY FIELD(day, 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday')");
                if ($dstmt) {
                    mysqli_stmt_execute($dstmt);
                    $dres = mysqli_stmt_get_result($dstmt);
                    if ($dres) {
                        while ($day_row = mysqli_fetch_assoc($dres)) {
                            $days[] = $day_row['short'];
                        }
                    }
                    mysqli_stmt_close($dstmt);
                }
                
                // Fallback: if no days from database, use default days
                if (empty($days)) {
                    $days = ['Mon', 'Tue', 'Wed', 'Thur', 'Fri'];
                }
                ?>

                <div class="table-responsive">
                    <?php if ($time_slots_query && mysqli_num_rows($time_slots_query) > 0): ?>
                    <table class="table table-bordered" style="border-collapse: collapse; width: 100%;">
                        <thead>
                            <tr>
                                <th style="border: 1px solid #000; padding: 8px;">Time</th>
                                <?php foreach ($days as $day): ?>
                                    <th style="border: 1px solid #000; padding: 8px;"><?php echo strtoupper($day); ?></th>
                                <?php endforeach; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($time_slot = mysqli_fetch_assoc($time_slots_query)): ?>
                                <tr>
                                    <td style="border: 1px solid #000; padding: 8px;"><?php echo htmlspecialchars($time_slot['starttime'] . ' - ' . $time_slot['endtime'], ENT_QUOTES); ?></td>
                                    <?php
                                    // prepare subject lookup once (reuse statement based on stream_id)
                                    if ($stream_id > 0) {
                                        $cellStmt = mysqli_prepare($con, "SELECT t.activity, cs.class_sub_id, s.subject FROM timetables t LEFT JOIN class_subjects cs ON t.activity = cs.class_sub_id LEFT JOIN subjects s ON cs.subject_id = s.subject_id WHERE t.class_id = ? AND t.stream_id = ? AND t.day = ? AND t.starttime = ? AND t.endtime = ? LIMIT 1");
                                    } else {
                                        $cellStmt = mysqli_prepare($con, "SELECT t.activity, cs.class_sub_id, s.subject FROM timetables t LEFT JOIN class_subjects cs ON t.activity = cs.class_sub_id LEFT JOIN subjects s ON cs.subject_id = s.subject_id WHERE t.class_id = ? AND t.day = ? AND t.starttime = ? AND t.endtime = ? LIMIT 1");
                                    }
                                    
                                    foreach ($days as $day): ?>
                                        <td style="border: 1px solid #000; padding: 8px;">
                                            <?php
                                            $display = '-';
                                            if ($cellStmt) {
                                                if ($stream_id > 0) {
                                                    mysqli_stmt_bind_param($cellStmt, 'iisss', $class_id, $stream_id, $day, $time_slot['starttime'], $time_slot['endtime']);
                                                } else {
                                                    mysqli_stmt_bind_param($cellStmt, 'isss', $class_id, $day, $time_slot['starttime'], $time_slot['endtime']);
                                                }
                                                mysqli_stmt_execute($cellStmt);
                                                $cres = mysqli_stmt_get_result($cellStmt);
                                                if ($cres && mysqli_num_rows($cres) > 0) {
                                                    $subject_row = mysqli_fetch_assoc($cres);
                                                    if (!empty($subject_row['subject'])) {
                                                        $display = $subject_row['subject'];
                                                    } elseif (!empty($subject_row['activity'])) {
                                                        $display = $subject_row['activity'];
                                                    }
                                                }
                                            }
                                            echo htmlspecialchars($display, ENT_QUOTES);
                                            ?>
                                        </td>
                                    <?php endforeach;
                                    if ($cellStmt) mysqli_stmt_close($cellStmt);
                                    ?>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    <?php else: ?>
                        <div class="alert alert-info">No timetable data found for <?php echo htmlspecialchars($class . ' ' . $stream); ?>. Please ensure the timetable has been created.</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>


    </div>

    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->

    <!-- Placed js at the end of the document so the pages load faster -->
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/modernizr.min.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    <script src="js/dynamic_table_init.js"></script>
    <!--common scripts for all pages-->
    <script src="js/scripts.js"></script>
    <script type="text/javascript">
        window.print();
    </script>
</body>

</html>