<?php
include '../includes/conn.php';
if(!isset($_SESSION['teachersys'])){
  header('Location:login.php');
  exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location:attendance.php');
  exit;
}

// Load attendance record via prepared statement
$attendance = null;
$attendanceStmt = mysqli_prepare($con, "SELECT attendance_id, date, time FROM attendance WHERE status=1 AND attendance_id = ? LIMIT 1");
if ($attendanceStmt) {
  mysqli_stmt_bind_param($attendanceStmt, 'i', $id);
  mysqli_stmt_execute($attendanceStmt);
  $res = mysqli_stmt_get_result($attendanceStmt);
  if ($res && $row1 = mysqli_fetch_assoc($res)) {
    $date = $row1['date'] ?? '';  // date is now stored as DATE (Y-m-d)
    $time = $row1['time'] ?? '';
    $attendance_id = (int)($row1['attendance_id'] ?? 0);
  } else {
    // not found
    header('Location:attendance.php');
    exit;
  }
  mysqli_stmt_close($attendanceStmt);
} else {
  // fallback: redirect
  header('Location:attendance.php');
  exit;
}

// Format date for display
$date_formatted = '';
if ($date) {
  $date_obj = DateTime::createFromFormat('Y-m-d', $date);
  $date_formatted = $date_obj ? $date_obj->format('d/M/Y') : $date;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Print Attendance Details - <?php echo htmlspecialchars($date_formatted);?></title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <style>
    @media print {
      .no-print { display: none; }
    }
    body {
      font-family: Arial, sans-serif;
      padding: 20px;
    }
    h2 {
      text-align: center;
      margin-bottom: 10px;
    }
    h3 {
      text-align: center;
      margin-top: 0;
      color: #666;
    }
    .section {
      margin-bottom: 30px;
    }
    .section h4 {
      background-color: #f0f0f0;
      padding: 10px;
      margin-bottom: 10px;
      border-left: 4px solid #4CAF50;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 20px;
    }
    table th {
      background-color: #4CAF50;
      color: white;
      padding: 12px;
      text-align: left;
      border: 1px solid #ddd;
    }
    table td {
      padding: 10px;
      border: 1px solid #ddd;
    }
    table tr:nth-child(even) {
      background-color: #f9f9f9;
    }
    .print-btn {
      text-align: center;
      margin-bottom: 20px;
    }
    .print-btn button {
      background-color: #4CAF50;
      color: white;
      padding: 10px 20px;
      border: none;
      cursor: pointer;
      font-size: 16px;
    }
    .print-btn button:hover {
      background-color: #45a049;
    }
  </style>
</head>
<body>
  <div class="no-print print-btn">
    <button onclick="window.print()">Print</button>
    <button onclick="window.close()" style="background-color: #f44336;">Close</button>
  </div>

  <h2>Attendance Details</h2>
  <h3><?php 
  if ($date) {
    $date_obj = DateTime::createFromFormat('Y-m-d', $date);
    echo $date_obj ? $date_obj->format('l, F j, Y') : $date;
  }
  echo ' at ' . htmlspecialchars($time); 
  ?></h3>

  <!-- Present Students -->
  <div class="section">
    <h4>Present Students</h4>
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Full Name</th>
          <th>Gender</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $count = 1;
        $attDetStmt = mysqli_prepare($con, "SELECT student_id FROM attendancedetails WHERE attendance_id = ? AND status = 1");
        if ($attDetStmt) {
          mysqli_stmt_bind_param($attDetStmt, 'i', $attendance_id);
          mysqli_stmt_execute($attDetStmt);
          $attendees = mysqli_stmt_get_result($attDetStmt);
          $has_present = false;
          while ($row1 = mysqli_fetch_assoc($attendees)) {
            $has_present = true;
            $student_id = (int)($row1['student_id'] ?? 0);
            $studentStmt = mysqli_prepare($con, "SELECT fullname, gender FROM students WHERE student_id = ? LIMIT 1");
            $fullname = '';
            $gender = '';
            if ($studentStmt && $student_id) { 
              mysqli_stmt_bind_param($studentStmt, 'i', $student_id);
              mysqli_stmt_execute($studentStmt);
              $sres = mysqli_stmt_get_result($studentStmt);
              if ($sres && $srow = mysqli_fetch_assoc($sres)) {
                $fullname = $srow['fullname'] ?? '';
                $gender = $srow['gender'] ?? '';
              }
              mysqli_stmt_close($studentStmt);
            }
            ?>
            <tr>
              <td><?php echo $count++; ?></td>
              <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
              <td><?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
            </tr>
        <?php } 
          mysqli_stmt_close($attDetStmt);
          if (!$has_present) {
            echo '<tr><td colspan="3" style="text-align:center;">No students present</td></tr>';
          }
        } 
        ?>
      </tbody>
    </table>
  </div>

  <!-- Late Students -->
  <div class="section">
    <h4>Late Students</h4>
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Full Name</th>
          <th>Gender</th>
          <th>Details</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $count = 1;
        $attendees_L_stmt = mysqli_prepare($con, "SELECT student_id, details FROM attendancedetails WHERE attendance_id = ? AND status = 2");
        if ($attendees_L_stmt) {
          mysqli_stmt_bind_param($attendees_L_stmt, 'i', $attendance_id);
          mysqli_stmt_execute($attendees_L_stmt);
          $attendees_L = mysqli_stmt_get_result($attendees_L_stmt);
          $has_late = false;
          while ($row1 = mysqli_fetch_assoc($attendees_L)) {
            $has_late = true;
            $student_id = (int)($row1['student_id'] ?? 0);
            $details = $row1['details'] ?? '';
            $studentStmt = mysqli_prepare($con, "SELECT fullname, gender FROM students WHERE student_id = ? LIMIT 1");
            $fullname = '';
            $gender = '';
            if ($studentStmt && $student_id) { 
              mysqli_stmt_bind_param($studentStmt, 'i', $student_id);
              mysqli_stmt_execute($studentStmt);
              $sres = mysqli_stmt_get_result($studentStmt);
              if ($sres && $srow = mysqli_fetch_assoc($sres)) {
                $fullname = $srow['fullname'] ?? '';
                $gender = $srow['gender'] ?? '';
              }
              mysqli_stmt_close($studentStmt);
            }
            ?>
            <tr>
              <td><?php echo $count++; ?></td>
              <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
              <td><?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
              <td><?php echo htmlspecialchars($details, ENT_QUOTES); ?></td>
            </tr>
        <?php } 
          mysqli_stmt_close($attendees_L_stmt);
          if (!$has_late) {
            echo '<tr><td colspan="4" style="text-align:center;">No late students</td></tr>';
          }
        } 
        ?>
      </tbody>
    </table>
  </div>

  <!-- Absent Students -->
  <div class="section">
    <h4>Absent Students</h4>
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Full Name</th>
          <th>Gender</th>
          <th>Details</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $count = 1;
        $attendees_abs_stmt = mysqli_prepare($con, "SELECT student_id, details FROM attendancedetails WHERE attendance_id = ? AND status = 0");
        if ($attendees_abs_stmt) {
          mysqli_stmt_bind_param($attendees_abs_stmt, 'i', $attendance_id);
          mysqli_stmt_execute($attendees_abs_stmt);
          $attendees_abs = mysqli_stmt_get_result($attendees_abs_stmt);
          $has_absent = false;
          while ($row1 = mysqli_fetch_assoc($attendees_abs)) {
            $has_absent = true;
            $student_id = (int)($row1['student_id'] ?? 0);
            $details = $row1['details'] ?? '';
            $studentStmt = mysqli_prepare($con, "SELECT fullname, gender FROM students WHERE student_id = ? LIMIT 1");
            $fullname = '';
            $gender = '';
            if ($studentStmt && $student_id) { 
              mysqli_stmt_bind_param($studentStmt, 'i', $student_id);
              mysqli_stmt_execute($studentStmt);
              $sres = mysqli_stmt_get_result($studentStmt);
              if ($sres && $srow = mysqli_fetch_assoc($sres)) {
                $fullname = $srow['fullname'] ?? '';
                $gender = $srow['gender'] ?? '';
              }
              mysqli_stmt_close($studentStmt);
            }
            ?>
            <tr>
              <td><?php echo $count++; ?></td>
              <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
              <td><?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
              <td><?php echo htmlspecialchars($details, ENT_QUOTES); ?></td>
            </tr>
        <?php } 
          mysqli_stmt_close($attendees_abs_stmt);
          if (!$has_absent) {
            echo '<tr><td colspan="4" style="text-align:center;">No absent students</td></tr>';
          }
        } 
        ?>
      </tbody>
    </table>
  </div>

  <script>
    // Auto-print when page loads
    window.onload = function() {
      window.print();
    }
  </script>
</body>
</html>
