<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}

// Validate input and session values
$term_id = filter_input(INPUT_GET, 'term', FILTER_VALIDATE_INT);
if (!$term_id) {
  echo '<div class="alert alert-danger">Invalid term parameter</div>';
  exit;
}
$session_class = filter_var($_SESSION['class_id'] ?? 0, FILTER_VALIDATE_INT);

// Load term info
$term = '';
$year = '';
$termStmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
if ($termStmt) {
  mysqli_stmt_bind_param($termStmt, 'i', $term_id);
  mysqli_stmt_execute($termStmt);
  $tres = mysqli_stmt_get_result($termStmt);
  if ($tres && $trow = mysqli_fetch_assoc($tres)) {
    $term = $trow['term'] ?? '';
    $year = $trow['year'] ?? '';
  }
  mysqli_stmt_close($termStmt);
}

// Load class name
$class = '';
if ($session_class) {
  $classStmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
  if ($classStmt) {
    mysqli_stmt_bind_param($classStmt, 'i', $session_class);
    mysqli_stmt_execute($classStmt);
    $cres = mysqli_stmt_get_result($classStmt);
    if ($cres && $crow = mysqli_fetch_assoc($cres)) {
      $class = $crow['class'] ?? '';
    }
    mysqli_stmt_close($classStmt);
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Attendance for <?php echo htmlspecialchars($class.' Term '.$term.' '.$year); ?></title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 20px;
      background: #fff;
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #000;
      padding: 8px;
      text-align: left;
    }
    th {
      background-color: #f0f0f0;
      font-weight: bold;
    }
    @media print {
      .no-print {
        display: none;
      }
    }
  </style>
</head>
<body>
  <h2>Attendance for <?php echo htmlspecialchars($class.' Term '.$term.' '.$year); ?></h2>
  
  <table>
    <thead>
      <tr>
        <th>Date</th>
        <th>Time</th>
        <th>Attendees</th>
        <th>Late</th>
        <th>Absentees</th>
        <th>Total</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $attStmt = mysqli_prepare($con, "SELECT attendance_id, date, time FROM attendance WHERE status=1 AND term_id=? AND class_id=? ORDER BY date DESC");
      if ($attStmt) {
        mysqli_stmt_bind_param($attStmt, 'ii', $term_id, $session_class);
        mysqli_stmt_execute($attStmt);
        $attendance = mysqli_stmt_get_result($attStmt);
        
        while ($row1 = mysqli_fetch_assoc($attendance)) {
          $date = $row1['date'] ?? '';  // date is now stored as DATE (Y-m-d)
          $time = $row1['time'] ?? '';
          $attendance_id = (int)($row1['attendance_id'] ?? 0);
          
          // Format date for display
          $date_formatted = '';
          if ($date) {
            $date_obj = DateTime::createFromFormat('Y-m-d', $date);
            $date_formatted = $date_obj ? $date_obj->format('d/M/Y') : $date;
          }
          
          // Count attendees
          $countStmt = mysqli_prepare($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE attendance_id = ? AND status = ?");
          $attendees = 0;
          $late = 0;
          $absentees = 0;
          
          if ($countStmt) {
            // Attendees (status = 1)
            $s = 1;
            mysqli_stmt_bind_param($countStmt, 'ii', $attendance_id, $s);
            mysqli_stmt_execute($countStmt);
            $cres = mysqli_stmt_get_result($countStmt);
            if ($cres && $crow = mysqli_fetch_assoc($cres)) $attendees = (int)$crow['cnt'];
            
            // Late (status = 2)
            $s = 2;
            mysqli_stmt_bind_param($countStmt, 'ii', $attendance_id, $s);
            mysqli_stmt_execute($countStmt);
            $cres = mysqli_stmt_get_result($countStmt);
            if ($cres && $crow = mysqli_fetch_assoc($cres)) $late = (int)$crow['cnt'];
            
            // Absentees (status = 0)
            $s = 0;
            mysqli_stmt_bind_param($countStmt, 'ii', $attendance_id, $s);
            mysqli_stmt_execute($countStmt);
            $cres = mysqli_stmt_get_result($countStmt);
            if ($cres && $crow = mysqli_fetch_assoc($cres)) $absentees = (int)$crow['cnt'];
            
            mysqli_stmt_close($countStmt);
          }
          
          $total = $attendees + $late + $absentees;
      ?>
        <tr>
          <td><?php echo htmlspecialchars($date_formatted); ?></td>
          <td><?php echo htmlspecialchars($time); ?></td>
          <td><?php echo $attendees; ?></td>
          <td><?php echo $late; ?></td>
          <td><?php echo $absentees; ?></td>
          <td><?php echo $total; ?></td>
        </tr>
      <?php 
        }
        mysqli_stmt_close($attStmt);
      } else {
        echo '<tr><td colspan="6">No attendance records found</td></tr>';
      }
      ?>
    </tbody>
  </table>
  
  <div style="margin-top: 30px; text-align: center;" class="no-print">
    <button onclick="window.print()" style="padding: 10px 20px; font-size: 16px; cursor: pointer;">Print This Page</button>
    <button onclick="window.close()" style="padding: 10px 20px; font-size: 16px; cursor: pointer; margin-left: 10px;">Close</button>
  </div>
  
  <script>
    // Auto-trigger print dialog when page loads
    window.onload = function() {
      window.print();
    };
  </script>
</body>
</html>
