<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$teacher_id = (int)$_SESSION['teachersys'];

$employee = mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id={$teacher_id}");
$row = $employee ? mysqli_fetch_assoc($employee) : null;
$fullname = $row['fullname'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <title><?php echo htmlspecialchars($fullname); ?> Weekly TimeTable</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <style>
    /* Clean print view: hide sidebar and header and use full page width when printing */
    @media print {
      @page { size: auto; margin: 6mm; }
      html, body { width: 100% !important; height: 100% !important; margin: 0; padding: 0; }
      .left-side, .header-section, .btn-print-hide, .footer-section { display: none !important; }
      /* hide interactive controls and icons that can render as <> in print */
      .btn, a.btn, .btn-xs, .btn-sm, .fa, .glyphicon, .icon, .pagination, .dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_info, .dataTables_paginate { display: none !important; }
      /* Make the main content occupy full page width */
      .main-content, .wrapper { width: 100% !important; max-width: 100% !important; margin: 0 !important; padding: 0 !important; }
      .col-lg-10.col-lg-offset-1 { width: 100% !important; margin: 0 !important; float: none !important; }
      .panel { border: none !important; box-shadow: none !important; margin: 0 !important; }
      .table { width: 100% !important; }
      /* Improve table printing */
      table.table { border-collapse: collapse !important; }
      table.table th, table.table td { border: 1px solid #ccc !important; padding: 6px !important; }
      /* Avoid page breaks inside rows */
      tr { page-break-inside: avoid; }
    }
  </style>
</head>
<body>
<section>
  <?php include 'nav.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-10 col-lg-offset-1">
        <section class="panel">
          <header class="panel-heading">
            <h2 style="display:inline-block"><?php echo htmlspecialchars($fullname); ?> Weekly TimeTable</h2>
            <a href="#" class="btn btn-info pull-right btn-print-hide" style="margin-top:6px;" onclick="window.print();return false;"><i class="fa fa-print"></i> Print</a>
          </header>
          <div class="panel-body">
            <?php
            $getdays = mysqli_query($con, "SELECT * FROM days");
            if ($getdays) {
              while ($roww = mysqli_fetch_assoc($getdays)) {
                $day = $roww['day'] ?? '';
                $short = $roww['short'] ?? '';
                // fetch all timetable slots for this day (global), then only show columns where this teacher teaches
                $timetable = mysqli_query($con, "SELECT * FROM `timetables` WHERE `day`='" . mysqli_real_escape_string($con, $short) . "' ORDER BY `position`");
                if ($timetable && mysqli_num_rows($timetable) > 0) {
                  ?>
                  <h4 style="color:#333;font-weight:bold;text-transform:uppercase"><?php echo htmlspecialchars($day); ?></h4>
                  <div class="table-responsive">
                    <table class="table table-bordered table-striped" style="margin-bottom:20px;">
                      <thead>
                        <tr>
                          <th style="width:140px">Time</th>
                          <th>Subject</th>
                          <th>Class / Stream</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        // iterate slots and render one row per slot where this teacher teaches
                        $timetable_rows = [];
                        mysqli_data_seek($timetable, 0);
                        while ($slot = mysqli_fetch_assoc($timetable)) {
                          $timetable_rows[] = $slot;
                        }
                        $has_rows = false;
                        foreach ($timetable_rows as $slot) {
                          $starttime = $slot['starttime'] ?? '';
                          $endtime = $slot['endtime'] ?? '';
                          $activity = (int)($slot['activity'] ?? 0);
                          // check teacher assignment
                          $tsq = mysqli_query($con, "SELECT 1 FROM teacher_subjects WHERE teacher_id={$teacher_id} AND class_sub_id={$activity} LIMIT 1");
                          if (!($tsq && mysqli_num_rows($tsq) > 0)) {
                            continue;
                          }
                          $has_rows = true;
                          $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_sub_id={$activity} LIMIT 1");
                          $cs = $class_subjects ? mysqli_fetch_assoc($class_subjects) : null;
                          $subject_id = (int)($cs['subject_id'] ?? 0);
                          $class_id2 = (int)($cs['class_id'] ?? 0);

                          $subject = '';
                          if ($subject_id > 0) {
                            $gsub = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id={$subject_id} LIMIT 1");
                            if ($gsub && $r = mysqli_fetch_assoc($gsub)) $subject = $r['subject'] ?? '';
                          }

                          $class_label = '';
                          if ($class_id2 > 0) {
                            $gcl = mysqli_query($con, "SELECT class FROM classes WHERE class_id={$class_id2} LIMIT 1");
                            if ($gcl && $r2 = mysqli_fetch_assoc($gcl)) $class_label = $r2['class'] ?? '';
                          }
                          $stream_label = '';
                          $stream_id = (int)($slot['stream_id'] ?? 0);
                          if ($stream_id > 0) {
                            $gst = mysqli_query($con, "SELECT stream FROM streams WHERE stream_id={$stream_id} LIMIT 1");
                            if ($gst && $r3 = mysqli_fetch_assoc($gst)) $stream_label = $r3['stream'] ?? '';
                          }
                          ?>
                          <tr>
                            <td><?php echo htmlspecialchars(($starttime ?? '') . ' - ' . ($endtime ?? '')); ?></td>
                            <td><?php echo htmlspecialchars($subject ?: ($slot['activity'] ?? '-')); ?></td>
                            <td><?php echo htmlspecialchars(trim(($class_label ? $class_label : '') . ' ' . ($stream_label ? $stream_label : '')) ?: '-'); ?></td>
                          </tr>
                        <?php }
                        if (!$has_rows) {
                          echo '<tr><td colspan="3">No timetable entries for this day.</td></tr>';
                        }
                        ?>
                      </tbody>
                    </table>
                  </div>
                <?php
                } else {
                  echo '<div class="alert alert-danger">Timetable for ' . htmlspecialchars($day) . ' Coming Soon</div>';
                }
              }
            }
            ?>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
