<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  echo '<div class="alert alert-danger">Invalid request.</div>';
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>
  <style type="text/css" media="print">
    @page {
      size: auto;
      /* auto is the initial value */
      margin: 0;
      /* this affects the margin in the printer settings */
    }
  </style>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Subject Mid term Plan</title>
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/bootstrap.min.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/animate.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/style.css" rel="stylesheet">


  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="white-bg">
  <div class="wrapper wrapper-content p-xl">
    <div class="ibox-content p-xl">
      <div class="row" style="margin-bottom:30px;">
        <img src="<?php echo BASE_URL; ?>/images/schoollogo.JPG" style="width: 80px; height: 80px; margin-right: 10px; margin-bottom: 10px; float: left;">
        <div style="float: left; margin-top: 10px; margin-left: 5px;">
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">THE KING'S SCHOOL</p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">P.O. BOX 1560, Bujumbura, Burundi</p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">TEL: (+257) 22 27 96 78/69 84 04 78</p>
          <!-- <p style="margin: 0px; font-size: 11px; font-weight: bold;">EMAIL: secondary.school@thekingsschool.edu.bl</p> -->
        </div>
        <div style="float: left; margin-top: 10px; margin-left: 20px;">
          <p style="margin: 0px; font-size:15px; font-weight: bold;">Print No. <span style="text-transform: uppercase;"> <?php echo $id * 23; ?></span></p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">Print Date: <?php echo date('M d,Y', $timenow); ?></p>
          <!-- <p style="margin: 0px; font-size: 15px; font-weight: bold;">TERM DATES: <?php echo date('d/M/y', $startdate_4) ?> to <?php echo date('d/M/y', $enddate_4); ?></p>
                                <p style="margin: 0px; font-size: 15px; font-weight: bold;">FORM TUTOR: <?php echo $teachername; ?></p> -->
        </div>
      </div>


      <div class="table-responsive m-t">
        <?php
        // fetch midterm plan
        $weeklyplan_id = $month = $teacher_id = $class_sub_id = $term_value = null;
        $planStmt = mysqli_prepare($con, "SELECT midterm_plan_id, month, teacher_id, class_sub_id, term FROM midterm_plans WHERE midterm_plan_id = ? AND status = 1 LIMIT 1");
        if ($planStmt) {
          mysqli_stmt_bind_param($planStmt, 'i', $id);
          mysqli_stmt_execute($planStmt);
          $pres = mysqli_stmt_get_result($planStmt);
          if ($pres && mysqli_num_rows($pres) > 0) {
            $prow = mysqli_fetch_assoc($pres);
            $weeklyplan_id = isset($prow['midterm_plan_id']) ? (int)$prow['midterm_plan_id'] : 0;
            $month = $prow['month'] ?? '';
            $teacher_id = isset($prow['teacher_id']) ? (int)$prow['teacher_id'] : 0;
            $class_sub_id = isset($prow['class_sub_id']) ? (int)$prow['class_sub_id'] : 0;
            $term_value = isset($prow['term']) ? (int)$prow['term'] : 0;
          }
          mysqli_stmt_close($planStmt);
        }

        // fetch class_subjects
        $class_id = $subject_id = null;
        if ($class_sub_id) {
          $csStmt = mysqli_prepare($con, "SELECT class_id, subject_id FROM class_subjects WHERE class_sub_id = ? LIMIT 1");
          if ($csStmt) {
            mysqli_stmt_bind_param($csStmt, 'i', $class_sub_id);
            mysqli_stmt_execute($csStmt);
            $csres = mysqli_stmt_get_result($csStmt);
            if ($csres && mysqli_num_rows($csres) > 0) {
              $csrow = mysqli_fetch_assoc($csres);
              $class_id = isset($csrow['class_id']) ? (int)$csrow['class_id'] : 0;
              $subject_id = isset($csrow['subject_id']) ? (int)$csrow['subject_id'] : 0;
            }
            mysqli_stmt_close($csStmt);
          }
        }

        // fetch class
        $class = '';
        $category_id = 0;
        if ($class_id) {
          $cStmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
          if ($cStmt) {
            mysqli_stmt_bind_param($cStmt, 'i', $class_id);
            mysqli_stmt_execute($cStmt);
            $cres = mysqli_stmt_get_result($cStmt);
            if ($cres && mysqli_num_rows($cres) > 0) {
              $crow = mysqli_fetch_assoc($cres);
              $class = $crow['class'] ?? '';
              $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
            }
            mysqli_stmt_close($cStmt);
          }
        }

        // fetch subject
        $subject = '';
        if ($subject_id) {
          $sStmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
          if ($sStmt) {
            mysqli_stmt_bind_param($sStmt, 'i', $subject_id);
            mysqli_stmt_execute($sStmt);
            $sres = mysqli_stmt_get_result($sStmt);
            if ($sres && mysqli_num_rows($sres) > 0) {
              $srow = mysqli_fetch_assoc($sres);
              $subject = $srow['subject'] ?? '';
            }
            mysqli_stmt_close($sStmt);
          }
        }

        // fetch term
        $term = $year = '';
        if ($term_value) {
          $tStmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE status = 1 AND financialterm_id = ? LIMIT 1");
          if ($tStmt) {
            mysqli_stmt_bind_param($tStmt, 'i', $term_value);
            mysqli_stmt_execute($tStmt);
            $tres = mysqli_stmt_get_result($tStmt);
            if ($tres && mysqli_num_rows($tres) > 0) {
              $trow = mysqli_fetch_assoc($tres);
              $term = $trow['term'] ?? '';
              $year = $trow['year'] ?? '';
            }
            mysqli_stmt_close($tStmt);
          }
        }
        ?>
  <h2 class="text-center" style=" font-weight: bold; text-transform: uppercase;"> <?php echo htmlspecialchars($subject . ':' . $class . ' Mid-term Plan', ENT_QUOTES); ?></h2>
        <!-- <div class="row" style="margin-bottom:20px">
          <div class="col-sm-6"><strong>Week Start : </strong><span><?php echo date('d/M/Y', $startdate); ?></span></div>
          <div class="col-sm-6"><strong>Week End : </strong><span><?php echo date('d/M/Y', $enddate); ?></span></div>
          <?php
          if ($category_id == 3) { ?>
            <div class="col-sm-6"><strong>Book Pages : </strong><span><?php echo $bookpages; ?></span></div>
          <?php } else { ?>
            <div class="col-sm-6"><strong>Periods per Week : </strong><span><?php echo $periodsperweek; ?></span></div>
            <div class="col-sm-6"><strong>Year : </strong><span><?php echo $year; ?></span></div>
          <?php } ?>

          <div class="col-sm-6"><strong>Term : </strong><span><?php echo $term; ?></span></div>
        </div> -->

        <section class="panel">
          <header class="panel-heading">
            <h3>Weekly Plan </h3>
          </header>
          <div class="panel-body">
            <?php
            // fetch file_path from midterm_plans (if not already retrieved)
            $file_path = '';
            if (empty($file_path) || !isset($file_path)) {
              $fpStmt = mysqli_prepare($con, "SELECT file_path FROM midterm_plans WHERE midterm_id = ? AND status = 1 LIMIT 1");
              if ($fpStmt) {
                mysqli_stmt_bind_param($fpStmt, 'i', $id);
                mysqli_stmt_execute($fpStmt);
                $fres = mysqli_stmt_get_result($fpStmt);
                if ($fres && mysqli_num_rows($fres) > 0) {
                  $frow = mysqli_fetch_assoc($fres);
                  $file_path = $frow['file_path'] ?? '';
                }
                mysqli_stmt_close($fpStmt);
              }
            }

            if (!empty($file_path)) {
              $pdf_path = '../uploads/midterm_plans/' . $file_path;
              if (file_exists($pdf_path)) {
            ?>
                <div class="pdf-container" style="width: 100%; height: 800px;">
                  <iframe
                    src="<?php echo htmlspecialchars($pdf_path, ENT_QUOTES); ?>"
                    width="100%"
                    height="100%"
                    style="border: none;"
                    type="application/pdf">
                  </iframe>
                </div>
            <?php
              } else {
                echo '<div class="alert alert-warning">PDF file not found.</div>';
              }
            } else {
              echo '<div class="alert alert-info">No document uploaded for this mid-term plan.</div>';
            }
            ?>
          </div>
        </section>

      </div><!-- /table-responsive -->



      <div class="well m-t">
        <strong style="font-style: italic">School System</strong>
      </div>
    </div>

  </div>

  <!-- Mainly scripts -->
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>

  <!-- Custom and plugin javascript -->
  <script src="js/inspinia.js"></script>

  <script type="text/javascript">
    window.print();
  </script>

</body>

</html>