<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  echo '<div class="alert alert-danger">Invalid request.</div>';
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="keywords" content="admin, dashboard, bootstrap, template, flat, modern, theme, responsive, fluid, retina, backend, html5, css, css3">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Subject Mid term Plan</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <script src='<?php echo BASE_URL; ?>/js/fullcalendar/moment.min.js'></script>

</head>

<body class="sticky-header">

  <section>
    <?php include 'nav.php'; ?>


    <!--body wrapper start-->
    <div class="wrapper">
      <div class="row">

        <div class="col-lg-6">
          <!-- <a href="midtermplanprint?id=<?php echo $id; ?>" class="btn btn-danger" target="_blank" style="margin-bottom: 10px">Print Mid-term Plan</a> -->
          <?php
          // fetch midterm plan (support both possible id columns)
          // Query by midterm_plan_id only — this DB doesn't have a midterm_id column
          $planStmt = mysqli_prepare($con, "SELECT midterm_plan_id, month, teacher_id, class_sub_id, term, file_path FROM midterm_plans WHERE midterm_plan_id = ? AND status = 1 LIMIT 1");
          $weeklyplan_id = $month = $teacher_id = $class_sub_id = $term_value = $file_path = $prow = $raw = null;
          if ($planStmt) {
            mysqli_stmt_bind_param($planStmt, 'i', $id);
            mysqli_stmt_execute($planStmt);
            $pres = mysqli_stmt_get_result($planStmt);
            if (isset($_GET['debug']) && $_GET['debug'] == '1') {
              echo '<pre style="background:#fff;padding:10px;border:1px solid #ccc;">';
              echo "DEBUG: Executed SELECT for midterm_plan_id={$id}\n";
              echo "mysqli error: " . mysqli_error($con) . "\n";
              echo "result resource: "; var_dump($pres);
              echo "num_rows: "; var_dump($pres ? mysqli_num_rows($pres) : null);
              echo "</pre>";
            }
            if ($pres && mysqli_num_rows($pres) > 0) {
              $prow = mysqli_fetch_assoc($pres);
              $weeklyplan_id = isset($prow['midterm_plan_id']) ? (int)$prow['midterm_plan_id'] : $id;
              $month = $prow['month'] ?? '';
              $teacher_id = isset($prow['teacher_id']) ? (int)$prow['teacher_id'] : 0;
              $class_sub_id = isset($prow['class_sub_id']) ? (int)$prow['class_sub_id'] : 0;
              $term_value = isset($prow['term']) ? $prow['term'] : null;
              $file_path = $prow['file_path'] ?? '';
            }
            mysqli_stmt_close($planStmt);
          } else {
            if (isset($_GET['debug']) && $_GET['debug'] == '1') {
              echo '<pre style="background:#fff;padding:10px;border:1px solid #ccc;">';
              echo "DEBUG: prepare() failed for SELECT - mysqli_error: " . mysqli_error($con) . "\n";
              echo "Query: SELECT midterm_plan_id, month, teacher_id, class_sub_id, term, file_path FROM midterm_plans WHERE (midterm_plan_id = ? OR midterm_id = ?) AND status = 1 LIMIT 1\n";
              echo '</pre>';
            }
          }

          // Debug helper: append &debug=1 to the URL to dump the fetched DB row and file path checks
          if (isset($_GET['debug']) && $_GET['debug'] == '1') {
                      // ensure $raw reflects the fetched file_path for accurate diagnostics
                      $raw = $file_path ?? null;
                      echo '<pre style="background:#fff;padding:10px;border:1px solid #ccc;">';
                      echo "DEBUG: prow=\n";
                      var_dump($prow);
                      echo "\n\nDEBUG: file_path raw: '" . $raw . "'\n";
                      $checks = [];
                      $checks['raw'] = $raw;
                      // raw existence / realpath
                      $checks['raw_exists'] = file_exists($raw);
                      $checks['raw_realpath'] = @realpath($raw);

                      $uploads_dir = realpath(__DIR__ . '/../uploads');
                      $uploads_mid_dir = realpath(__DIR__ . '/../uploads/midterm_plans');
                      $checks['uploads_dir'] = $uploads_dir;
                      $checks['uploads_mid_dir'] = $uploads_mid_dir;
                      $checks['uploads_dir_is_dir'] = is_dir($uploads_dir);
                      $checks['uploads_dir_readable'] = is_readable($uploads_dir);
                      $checks['uploads_mid_is_dir'] = is_dir($uploads_mid_dir);
                      $checks['uploads_mid_readable'] = is_readable($uploads_mid_dir);

                      $bname = basename($raw);
                      if ($bname !== '') {
                        $uploads_mid = (__DIR__ . '/../uploads/midterm_plans/' . $bname);
                        $checks['uploads_mid_candidate'] = $uploads_mid;
                        $checks['uploads_mid_candidate_exists'] = file_exists($uploads_mid);
                      } else {
                        $checks['uploads_mid_candidate'] = null;
                        $checks['uploads_mid_candidate_exists'] = false;
                      }

                      // Directory listings
                      $checks['cwd'] = getcwd();
                      $checks['dir_listing_uploads'] = @scandir(__DIR__ . '/../uploads') ?: [];
                      $checks['dir_listing_midterm'] = @scandir(__DIR__ . '/../uploads/midterm_plans') ?: [];
                      $checks['glob_midterm'] = glob(__DIR__ . '/../uploads/midterm_plans/*') ?: [];
                      var_dump($checks);
                      echo '</pre>';
          }

          // fetch class_subjects
          $class_id = $subject_id = null;
          if ($class_sub_id) {
            $csStmt = mysqli_prepare($con, "SELECT class_id, subject_id FROM class_subjects WHERE class_sub_id = ? LIMIT 1");
            if ($csStmt) {
              mysqli_stmt_bind_param($csStmt, 'i', $class_sub_id);
              mysqli_stmt_execute($csStmt);
              $csres = mysqli_stmt_get_result($csStmt);
              if ($csres && mysqli_num_rows($csres) > 0) {
                $csrow = mysqli_fetch_assoc($csres);
                $class_id = isset($csrow['class_id']) ? (int)$csrow['class_id'] : 0;
                $subject_id = isset($csrow['subject_id']) ? (int)$csrow['subject_id'] : 0;
              }
              mysqli_stmt_close($csStmt);
            }
          }

          // If we don't have a file_path, try a fallback: find latest midterm plan for this class_sub_id and teacher
          if (empty($file_path) && $class_sub_id && isset($_SESSION['teachersys'])) {
            $fallbackStmt = mysqli_prepare($con, "SELECT midterm_plan_id, month, teacher_id, class_sub_id, term, file_path FROM midterm_plans WHERE class_sub_id = ? AND teacher_id = ? AND status = 1 ORDER BY midterm_plan_id DESC LIMIT 1");
            if ($fallbackStmt) {
              $sessTid = (int)$_SESSION['teachersys'];
              mysqli_stmt_bind_param($fallbackStmt, 'ii', $class_sub_id, $sessTid);
              mysqli_stmt_execute($fallbackStmt);
              $fres = mysqli_stmt_get_result($fallbackStmt);
              if ($fres && mysqli_num_rows($fres) > 0) {
                $frow = mysqli_fetch_assoc($fres);
                // adopt values from fallback row
                $weeklyplan_id = isset($frow['midterm_plan_id']) ? (int)$frow['midterm_plan_id'] : $weeklyplan_id;
                $month = $frow['month'] ?? $month;
                $teacher_id = isset($frow['teacher_id']) ? (int)$frow['teacher_id'] : $teacher_id;
                $class_sub_id = isset($frow['class_sub_id']) ? (int)$frow['class_sub_id'] : $class_sub_id;
                $term_value = isset($frow['term']) ? $frow['term'] : $term_value;
                $file_path = $frow['file_path'] ?? $file_path;
              }
              mysqli_stmt_close($fallbackStmt);
            }
            // If still no file_path, try latest midterm plan for this class_sub_id regardless of teacher
            if (empty($file_path) && $class_sub_id) {
              $anyStmt = mysqli_prepare($con, "SELECT midterm_plan_id, month, teacher_id, class_sub_id, term, file_path FROM midterm_plans WHERE class_sub_id = ? AND status = 1 ORDER BY midterm_plan_id DESC LIMIT 1");
              if ($anyStmt) {
                mysqli_stmt_bind_param($anyStmt, 'i', $class_sub_id);
                mysqli_stmt_execute($anyStmt);
                $anyres = mysqli_stmt_get_result($anyStmt);
                if ($anyres && mysqli_num_rows($anyres) > 0) {
                  $anyrow = mysqli_fetch_assoc($anyres);
                  $weeklyplan_id = isset($anyrow['midterm_plan_id']) ? (int)$anyrow['midterm_plan_id'] : $weeklyplan_id;
                  $month = $anyrow['month'] ?? $month;
                  $teacher_id = isset($anyrow['teacher_id']) ? (int)$anyrow['teacher_id'] : $teacher_id;
                  $term_value = isset($anyrow['term']) ? $anyrow['term'] : $term_value;
                  $file_path = $anyrow['file_path'] ?? $file_path;
                }
                mysqli_stmt_close($anyStmt);
              }
            }
          }

          // fetch class
          $class = '';
          $category_id = 0;
          if ($class_id) {
            $cStmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
            if ($cStmt) {
              mysqli_stmt_bind_param($cStmt, 'i', $class_id);
              mysqli_stmt_execute($cStmt);
              $cres = mysqli_stmt_get_result($cStmt);
              if ($cres && mysqli_num_rows($cres) > 0) {
                $crow = mysqli_fetch_assoc($cres);
                $class = $crow['class'] ?? '';
                $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
              }
              mysqli_stmt_close($cStmt);
            }
          }

          // fetch subject
          $subject = '';
          if ($subject_id) {
            $sStmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
            if ($sStmt) {
              mysqli_stmt_bind_param($sStmt, 'i', $subject_id);
              mysqli_stmt_execute($sStmt);
              $sres = mysqli_stmt_get_result($sStmt);
              if ($sres && mysqli_num_rows($sres) > 0) {
                $srow = mysqli_fetch_assoc($sres);
                $subject = $srow['subject'] ?? '';
              }
              mysqli_stmt_close($sStmt);
            }
          }

          // fetch term
          $term = $year = '';
          if ($term_value) {
            $tStmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE status = 1 AND financialterm_id = ? LIMIT 1");
            if ($tStmt) {
              mysqli_stmt_bind_param($tStmt, 'i', $term_value);
              mysqli_stmt_execute($tStmt);
              $tres = mysqli_stmt_get_result($tStmt);
              if ($tres && mysqli_num_rows($tres) > 0) {
                $trow = mysqli_fetch_assoc($tres);
                $term = $trow['term'] ?? '';
                $year = $trow['year'] ?? '';
              }
              mysqli_stmt_close($tStmt);
            }
          }

          ?>
          <section class="panel">
            <header class="panel-heading">
              <?php echo htmlspecialchars(($subject ?? '') . ':' . ($class ?? '') . ' Mid Term Plan', ENT_QUOTES); ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">

                <tbody>

                  <tr class="gradeA">
                    <th>Month</th>
                    <td><?php echo htmlspecialchars(getMonthName($month) ?? '', ENT_QUOTES); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th> Term</th>
                    <td><?php echo htmlspecialchars($term ?? '', ENT_QUOTES);            ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th> Year</th>
                    <td><?php echo htmlspecialchars($year ?? '', ENT_QUOTES);            ?></td>
                  </tr>
                </tbody>
              </table>

            </div>
          </section>

        </div>
        <div class="col-lg-6">

        </div>

      </div>
      <div class="row">

        <div class="col-lg-10">
          <section class="panel">
            <header class="panel-heading">
              Mid-term Plan Document
            </header>
            <div class="panel-body">
              <?php
              // Use the file_path we already fetched earlier ($file_path).
              // The DB may contain either absolute or relative paths; prefer to check on-disk path
              // and expose web-safe URL via BASE_URL when possible. Be resilient to different DB formats.
              $pdf_web = '';
              if (!empty($file_path)) {
                // candidate 1: file_path as-is (maybe absolute)
                $candidates = [];
                $candidates[] = $file_path;
                // candidate 2: relative to project root (__DIR__/../)
                $candidates[] = __DIR__ . '/../' . ltrim($file_path, '/\\');
                // candidate 3: under uploads/midterm_plans using basename
                $b = basename($file_path);
                if ($b !== '') {
                  $candidates[] = __DIR__ . '/../uploads/midterm_plans/' . $b;
                }

                $pdf_disk = null;
                foreach ($candidates as $cand) {
                  if ($cand && file_exists($cand) && is_file($cand)) {
                    $pdf_disk = $cand;
                    break;
                  }
                }

                // If we found the file on disk, construct a web-accessible path
                if ($pdf_disk) {
                  // If the db stored a path under uploads/, prefer using BASE_URL + that relative path
                  if (strpos($file_path, 'uploads/') !== false) {
                    $pdf_web = rtrim(BASE_URL, '/') . '/' . ltrim($file_path, '/\\');
                  } else {
                    // otherwise use uploads/midterm_plans basename mapping
                    $pdf_web = rtrim(BASE_URL, '/') . '/uploads/midterm_plans/' . rawurlencode(basename($pdf_disk));
                  }
                }
              }

              if ($pdf_web) {
              ?>
                <div class="pdf-container" style="width: 100%; height: 800px;">
                  <iframe
                    src="<?php echo htmlspecialchars($pdf_web, ENT_QUOTES); ?>"
                    width="100%"
                    height="100%"
                    style="border: none;"
                    frameborder="0"
                    allowfullscreen>
                  </iframe>
                </div>
                <?php if (!empty($pdf_web)): ?>
                  <p style="margin-top:8px"><a href="<?php echo htmlspecialchars($pdf_web, ENT_QUOTES); ?>" target="_blank">Open PDF in new tab</a></p>
                <?php endif; ?>
              <?php
              } elseif (!empty($file_path)) {
                echo '<div class="alert alert-warning">PDF file not found on disk.</div>';
              } else {
                echo '<div class="alert alert-info">No document uploaded for this mid-term plan.</div>';
              }
              ?>
            </div>
          </section>
        </div>

      </div>

    </div>
    <!-- main content end-->
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

</body>

</html>