<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>View Marks-School Manager</title>
 <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                 Assessment Details
                    </header>
                             <div class="panel-body">  
                           <?php
                                 // validate GET params
                                 $class_id = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
                                 $subject = filter_input(INPUT_GET, 'sub', FILTER_VALIDATE_INT);
                                 $as = filter_input(INPUT_GET, 'as', FILTER_VALIDATE_INT);
                                 $date = isset($_GET['dt']) ? trim((string)$_GET['dt']) : '';
                                 $term = filter_input(INPUT_GET, 'tm', FILTER_VALIDATE_INT);
                                 $paper = filter_input(INPUT_GET, 'pap', FILTER_VALIDATE_INT);

                                 // Initialize variables to avoid undefined warnings
                                 $class2 = '';
                                 $category_id = 0;
                                 $reporttype = 0;
                                 $subject2 = '';
                                 $term2 = '';
                                 $year = '';
                                 $paper2 = 'No Paper';
                                 $assessment = '';

                                 if (!$class_id || !$subject || !$as || !$date || !$term) {
                                       echo '<div class="alert alert-danger">Invalid request parameters.</div>';
                                       // stop rendering further
                                 } else {
                                    // fetch class
                                    $cstmt = mysqli_prepare($con, "SELECT class, category_id, report_type FROM classes WHERE class_id = ? LIMIT 1");
                                    if ($cstmt) {
                                       mysqli_stmt_bind_param($cstmt, 'i', $class_id);
                                       mysqli_stmt_execute($cstmt);
                                       $cres = mysqli_stmt_get_result($cstmt);
                                       if ($cres && mysqli_num_rows($cres) > 0) {
                                          $crow = mysqli_fetch_assoc($cres);
                                          $class2 = $crow['class'] ?? '';
                                          $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
                                          $reporttype = isset($crow['report_type']) ? (int)$crow['report_type'] : 0;
                                       }
                                       mysqli_stmt_close($cstmt);
                                    }

                                    // fetch subject
                                    $sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
                                    if ($sstmt) {
                                       mysqli_stmt_bind_param($sstmt, 'i', $subject);
                                       mysqli_stmt_execute($sstmt);
                                       $sres = mysqli_stmt_get_result($sstmt);
                                       if ($sres && mysqli_num_rows($sres) > 0) {
                                          $srow = mysqli_fetch_assoc($sres);
                                          $subject2 = $srow['subject'] ?? '';
                                       }
                                       mysqli_stmt_close($sstmt);
                                    }

                                    // fetch term
                                    $tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
                                    if ($tstmt) {
                                       mysqli_stmt_bind_param($tstmt, 'i', $term);
                                       mysqli_stmt_execute($tstmt);
                                       $tres = mysqli_stmt_get_result($tstmt);
                                       if ($tres && mysqli_num_rows($tres) > 0) {
                                          $trow = mysqli_fetch_assoc($tres);
                                          $term2 = $trow['term'] ?? '';
                                          $year = $trow['year'] ?? '';
                                       }
                                       mysqli_stmt_close($tstmt);
                                    }

                                    // fetch paper name if any
                                    if ($paper && $paper != 0) {
                                       $pstmt = mysqli_prepare($con, "SELECT paper_name FROM papers WHERE paper_id = ? LIMIT 1");
                                       if ($pstmt) {
                                          mysqli_stmt_bind_param($pstmt, 'i', $paper);
                                          mysqli_stmt_execute($pstmt);
                                          $pres = mysqli_stmt_get_result($pstmt);
                                          if ($pres && mysqli_num_rows($pres) > 0) {
                                             $prow = mysqli_fetch_assoc($pres);
                                             $paper2 = $prow['paper_name'] ?? 'No Paper';
                                          }
                                          mysqli_stmt_close($pstmt);
                                       }
                                    }

                                    // fetch assessment type
                                    $atypes = mysqli_prepare($con, "SELECT assessmenttype FROM assessmenttypes WHERE assessmenttype_id = ? LIMIT 1");
                                    if ($atypes) {
                                       mysqli_stmt_bind_param($atypes, 'i', $as);
                                       mysqli_stmt_execute($atypes);
                                       $atres = mysqli_stmt_get_result($atypes);
                                       if ($atres && mysqli_num_rows($atres) > 0) {
                                          $arow = mysqli_fetch_assoc($atres);
                                          $assessment = $arow['assessmenttype'] ?? '';
                                       }
                                       mysqli_stmt_close($atypes);
                                    }
                                 }
                                ?>
                                <table  class="display table  table-striped" id="dynamic-table">
             <tbody>
         
                <tr class="gradeA">
                       <th>Assessment</th>
                       <td><?php echo $assessment;?></td>
                  </tr>
                 <tr class="gradeA">
                       <th>Class</th>
                       <td><?php echo $class2;?></td>
                  </tr>
                  <tr class="gradeA">
                             <th>Subject</th>
            <td><?php echo $subject2; ?></td>
            </tr>
            <?php if ($reporttype != 1) { ?>
            <tr class="gradeA">
                             <th>Paper</th>
            <td><?php echo $paper2; ?></td>
            </tr>
            <?php } ?>
                           <tr class="gradeA">
                             <th> Term</th>
                             <td><?php echo htmlspecialchars($term2.' '.$year, ENT_QUOTES);?></td>
            </tr>
                 <tr class="gradeA">
                             <th> Date</th>
                             <td><?php 
                             // Handle DATE format (Y-m-d) properly
                             if (!empty($date)) {
                                 $d = DateTime::createFromFormat('Y-m-d', $date);
                                 if ($d && $d->format('Y-m-d') === $date) {
                                     echo $d->format('d/M/Y');
                                 } else {
                                     // Fallback to strtotime
                                     $ts = strtotime($date);
                                     echo $ts !== false ? date('d/M/Y', $ts) : htmlspecialchars($date, ENT_QUOTES);
                                 }
                             } else {
                                 echo 'No date';
                             }
                             ?></td>
            </tr>
                   </tbody>
                        </table>
                                      
                           
              </div>
                          </section>
                    </div>
                <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                  Student Marks
                    </header>
                                        <div class="panel-body"> 
                            <?php
                              // Debug output
                              if (isset($_GET['debug'])) {
                                  echo "<div class='alert alert-info'><strong>DEBUG INFO:</strong><br>";
                                  echo "Class ID: $class_id<br>";
                                  echo "Subject ID: $subject<br>";
                                  echo "Assessment: $as<br>";
                                  echo "Term: $term<br>";
                                  echo "Date: '$date' (type: " . gettype($date) . ")<br>";
                                  echo "Paper: $paper<br>";
                                  echo "</div>";
                              }
                              
                              if (isset($class_id, $subject, $as, $term)) {
                                 if ($paper && $paper != 0) {
                                    // Show all results for this assessment/class/subject/term/paper combination regardless of date
                                    $sql = "SELECT mark_id, marks, student_id, status, rank, effort_id, date FROM marks WHERE class_id = ? AND subject_id = ? AND assessment = ? AND term_id = ? AND paper_id = ? AND status = 1 ORDER BY date DESC, student_id";
                                    $mstmt = mysqli_prepare($con, $sql);
                                    if ($mstmt) mysqli_stmt_bind_param($mstmt, 'iiiii', $class_id, $subject, $as, $term, $paper);
                                 } else {
                                    // Show all results for this assessment/class/subject/term combination regardless of date
                                    $sql = "SELECT mark_id, marks, student_id, status, rank, effort_id, date FROM marks WHERE class_id = ? AND subject_id = ? AND assessment = ? AND term_id = ? AND status = 1 ORDER BY date DESC, student_id";
                                    $mstmt = mysqli_prepare($con, $sql);
                                    if ($mstmt) mysqli_stmt_bind_param($mstmt, 'iiii', $class_id, $subject, $as, $term);
                                 }
                                 $marks = null;
                                 if ($mstmt) {
                                    mysqli_stmt_execute($mstmt);
                                    $marks = mysqli_stmt_get_result($mstmt);
                                    
                                    // Debug: show how many marks found
                                    if (isset($_GET['debug'])) {
                                        $count = mysqli_num_rows($marks);
                                        echo "<div class='alert alert-warning'>Query returned $count marks</div>";
                                    }
                                 }

                              }
                              if (!empty($marks) && mysqli_num_rows($marks) > 0) {
                                 // Group marks by student and date, and collect per-date max (rank)
                                 $student_marks = [];
                                 $all_dates = [];
                                 $date_max = []; // date => max possible for that date (rank)
                                 
                                 while($row = mysqli_fetch_assoc($marks)){
                                    $student_id = isset($row['student_id']) ? (int)$row['student_id'] : 0;
                                    $mark = $row['marks'] ?? 0;
                                    $rank_val = isset($row['rank']) ? (float)$row['rank'] : 0.0;
                                    $result_date = $row['date'] ?? '';
                                    $mark_id = isset($row['mark_id']) ? (int)$row['mark_id'] : 0;
                                    
                                    if (!isset($student_marks[$student_id])) {
                                       $student_marks[$student_id] = [];
                                    }

                                    if (!in_array($result_date, $all_dates)) {
                                       $all_dates[] = $result_date;
                                    }

                                    // record per-date max (rank). If multiple entries for same date exist,
                                    // keep the maximum rank seen (defensive).
                                    if (!isset($date_max[$result_date]) || $rank_val > $date_max[$result_date]) {
                                       $date_max[$result_date] = $rank_val;
                                    }

                                    $student_marks[$student_id][$result_date] = [
                                       'mark' => is_numeric($mark) ? (float)$mark : 0.0,
                                       'mark_id' => $mark_id,
                                       'rank' => $rank_val
                                    ];
                                 }

                                 // Sort dates newest first
                                 rsort($all_dates);
                                 $num_dates = count($all_dates);

                                 // Determine if this assessment is an exam (out of 60) or continuous (out of 40)
                                 $is_exam = false;
                                 if (!empty($assessment)) {
                                    $assessment_lower = strtolower($assessment);
                                    $is_exam = (strpos($assessment_lower, 'exam') !== false);
                                 }

                                 // Compute max possible across all dates (sum of per-date ranks)
                                 $max_possible = 0.0;
                                 foreach ($all_dates as $d) {
                                    $max_possible += isset($date_max[$d]) ? (float)$date_max[$d] : 0.0;
                                 }
                                 // Fallback: if no per-date ranks available, assume a single rank_value (safe default)
                                 if ($max_possible <= 0) {
                                    $fallback_rank = 0;
                                    if (!empty($student_marks)) {
                                       // try to get any rank from the first student/date
                                       $first = reset($student_marks);
                                       if (!empty($first)) {
                                          $first_item = reset($first);
                                          $fallback_rank = isset($first_item['rank']) ? (float)$first_item['rank'] : 0.0;
                                       }
                                    }
                                    $max_possible = $fallback_rank * max(1, $num_dates);
                                 }

                                 // Target max (what we scale TO)
                                 $target_max = $is_exam ? 60.0 : 40.0;
   ?>
                    <table class="table table-striped table-bordered table-hover dataTables-example" >
                    <thead>
                    <tr>
                        <th>Student</th>
                        <?php foreach($all_dates as $date) { ?>
                           <th><?php 
                              if (!empty($date)) {
                                 $d = DateTime::createFromFormat('Y-m-d', $date);
                                 if ($d && $d->format('Y-m-d') === $date) {
                                    echo $d->format('d/M/Y');
                                 } else {
                                    $ts = strtotime($date);
                                    echo $ts !== false ? date('d/M/Y', $ts) : htmlspecialchars($date, ENT_QUOTES);
                                 }
                              }
                           ?></th>
                        <?php } ?>
                        <th>Total / <?php echo intval($target_max); ?></th>
                        <th>Action</th>
                    </tr>
                    </thead>
           <tbody>
        <?php
         // Prepare student stmt once
         $studentStmt = mysqli_prepare($con, "SELECT fullname FROM students WHERE student_id = ? LIMIT 1");
         
         foreach($student_marks as $student_id => $dates_data) {
            $fullname = '';
            if ($studentStmt) {
               mysqli_stmt_bind_param($studentStmt, 'i', $student_id);
               mysqli_stmt_execute($studentStmt);
               $sres = mysqli_stmt_get_result($studentStmt);
               if ($sres && mysqli_num_rows($sres) > 0) {
                  $srow = mysqli_fetch_assoc($sres);
                  $fullname = $srow['fullname'] ?? '';
               }
            }
            
            // Calculate raw total marks for this student (sum of marks across dates)
            $raw_total = 0.0;
            foreach($all_dates as $d) {
               if (isset($dates_data[$d])) {
                  $raw_total += isset($dates_data[$d]['mark']) ? (float)$dates_data[$d]['mark'] : 0.0;
               }
            }

            // Scale raw total to target_max (40 for continuous, 60 for exam)
            $scaled_total = 0.0;
            if ($max_possible > 0) {
               $scaled_total = ($raw_total / $max_possible) * $target_max;
            } else {
               $scaled_total = $raw_total; // fallback
            }
            
            // format scaled total to one decimal
            $scaled_total_fmt = number_format($scaled_total, 1);
          ?>
               
                    <tr class="gradeA">
                    <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
                    
                    <?php foreach($all_dates as $date) { ?>
                       <td><?php 
                          if (isset($dates_data[$date])) {
                             // Display as mark/rank format (e.g., 30/40) using that date's rank if available
                             $r = isset($dates_data[$date]['rank']) && $dates_data[$date]['rank'] > 0 ? $dates_data[$date]['rank'] : (isset($date_max[$date]) ? $date_max[$date] : $target_max);
                             echo htmlspecialchars($dates_data[$date]['mark'] . '/' . $r, ENT_QUOTES);
                          } else {
                             echo '-';
                          }
                       ?></td>
                    <?php } ?>
                    
                    <td><strong><?php echo $scaled_total_fmt . '/' . intval($target_max); ?></strong></td>
                    
                    <td class="center">
                       <?php
                       // Single Edit and Delete dropdowns per student. Each lists dates available for that student.
                       ?>
                       <div class="btn-group">
                          <button type="button" class="btn btn-info btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Edit <span class="caret"></span></button>
                          <ul class="dropdown-menu">
                             <?php foreach($all_dates as $d) {
                                if (!isset($dates_data[$d])) continue;
                                $mid = $dates_data[$d]['mark_id'];
                                $fmt = '';
                                if (!empty($d)) {
                                   $dd = DateTime::createFromFormat('Y-m-d', $d);
                                   if ($dd && $dd->format('Y-m-d') === $d) $fmt = $dd->format('d/M/Y'); else { $ts = strtotime($d); $fmt = $ts !== false ? date('d/M/Y', $ts) : $d; }
                                }
                             ?>
                             <li><a href="#" class="open-mark-edit" data-markid="<?php echo htmlspecialchars($mid, ENT_QUOTES); ?>" data-date="<?php echo htmlspecialchars($d, ENT_QUOTES); ?>"><?php echo htmlspecialchars($fmt, ENT_QUOTES); ?></a></li>
                             <?php } ?>
                          </ul>
                       </div>

                       <div class="btn-group" style="margin-left:6px;">
                          <button type="button" class="btn btn-danger btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Delete <span class="caret"></span></button>
                          <ul class="dropdown-menu">
                             <?php foreach($all_dates as $d) {
                                if (!isset($dates_data[$d])) continue;
                                $mid = $dates_data[$d]['mark_id'];
                                $fmt = '';
                                if (!empty($d)) {
                                   $dd = DateTime::createFromFormat('Y-m-d', $d);
                                   if ($dd && $dd->format('Y-m-d') === $d) $fmt = $dd->format('d/M/Y'); else { $ts = strtotime($d); $fmt = $ts !== false ? date('d/M/Y', $ts) : $d; }
                                }
                             ?>
                             <li><a href="deletemark?id=<?php echo htmlspecialchars($mid, ENT_QUOTES); ?>" onclick="return confirm('Are you sure you want to delete the mark for <?php echo htmlspecialchars($fmt, ENT_QUOTES); ?>?');"><?php echo htmlspecialchars($fmt, ENT_QUOTES); ?></a></li>
                             <?php } ?>
                          </ul>
                       </div>
                    </td>
                    </tr>
                         <?php }
                         if ($studentStmt) mysqli_stmt_close($studentStmt);
                         if (isset($mstmt) && $mstmt) mysqli_stmt_close($mstmt);
                         ?>
                    </tbody>
                                    </table>
 <?php }  else { ?>
                        <div class="alert alert-danger">Oops!! No Marks Added Yet</div>
<?php }  ?>
                     
                                      
                           
              </div>
              </section>
                          </div>  
                         
                       </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
      <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
</script>

<!-- Edit Mark Modal -->
<div class="modal fade" id="editMarkModal" tabindex="-1" role="dialog" aria-labelledby="editMarkModalLabel">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="editMarkModalLabel">Edit Mark</h4>
         </div>
         <div class="modal-body">
            <div id="editMarkAlert"></div>
            <form id="editMarkForm">
               <input type="hidden" name="mark_id" id="modal_mark_id" value="">
               <div class="form-group">
                  <label>Student</label>
                  <p id="modal_student_name" class="form-control-static"></p>
               </div>
               <div class="form-group">
                  <label>Date</label>
                  <p id="modal_mark_date" class="form-control-static"></p>
               </div>
               <div class="form-group">
                  <label>Marks</label>
                  <input type="text" class="form-control" id="modal_mark_value" name="mark" />
               </div>
               <div class="form-group">
                  <small id="modal_rank_help" class="text-muted"></small>
               </div>
            </form>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="button" id="modalSaveBtn" class="btn btn-primary">Save changes</button>
         </div>
      </div>
   </div>
</div>

<script>
$(function(){
   var currentMarkId = null;

   $(document).on('click', '.open-mark-edit', function(e){
      e.preventDefault();
      var $a = $(this);
      var markId = $a.data('markid');
      var dateStr = $a.data('date');
      if (!markId) return;
      currentMarkId = markId;
      // clear
      $('#editMarkAlert').html('');
      $('#modal_mark_id').val('');
      $('#modal_student_name').text('Loading...');
      $('#modal_mark_date').text('');
      $('#modal_mark_value').val('');
      $('#modal_rank_help').text('');
      // fetch
      $.getJSON('ajax_get_mark.php', { id: markId }, function(resp){
         if (!resp || !resp.success) {
            $('#editMarkAlert').html('<div class="alert alert-danger">Could not load mark data.</div>');
            return;
         }
         var d = resp.data || {};
         $('#modal_mark_id').val(d.mark_id);
         $('#modal_student_name').text(d.student_name || '');
         // date formatting: try to show provided formatted date or raw
         $('#modal_mark_date').text(d.date_formatted || dateStr || d.date || '');
         $('#modal_mark_value').val(d.marks);
         if (d.rank) {
            $('#modal_rank_help').text('Maximum for this entry: ' + d.rank);
         } else {
            $('#modal_rank_help').text('');
         }
         $('#editMarkModal').modal('show');
      }).fail(function(){
         $('#editMarkAlert').html('<div class="alert alert-danger">AJAX error while loading mark.</div>');
      });
   });

   $('#modalSaveBtn').on('click', function(){
      var markId = $('#modal_mark_id').val();
      var markVal = $('#modal_mark_value').val();
      if (!markId) return;
      // basic validation
      if ($.trim(markVal) === '' || isNaN(markVal)) {
         $('#editMarkAlert').html('<div class="alert alert-danger">Please enter a numeric mark.</div>');
         return;
      }
      // submit
      $('#modalSaveBtn').prop('disabled', true).text('Saving...');
      $.post('ajax_update_mark.php', { id: markId, mark: markVal }, function(resp){
         $('#modalSaveBtn').prop('disabled', false).text('Save changes');
         if (!resp || !resp.success) {
            var msg = (resp && resp.error) ? resp.error : 'Failed to save mark';
            $('#editMarkAlert').html('<div class="alert alert-danger">' + msg + '</div>');
            return;
         }
         $('#editMarkModal').modal('hide');
         // reload to reflect changes
         location.reload();
      }, 'json').fail(function(){
         $('#modalSaveBtn').prop('disabled', false).text('Save changes');
         $('#editMarkAlert').html('<div class="alert alert-danger">AJAX error while saving mark.</div>');
      });
   });
});
</script>
</body>

</html>
 