<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login');
  exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  echo '<div class="alert alert-danger">Invalid plan id</div>';
  exit;
}

$timenow = $timenow ?? time();
?>
<!DOCTYPE html>
<html>

<head>
  <style type="text/css" media="print">
    @page {
      size: auto;
      /* auto is the initial value */
      margin: 0;
      /* this affects the margin in the printer settings */
    }
  </style>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Subject Mid term Plan</title>
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/bootstrap.min.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/animate.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/assets/stylesheets/style.css" rel="stylesheet">


  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="white-bg">
  <div class="wrapper wrapper-content p-xl">
    <div class="ibox-content p-xl">
      <div class="row" style="margin-bottom:30px;">
        <img src="<?php echo BASE_URL; ?>/images/schoollogo.JPG" style="width: 80px; height: 80px; margin-right: 10px; margin-bottom: 10px; float: left;">
        <div style="float: left; margin-top: 10px; margin-left: 5px;">
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">THE KING'S SCHOOL</p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">P.O. BOX 1560, Bujumbura, Burundi</p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">TEL: (+257) 22 27 96 78/69 84 04 78</p>
          <!-- <p style="margin: 0px; font-size: 11px; font-weight: bold;">EMAIL: secondary.school@thekingsschool.edu.bl</p> -->
        </div>
        <div style="float: left; margin-top: 10px; margin-left: 20px;">
          <p style="margin: 0px; font-size:15px; font-weight: bold;">Print No. <span style="text-transform: uppercase;"> <?php echo $id * 23; ?></span></p>
          <p style="margin: 0px; font-size: 15px; font-weight: bold;">Print Date: <?php echo date('M d,Y', $timenow); ?></p>
          <!-- <p style="margin: 0px; font-size: 15px; font-weight: bold;">TERM DATES: <?php echo date('d/M/y', $startdate_4) ?> to <?php echo date('d/M/y', $enddate_4); ?></p>
                                <p style="margin: 0px; font-size: 15px; font-weight: bold;">FORM TUTOR: <?php echo $teachername; ?></p> -->
        </div>
      </div>


      <div class="table-responsive m-t">
        <?php
    // Fetch the long-term plan (support either long_term_id or longterm_id column naming)
    $weeklyplans = mysqli_query($con, "SELECT long_term_id,longterm_id,teacher_id,class_sub_id,term,file_path FROM longterm_plans WHERE (long_term_id='{$id}' OR longterm_id='{$id}') AND status=1 LIMIT 1");
    if (!($weeklyplans && $row = mysqli_fetch_assoc($weeklyplans))) {
      echo '<div class="alert alert-danger">Long-term plan not found</div>';
      exit;
    }
    $weeklyplan_id = (int)($row['long_term_id'] ?? $row['longterm_id'] ?? 0);
    $teacher_id = (int)($row['teacher_id'] ?? 0);
    $class_sub_id = (int)($row['class_sub_id'] ?? 0);
    $term_value = (int)($row['term'] ?? 0);
    $file_path = $row['file_path'] ?? '';

    // class_subjects
    $class_id = 0;
    $subject_id = 0;
    $class_subjects = mysqli_query($con, "SELECT class_id,subject_id FROM class_subjects WHERE class_sub_id='{$class_sub_id}' LIMIT 1");
    if ($class_subjects && $row1 = mysqli_fetch_assoc($class_subjects)) {
      $class_id = (int)($row1['class_id'] ?? 0);
      $subject_id = (int)($row1['subject_id'] ?? 0);
    }

    // class
    $class = '';
    $category_id = null;
    if ($class_id > 0) {
      $getclasses = mysqli_query($con, "SELECT class,category_id FROM classes WHERE class_id='{$class_id}' LIMIT 1");
      if ($getclasses && $row2 = mysqli_fetch_assoc($getclasses)) {
        $class = $row2['class'] ?? '';
        $category_id = $row2['category_id'] ?? null;
      }
    }

    // subject
    $subject = '';
    if ($subject_id > 0) {
      $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id='{$subject_id}' LIMIT 1");
      if ($getsubjects && $row3 = mysqli_fetch_assoc($getsubjects)) {
        $subject = $row3['subject'] ?? '';
      }
    }

    // term info
    $term = '';
    $year = '';
    if ($term_value > 0) {
      $terms = mysqli_query($con, "SELECT term,year FROM financialterms WHERE status=1 AND financialterm_id ='{$term_value}' LIMIT 1");
      if ($terms && $row2 = mysqli_fetch_assoc($terms)) {
        $term = $row2['term'] ?? '';
        $year = $row2['year'] ?? '';
      }
    }
        ?>
  <h2 class="text-center" style=" font-weight: bold; text-transform: uppercase;"> <?php echo htmlspecialchars($subject . ':' . $class . ' Long-term Lesson Plan'); ?></h2>
        <!-- 
         

          <div class="col-sm-6"><strong>Term : </strong><span><?php echo $term; ?></span></div>
        </div> -->

        <section class="panel">
          <header class="panel-heading">
            <!-- <h3>Longterm Lesson Plan </h3> -->
          </header>
          <div class="panel-body">
            <?php
            // Use the file_path fetched earlier
            if (!empty($file_path)) {
              $pdf_rel = '../uploads/longterm_plans/' . $file_path;
              $pdf_fs = realpath(__DIR__ . '/../uploads/longterm_plans/' . $file_path);
              if ($pdf_fs && file_exists($pdf_fs)) {
            ?>
                <div class="pdf-container" style="width: 100%; height: 800px;">
                  <iframe
                    src="<?php echo htmlspecialchars($pdf_rel); ?>"
                    width="100%"
                    height="100%"
                    style="border: none;"
                    type="application/pdf">
                  </iframe>
                </div>
            <?php
              } else {
                echo '<div class="alert alert-warning">PDF file not found.</div>';
              }
            } else {
              echo '<div class="alert alert-info">No document uploaded for this long-term plan.</div>';
            }
            ?>
          </div>
        </section>

      </div><!-- /table-responsive -->



      <div class="well m-t">
        <strong style="font-style: italic">School System</strong>
      </div>
    </div>

  </div>

  <!-- Mainly scripts -->
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>

  <!-- Custom and plugin javascript -->
  <script src="js/inspinia.js"></script>

  <script type="text/javascript">
    window.print();
  </script>

</body>

</html>