<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: index.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="keywords" content="admin, dashboard, bootstrap, template, flat, modern, theme, responsive, fluid, retina, backend, html5, css, css3">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Subject Longterm Lesson Plan</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <script src='<?php echo BASE_URL; ?>/js/fullcalendar/moment.min.js'></script>

</head>

<body class="sticky-header">

  <section>
    <?php include 'nav.php'; ?>


    <!--body wrapper start-->
    <div class="wrapper">
      <div class="row">

        <div class="col-lg-6">
          <!-- <a href="longtermplanprint?id=<?php echo $id; ?>" class="btn btn-danger" target="_blank" style="margin-bottom: 10px">Print Longterm Lesson Plan</a> -->
          <?php
          // load the longterm plan row (query by long_term_id only — table may not have longterm_id)
          $plan = null;
          $pstmt = mysqli_prepare($con, "SELECT long_term_id, teacher_id, class_sub_id, term, file_path FROM longterm_plans WHERE long_term_id = ? AND status = 1 LIMIT 1");
          if ($pstmt) {
            mysqli_stmt_bind_param($pstmt, 'i', $id);
            mysqli_stmt_execute($pstmt);
            $pres = mysqli_stmt_get_result($pstmt);
            if (isset($_GET['debug']) && $_GET['debug'] == '1') {
              echo '<pre style="background:#fff;padding:10px;border:1px solid #ccc;">';
              echo "DEBUG: Executed SELECT for long_term_id={$id}\n";
              echo "mysqli error: " . mysqli_error($con) . "\n";
              echo "result resource: "; var_dump($pres);
              echo "num_rows: "; var_dump($pres ? mysqli_num_rows($pres) : null);
              echo "</pre>";
            }
            if ($pres && mysqli_num_rows($pres) > 0) {
              $plan = mysqli_fetch_assoc($pres);
            }
            mysqli_stmt_close($pstmt);
          }

          // fallback: try an escaped query if prepare() failed or returned nothing
          if (!$plan) {
            $escaped_id = mysqli_real_escape_string($con, (string)$id);
            $fallback_sql = "SELECT long_term_id, teacher_id, class_sub_id, term, file_path FROM longterm_plans WHERE long_term_id = '$escaped_id' AND status = 1 LIMIT 1";
            $fres = mysqli_query($con, $fallback_sql);
            if ($fres && mysqli_num_rows($fres) > 0) {
              $plan = mysqli_fetch_assoc($fres);
            }
          }

          if (!$plan) {
            echo '<div class="alert alert-warning">Long-term plan not found.</div>';
          } else {
            $weeklyplan_id = isset($plan['long_term_id']) && $plan['long_term_id'] ? (int)$plan['long_term_id'] : (isset($plan['longterm_id']) ? (int)$plan['longterm_id'] : 0);
            $teacher_id = isset($plan['teacher_id']) ? (int)$plan['teacher_id'] : 0;
            $class_sub_id = isset($plan['class_sub_id']) ? (int)$plan['class_sub_id'] : 0;
            $term_value = isset($plan['term']) ? (int)$plan['term'] : 0;

            // get class_subjects
            $class_id = 0;
            $subject_id = 0;
            $cs = mysqli_prepare($con, "SELECT class_id, subject_id FROM class_subjects WHERE class_sub_id = ? LIMIT 1");
            if ($cs) {
              mysqli_stmt_bind_param($cs, 'i', $class_sub_id);
              mysqli_stmt_execute($cs);
              $csr = mysqli_stmt_get_result($cs);
              if ($csr && mysqli_num_rows($csr) > 0) {
                $csrow = mysqli_fetch_assoc($csr);
                $class_id = isset($csrow['class_id']) ? (int)$csrow['class_id'] : 0;
                $subject_id = isset($csrow['subject_id']) ? (int)$csrow['subject_id'] : 0;
              }
              mysqli_stmt_close($cs);
            }

            // get class
            $class = '';
            $category_id = 0;
            $cstmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
            if ($cstmt) {
              mysqli_stmt_bind_param($cstmt, 'i', $class_id);
              mysqli_stmt_execute($cstmt);
              $cres = mysqli_stmt_get_result($cstmt);
              if ($cres && mysqli_num_rows($cres) > 0) {
                $crow = mysqli_fetch_assoc($cres);
                $class = $crow['class'] ?? '';
                $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
              }
              mysqli_stmt_close($cstmt);
            }

            // get subject
            $subject = '';
            $sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
            if ($sstmt) {
              mysqli_stmt_bind_param($sstmt, 'i', $subject_id);
              mysqli_stmt_execute($sstmt);
              $sres = mysqli_stmt_get_result($sstmt);
              if ($sres && mysqli_num_rows($sres) > 0) {
                $srow = mysqli_fetch_assoc($sres);
                $subject = $srow['subject'] ?? '';
              }
              mysqli_stmt_close($sstmt);
            }

            // get financial term
            $term = '';
            $year = '';
            $tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE status = 1 AND financialterm_id = ? LIMIT 1");
            if ($tstmt) {
              mysqli_stmt_bind_param($tstmt, 'i', $term_value);
              mysqli_stmt_execute($tstmt);
              $tres = mysqli_stmt_get_result($tstmt);
              if ($tres && mysqli_num_rows($tres) > 0) {
                $trow = mysqli_fetch_assoc($tres);
                $term = $trow['term'] ?? '';
                $year = $trow['year'] ?? '';
              }
              mysqli_stmt_close($tstmt);
            }
          }

          ?>
          <?php if ($plan) { ?>
          <section class="panel">
            <header class="panel-heading">
              <?php echo htmlspecialchars(($subject ?? '') . ':' . ($class ?? '') . ' Mid Term Plan', ENT_QUOTES); ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">
                <tbody>
                  <tr class="gradeA">
                    <th> Subject</th>
                    <td><?php echo htmlspecialchars($subject ?? '', ENT_QUOTES); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th> Term</th>
                    <td><?php echo htmlspecialchars($term ?? '', ENT_QUOTES); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th> Year</th>
                    <td><?php echo htmlspecialchars($year ?? '', ENT_QUOTES); ?></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </section>

        </div>
        <div class="col-lg-6">

        </div>

      </div>
      <div class="row">

        <div class="col-lg-10">
          <section class="panel">
            <header class="panel-heading">
              Long-term Plan Document
            </header>
            <div class="panel-body">
              <?php
              // use file_path from the initial plan row if available
              $file_path = $plan['file_path'] ?? '';
              // robust resolution: try multiple disk candidates and prefer uploads path for web URL
              $pdf_web = '';
              $pdf_disk = null;
              if (!empty($file_path)) {
                $candidates = [];
                $candidates[] = $file_path; // maybe absolute
                $candidates[] = __DIR__ . '/../' . ltrim($file_path, '/\\');
                $b = basename($file_path);
                if ($b !== '') {
                  $candidates[] = __DIR__ . '/../uploads/longterm_plans/' . $b;
                }

                foreach ($candidates as $cand) {
                  if ($cand && file_exists($cand) && is_file($cand)) {
                    $pdf_disk = $cand;
                    break;
                  }
                }

                if ($pdf_disk) {
                  if (strpos($file_path, 'uploads/') !== false) {
                    $pdf_web = rtrim(BASE_URL, '/') . '/' . ltrim($file_path, '/\\');
                  } else {
                    $pdf_web = rtrim(BASE_URL, '/') . '/uploads/longterm_plans/' . rawurlencode(basename($pdf_disk));
                  }
                }
              }

              if ($pdf_web) {
              ?>
                  <div class="pdf-container" style="width: 100%; height: 800px;">
                    <iframe
                      src="<?php echo htmlspecialchars($pdf_web, ENT_QUOTES); ?>"
                      width="100%"
                      height="100%"
                      style="border: none;"
                      frameborder="0"
                      allowfullscreen>
                    </iframe>
                  </div>
                  <?php if (!empty($pdf_web)): ?>
                    <p style="margin-top:8px"><a href="<?php echo htmlspecialchars($pdf_web, ENT_QUOTES); ?>" target="_blank">Open PDF in new tab</a></p>
                  <?php endif; ?>
              <?php
              } elseif (!empty($file_path)) {
                echo '<div class="alert alert-warning">PDF file not found on disk.</div>';
              } else {
                echo '<div class="alert alert-info">No document uploaded for this long-term plan.</div>';
              }
              ?>
            </div>
          </section>

        </div>

      </div>
      <?php } // end if ($plan) ?>

    </div>
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

</body>

</html>