<?php
include '../includes/conn.php';

// session guard
if (!isset($_SESSION['teachersys'])) {
    header('Location: ../login.php');
    exit;
}

// validate POST input
$type = filter_input(INPUT_POST, 'type', FILTER_SANITIZE_STRING) ?: '';
if ($type !== 'fetch') {
    // nothing to do
    exit;
}

header('Content-Type: application/json; charset=utf-8');

$events = [];

// prepared select (no external params but prepare for consistency)
$stmt = mysqli_prepare($con, "SELECT event_id, eventname, description, startdate, enddate FROM events WHERE status = 1");
if ($stmt) {
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    while ($row = mysqli_fetch_assoc($res)) {
        $e = [];
        $startdate = isset($row['startdate']) ? (int)$row['startdate'] : 0;
        $enddate = isset($row['enddate']) ? (int)$row['enddate'] : $startdate;
        $eventname = $row['eventname'] ?? '';
        $event_id = isset($row['event_id']) ? (int)$row['event_id'] : 0;
        $description = $row['description'] ?? '';

        // Create ISO date strings and use timed end-of-day so the event includes
        // the configured end date (avoid exclusive-end confusion and timezone shifts)
        $getsdate = date('Y-m-d', $startdate);
        $getedate = date('Y-m-d', $enddate);

        $e['url'] = 'event?id=' . $event_id;
        $e['id'] = $event_id;
        // sanitize title: remove HTML tags and collapse whitespace so calendar doesn't render HTML snippets
        $cleanTitle = strip_tags($eventname);
        $cleanTitle = html_entity_decode($cleanTitle, ENT_QUOTES | ENT_HTML5, 'UTF-8');
        $cleanTitle = trim(preg_replace('/\s+/', ' ', $cleanTitle));
        $e['title'] = $cleanTitle;
        $e['start'] = $getsdate . 'T00:00:00';
        $e['end'] = $getedate . 'T23:59:59';
        $e['allDay'] = false;

        $events[] = $e;
    }
    mysqli_stmt_close($stmt);
}

echo json_encode($events);
?>