 <?php 
include '../includes/conn.php';
if (isset($_SESSION['teachersys'])) {
	 header('Location: index');
	 exit;
}
     ?>
<!DOCTYPE html>
<!--[if IE 8]>         <html class="ie8"> <![endif]-->
<!--[if IE 9]>         <html class="ie9 gt-ie8"> <![endif]-->
<!--[if gt IE 9]><!--> <html class="gt-ie8 gt-ie9 not-ie"> <!--<![endif]-->

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<title>Confirm Email - School  System</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">

	<!-- Open Sans font from Google CDN -->
	<link href="http://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,400,600,700,300&amp;subset=latin" rel="stylesheet" type="text/css">

	<!-- Pixel Admin's stylesheets -->
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/pixel-admin.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/pages.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/rtl.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/themes.min.css" rel="stylesheet" type="text/css">

	<!--[if lt IE 9]>
		<script src="assets/javascripts/ie.min.js"></script>
	<![endif]-->


<!-- $DEMO =========================================================================================

	Remove this section on production
-->
	<style>
		#signin-demo {
			position: fixed;
			right: 0;
			bottom: 0;
			z-index: 10000;
			background: rgba(0,0,0,.6);
			padding: 6px;
			border-radius: 3px;
		}
		#signin-demo img { cursor: pointer; height: 40px; }
		#signin-demo img:hover { opacity: .5; }
		#signin-demo div {
			color: #fff;
			font-size: 10px;
			font-weight: 600;
			padding-bottom: 6px;
		}
	</style>
<!-- / $DEMO -->

</head>


<!-- 1. $BODY ======================================================================================
	
	Body

	Classes:
	* 'theme-{THEME NAME}'
	* 'right-to-left'     - Sets text direction to right-to-left
-->
<body class="theme-default page-signin">


	<!-- Page background -->
	<div id="page-signin-bg">
		<!-- Background overlay -->
		<div class="overlay"></div>
		<!-- Replace this with your bg image -->
          <img src="<?php echo BASE_URL;?>/assets/demo/bimsbg.jpg" alt="">
	</div>
	<!-- / Page background -->

	<!-- Container -->
	<div class="signin-container">

		<!-- Left side -->
		

		<!-- Right side -->
		<div class="signin-form">

			<!-- Form -->
                        <form action="" id="signin-form_id" method="post">
				<div class="signin-text">
					<span>Enter Email  submitted during registration</span>
				</div> <!-- / .signin-text -->
									<?php
										if ($_SERVER['REQUEST_METHOD'] === 'POST') {
											$email = trim((string)($_POST['email'] ?? ''));
											if ($email === '') {
												echo '<div class="alert alert-danger">Enter Email to Proceed</div>';
											} elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
												echo '<div class="alert alert-danger">Enter a valid Email address</div>';
											} else {
												// Prepared statement to find teacher by email
												$stmt = mysqli_prepare($con, "SELECT teacher_id,username FROM teachers WHERE email = ? AND status = 1 LIMIT 1");
												if ($stmt) {
													mysqli_stmt_bind_param($stmt, 's', $email);
													mysqli_stmt_execute($stmt);
													$res = mysqli_stmt_get_result($stmt);
													if ($res && $row1 = mysqli_fetch_assoc($res)) {
														$username = $row1['username'] ?? '';
														$teacher_id = (int)($row1['teacher_id'] ?? 0);

														// Use secure random generator
														try {
															$code = random_int(100000, 999999);
														} catch (Exception $e) {
															$code = mt_rand(100000, 999999);
														}

														$to = $email;
														$subject = 'Confirmation Code';
														$message = '<p>Username is ' . htmlspecialchars($username) . '.</p>';
														$message .= '<p>Your confirmation code is <strong>' . $code . '</strong></p>';

														$headers = 'From: info@harvestacademy.ac.ug\r\n';
														$headers .= 'MIME-Version: 1.0\r\n';
														$headers .= 'Content-type: text/html; charset=UTF-8\r\n';

														$retval = mail($to, $subject, $message, $headers);
														if ($retval == false) {
															echo '<div class="alert alert-danger">Error: Email not sent</div>';
														} else {
															// Insert temp code using prepared statement
															$ins = mysqli_prepare($con, "INSERT INTO temp (user_id,email,code,user) VALUES (?,?,?, 'teacher')");
															if ($ins) {
																mysqli_stmt_bind_param($ins, 'isi', $teacher_id, $email, $code);
																mysqli_stmt_execute($ins);
															}
															$link = 'entercode?e=' . urlencode($email) . '&t=' . (int)$teacher_id;
															echo '<div class="alert alert-success">A confirmation Code has been sent to your email. Click <a href="' . htmlspecialchars($link) . '">Here</a> to enter Code</div>';
														}
													} else {
														echo '<div class="alert alert-danger">No teacher added with that email</div>';
													}
												} else {
													echo '<div class="alert alert-danger">Server error</div>';
												}
											}
										}
										?>
                              				<div class="form-group w-icon">
                                                            <input type="email" name="email" id="email_id" class="form-control input-lg" placeholder="Email">
					<!--<span class="fa fa- signin-form-icon"></span>-->
				</div> <!-- / Username -->
			
				<div class="form-actions">
					<input type="submit" value="Submit" class="signin-btn bg-primary">
					
				</div> <!-- / .form-actions -->
			</form>
			<!-- / Form -->

		</div>
		<!-- Right side -->
	</div>
	<!-- / Container -->
<div class="not-a-member">
    <a href="login">Back to Login</a>
	</div>
	<!-- Get jQuery from Google CDN -->
<!--[if !IE]> -->
	<script type="text/javascript"> window.jQuery || document.write('<script src="js/jquery-1.10.2.min.js">'+"<"+"/script>"); </script>
<!-- <![endif]-->
<!--[if lte IE 9]>
	<script type="text/javascript"> window.jQuery || document.write('<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js">'+"<"+"/script>"); </script>
<![endif]-->


<!-- Pixel Admin's javascripts -->
<script src="<?php echo BASE_URL; ?>/assets/javascripts/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/assets/javascripts/pixel-admin.min.js"></script>

<script type="text/javascript">
	// Resize BG
//	init.push(function () {
//		var $ph  = $('#page-signin-bg'),
//		    $img = $ph.find('> img');
//
//		$(window).on('resize', function () {
//			$img.attr('style', '');
//			if ($img.height() < $ph.height()) {
//				$img.css({
//					height: '100%',
//					width: 'auto'
//				});
//			}
//		});
//	});

		// Setup Sign In form validation
	init.push(function () {
		$("#signin-form_id").validate({ focusInvalid: true, errorPlacement: function () {} });
		
		// Validate username
		$("#username_id").rules("add", {
			required: true,
			minlength: 3
		});

		// Validate password
		$("#password_id").rules("add", {
			required: true,
			minlength: 1
		});
	});

	// Setup Password Reset form validation
	

	window.PixelAdmin.start(init);
</script>

</body>

</html>
