<?php
include '../includes/conn.php';
// ensure session started
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// Validate GET params
$class_param = isset($_GET['class']) ? (string)$_GET['class'] : '';
$term = isset($_GET['term']) ? (int)$_GET['term'] : 0;
if ($class_param === '' || $term <= 0) {
  echo '<div class="alert alert-danger">Missing parameters</div>';
  exit;
}

$split = explode(',', $class_param);
$class_id = (int)(current($split) ?? 0);
$subject_id = (int)(end($split) ?? 0);
if ($class_id <= 0) {
  echo '<div class="alert alert-danger">Invalid class</div>';
  exit;
}

// Fetch class info
$class_name = '';
$reportype = '';
$category_id = null;
$getclasses = mysqli_query($con, "SELECT class,report_type,category_id FROM classes WHERE class_id='{$class_id}' LIMIT 1");
if ($getclasses && $row2 = mysqli_fetch_assoc($getclasses)) {
  $class_name = $row2['class'] ?? '';
  $reportype = $row2['report_type'] ?? '';
  $category_id = $row2['category_id'] ?? null;
}

// Fetch subject name
$subject = '';
if ($subject_id > 0) {
  $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id='{$subject_id}' LIMIT 1");
  if ($getsubjects && $row3 = mysqli_fetch_assoc($getsubjects)) {
    $subject = $row3['subject'] ?? '';
  }
}

// Fetch term info
$term2 = '';
$year = '';
$getterm = mysqli_query($con, "SELECT term,year FROM financialterms WHERE financialterm_id='{$term}' LIMIT 1");
if ($getterm && $row4 = mysqli_fetch_assoc($getterm)) {
  $term2 = $row4['term'] ?? '';
  $year = $row4['year'] ?? '';
}
              ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>All <?php echo htmlspecialchars($class_name ?? '', ENT_QUOTES); ?> Students</title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                      <section class="panel">
                    <header class="panel-heading">
                      All <?php echo htmlspecialchars($class_name ?? '', ENT_QUOTES); ?> Students
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped" id="dynamic-table">
        <thead>
        <tr>
                                            <th>Full Names</th>
                                            <th>Nationality</th>
                                                    
                                                                   <th>Action</th>
                  </tr>
        </thead>
        <tbody>
    
          <?php
                        // Use prepared statement and associative fetch for PHP 8.3 compatibility and to avoid notices
                        $students_stmt = mysqli_prepare($con, "SELECT regnumber, student_id, fullname, gender, class_id AS student_class_id, status, nationality, ext FROM students WHERE status=1 AND class_id = ?");
                        if ($students_stmt) {
                            mysqli_stmt_bind_param($students_stmt, 'i', $class_id);
                            mysqli_stmt_execute($students_stmt);
                            $students_res = mysqli_stmt_get_result($students_stmt);
                        } else {
                            // fallback to direct query if prepare fails for any reason
                            $students_res = mysqli_query($con, "SELECT regnumber, student_id, fullname, gender, class_id AS student_class_id, status, nationality, ext FROM students WHERE status=1 AND class_id='" . (int)$class_id . "'");
                        }

                        while ($row = $students_res ? mysqli_fetch_assoc($students_res) : null) {
                            $regnumber = $row['regnumber'] ?? '';
                            $student_id = (int)($row['student_id'] ?? 0);
                            $fullname = $row['fullname'] ?? '';
                            $gender = $row['gender'] ?? '';
                            $student_class_id = (int)($row['student_class_id'] ?? 0);
                            $status = $row['status'] ?? '';
                            $nationality = $row['nationality'] ?? '';
                            $ext = $row['ext'] ?? '';

          ?>
                 <tr class="gradeA">
                      <td><?php echo htmlspecialchars($fullname, ENT_QUOTES, 'UTF-8'); ?></td>
                      <td><?php echo htmlspecialchars($nationality, ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td>
                                                <a href="addeffort?id=<?php echo $student_id; ?>&tm=<?php echo $term; ?>&sub=<?php echo $subject_id; ?>" target="_blank" class="btn btn-success btn-xs"><i class="fa fa-edit"></i> Add Effort</a>
                                                <!-- <a href="addcomment?id=<?php echo $student_id; ?>" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Add Comment</a> -->
                                            </td>
                   </tr>
            <?php }
                        if (isset($students_stmt) && $students_stmt) mysqli_stmt_close($students_stmt);
            ?>
        </tbody>
                        </table>
                          </div>
                          </div>
   
        </div>
        

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL;?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>

</body>
</html>
