<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}

// Only class teachers may edit timetables. Block other teacher accounts here.
if (($_SESSION['classteacher'] ?? '') !== 'yes') {
    // Not authorized to edit timetables
    header('Location: index.php');
    exit;
}

// Validate and sanitize GET params
// sanitize inputs: allow stream id (st) to be zero for classes without streams
$cl = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
$st = filter_input(INPUT_GET, 'st', FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
$day = filter_input(INPUT_GET, 'day', FILTER_SANITIZE_STRING);
if (!$cl || !$day) {
    header('Location: edittimetable');
    exit;
}

// Ensure the logged-in class teacher edits only their assigned class
$session_class = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
if ($session_class > 0 && $session_class !== (int)$cl) {
    // Attempt to edit a different class - deny and redirect to the teacher's own timetable
    header('Location: timetable.php?class=' . urlencode($session_class));
    exit;
}

$stream = '';
$class = '';
$fullday = '';

// fetch class
$cstmt = mysqli_prepare($con, "SELECT `class` FROM classes WHERE class_id = ?");
if ($cstmt) {
    mysqli_stmt_bind_param($cstmt, 'i', $cl);
    mysqli_stmt_execute($cstmt);
    $cres = mysqli_stmt_get_result($cstmt);
    if ($cres && mysqli_num_rows($cres) > 0) {
        $crow = mysqli_fetch_assoc($cres);
        $class = $crow['class'] ?? '';
    }
    mysqli_stmt_close($cstmt);
}

// fetch stream
$sstmt = mysqli_prepare($con, "SELECT `stream` FROM streams WHERE stream_id = ?");
if ($sstmt) {
    mysqli_stmt_bind_param($sstmt, 'i', $st);
    mysqli_stmt_execute($sstmt);
    $sres = mysqli_stmt_get_result($sstmt);
    if ($sres && mysqli_num_rows($sres) > 0) {
        $srow = mysqli_fetch_assoc($sres);
        $stream = $srow['stream'] ?? '';
    }
    mysqli_stmt_close($sstmt);
}

// fetch day name
$dstmt = mysqli_prepare($con, "SELECT `day` FROM days WHERE `short` = ?");
if ($dstmt) {
    mysqli_stmt_bind_param($dstmt, 's', $day);
    mysqli_stmt_execute($dstmt);
    $dres = mysqli_stmt_get_result($dstmt);
    if ($dres && mysqli_num_rows($dres) > 0) {
        $drow = mysqli_fetch_assoc($dres);
        $fullday = $drow['day'] ?? '';
    }
    mysqli_stmt_close($dstmt);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="t">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>Edit Timetable for <?php echo $fullday . ' ' . $class . ' ' . $stream; ?></title>

    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/ckeditor/ckeditor.js"></script>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/base/jquery.ui.all.css">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
    <link href="<?php echo BASE_URL; ?>/css/chosen/chosen.css" rel="stylesheet">
    <style>
        #sortable {
            list-style-type: none;
            margin: 0;
            padding: 0;
            width: 100%;
        }

        #sortable li {
            margin: 0 3px 3px 3px;
            padding: 1em;
            padding-left: 1.5em;
            font-size: 12px;
            height: 36px;
            color: #000
        }

        #sortable li span {
            position: absolute;
            margin-left: -1.3em;
        }
    </style>
</head>

<body class="sticky-header">
    <section>
    <?php include 'nav.php'; ?>

        <section class="wrapper">
            <!-- page start-->

            <div class="row">
                <div class="col-lg-5">
                    <section class="panel">
                        <header class="panel-heading">
                            Add Timetable Activity for <?php echo $fullday; ?>
                        </header>
                        <div class="panel-body">
                            <?php
                            if (isset($_POST['submit'])) {
                                $classsubject = filter_input(INPUT_POST, 'classsubject', FILTER_SANITIZE_NUMBER_INT);
                                $starttime = trim(filter_input(INPUT_POST, 'starttime', FILTER_SANITIZE_STRING));
                                $activity = trim(filter_input(INPUT_POST, 'activity', FILTER_SANITIZE_STRING));
                                $endtime = trim(filter_input(INPUT_POST, 'endtime', FILTER_SANITIZE_STRING));
                                $errors = [];

                                if (empty($starttime) || empty($endtime)) {
                                    $errors[] = 'Some Fields are Empty';
                                }

                                if (empty($classsubject) && empty($activity)) {
                                    $errors[] = 'Class Subject or Activity should be Filled';
                                }

                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                    }
                                } else {
                                    $status = 1;
                                    // prepared insert
                                    $istmt = mysqli_prepare($con, "INSERT INTO timetables(class_id,stream_id,activity,starttime,endtime,day,position,status) VALUES (?, ?, ?, ?, ?, ?, 0, ?)");
                                    if ($istmt) {
                                        // activity may be either class_sub_id (int) or a text activity. store as string.
                                        $act_param = !empty($activity) ? $activity : (string)$classsubject;
                                        mysqli_stmt_bind_param($istmt, 'iissssi', $cl, $st, $act_param, $starttime, $endtime, $day, $status);
                                        mysqli_stmt_execute($istmt);
                                        mysqli_stmt_close($istmt);
                                    }
                                }
                                echo '<div class="alert alert-success">Timetable Activity Successfully Edited.</div>';
                            }

                            ?>
                            <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                                <div class="alert alert-info">Either select a <strong>subject</strong> or Enter <strong>activity</strong> for a particular time session but not both</div>

                                <div class="form-group"><label class="control-label">Subject</label>
                                    <select data-placeholder="Choose class..." name="classsubject" class="chosen-select" style="width:100%;" tabindex="2">
                                        <option value="">Select Subject</option>
                                        <?php
                                        // load class subjects with their class and subject names using a JOIN
                                        $cs_stmt = mysqli_prepare($con, "SELECT cs.class_sub_id, c.class, s.subject FROM class_subjects cs JOIN classes c ON cs.class_id=c.class_id JOIN subjects s ON cs.subject_id=s.subject_id WHERE cs.class_id = ?");
                                        if ($cs_stmt) {
                                            mysqli_stmt_bind_param($cs_stmt, 'i', $cl);
                                            mysqli_stmt_execute($cs_stmt);
                                            $cs_res = mysqli_stmt_get_result($cs_stmt);
                                            while ($crow = mysqli_fetch_assoc($cs_res)) {
                                                $class_sub_id = $crow['class_sub_id'];
                                                $class_name = $crow['class'];
                                                $subject = $crow['subject'];
                                        ?>
                                                <option value="<?php echo htmlspecialchars($class_sub_id, ENT_QUOTES); ?>"><?php echo htmlspecialchars($class_name . ':' . $subject, ENT_QUOTES); ?></option>
                                        <?php
                                            }
                                            mysqli_stmt_close($cs_stmt);
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group"><label class="control-label">Activity (Enter if isn't a subject e.g Lunch)</label>

                                    <input type="text" class="form-control" name="activity" placeholder="enter activity">
                                </div>
                                <div class="form-group">
                                    <label class="control-label">Start Time (Click on clock icon)</label>
                                    <div class="input-group bootstrap-timepicker">
                                        <input type="text" class="form-control timepicker-24" name="starttime" required="required">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label">End Time (Click on Clock icon)</label>
                                    <div class="input-group bootstrap-timepicker">
                                        <input type="text" class="form-control timepicker-24" name="endtime" required="required">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <button class="btn btn-primary" type="submit" name="submit">Submit</button>
                                </div>
                            </form>
                        </div>
                </div>
                <div class="col-lg-6">
                    <section class="panel">
                        <header class="panel-heading">
                            <?php echo $class . ' ' . $stream; ?> Timetable for <?php echo $fullday; ?>
                        </header>
                        <div class="panel-body">
                            <div class="alert alert-warning"><strong>Drag and Drop To Sort and Rearrange</strong></div>
                            <div id="area" style="text-align:center"></div>
                            <ul id="sortable">
                                <?php
                                // prepared timetable select
                                $tt_stmt = mysqli_prepare($con, "SELECT `timetable_id`, `activity`, `starttime`, `endtime` FROM `timetables` WHERE `class_id`=? AND `stream_id`=? AND `day`=? AND `status`=1 ORDER BY `position`");
                                $subject = '';
                                if ($tt_stmt) {
                                    // allow stream id to be zero; use integer binding
                                    mysqli_stmt_bind_param($tt_stmt, 'iis', $cl, $st, $day);
                                    mysqli_stmt_execute($tt_stmt);
                                    $tt_res = mysqli_stmt_get_result($tt_stmt);

                                    // prepared statement to resolve class_sub_id -> subject
                                    $sub_stmt = mysqli_prepare($con, "SELECT s.subject FROM class_subjects cs JOIN subjects s ON cs.subject_id = s.subject_id WHERE cs.class_sub_id = ?");

                                    while ($row = mysqli_fetch_assoc($tt_res)) {
                                        $activity = $row['activity'];
                                        $timetable_id = $row['timetable_id'];
                                        $starttime = $row['starttime'];
                                        $endtime = $row['endtime'];
                                        $subject = '';
                                        // if activity is numeric, try to resolve subject name
                                        if ($sub_stmt && ctype_digit((string)$activity)) {
                                            mysqli_stmt_bind_param($sub_stmt, 'i', $activity);
                                            mysqli_stmt_execute($sub_stmt);
                                            $sres = mysqli_stmt_get_result($sub_stmt);
                                            if ($sres && mysqli_num_rows($sres) > 0) {
                                                $srow = mysqli_fetch_assoc($sres);
                                                $subject = $srow['subject'] ?? '';
                                            }
                                        }
                                ?>
                                    <li class="ui-state-default" id="item_<?php echo $timetable_id; ?>"><span class="ui-icon ui-icon-arrowthick-2-n-s"></span>

                                        <?php
                                        echo htmlspecialchars($starttime, ENT_QUOTES) . ' to ' . htmlspecialchars($endtime, ENT_QUOTES) . ' | ';
                                        if (!empty($subject)) {
                                            echo htmlspecialchars($subject, ENT_QUOTES);
                                        } else {
                                            echo htmlspecialchars($activity, ENT_QUOTES);
                                        } ?>
                                        <div class="pull-right" style="margin-top: -5px;">
                                            <a href="editactivity?id=<?php echo $timetable_id ?>&&cl=<?php echo $cl; ?>&&st=<?php echo $st; ?>&&day=<?php echo $day; ?>" class="btn btn-xs btn-info" style="color:#fff;">Edit</a>
                                            <a href="removeactivity?id=<?php echo $timetable_id ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $timetable_id; ?>()" style="color:#fff">Remove</a>
                                        </div>
                                        <script type="text/javascript">
                                            function confirm_delete<?php echo $timetable_id; ?>() {
                                                return confirm('You are about To Remove this activity. Are you sure you want to proceed?');
                                            }
                                        </script>
                                    </li>
                                <?php  }
                                    if ($sub_stmt) mysqli_stmt_close($sub_stmt);
                                    mysqli_stmt_close($tt_stmt);
                                }
                                ?>


                            </ul>

                        </div>

                </div>

        </section>

        </div>

        </div>


        </div>
        <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
    </section>

    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/chosen/chosen.jquery.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/pickers-init.js?<?php echo time(); ?>"></script>
    <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
    <script src="<?php echo BASE_URL; ?>/ui/jquery.ui.core.js"></script>
    <script src="<?php echo BASE_URL; ?>/ui/jquery.ui.widget.js"></script>
    <script src="<?php echo BASE_URL; ?>/ui/jquery.ui.mouse.js"></script>
    <script src="<?php echo BASE_URL; ?>/ui/jquery.ui.sortable.js"></script>

    <script>
        $(function() {
            //var dataString = 'fullname='+ fullname + '&email='+ email + '&comment='+ comment;
            $("#sortable").sortable({
                stop: function(i) {
                    $.ajax({
                        type: "GET",
                        url: "<?php echo BASE_URL; ?>/sort.php",
                        data: $("#sortable").sortable("serialize"),
                        beforeSend: function() {
                            $("#area").html('<img src="<?php echo BASE_URL; ?>/images/input-spinner.gif" >');
                        },
                        success: function(response) {
                            $("#area").hide().fadeIn('slow').html("<div class='text-success'><strong>Sorting successfully Done</strong></div>");
                        }
                    });
                }
            });
        });
        var config = {
            '.chosen-select': {},
            '.chosen-select-deselect': {
                allow_single_deselect: true
            },
            '.chosen-select-no-single': {
                disable_search_threshold: 10
            },
            '.chosen-select-no-results': {
                no_results_text: 'Oops, nothing found!'
            },
            '.chosen-select-width': {
                width: "95%"
            }
        }
        for (var selector in config) {
            $(selector).chosen(config[selector]);
        }
        $('.timepicker-24').timepicker({
            autoclose: true,
            minuteStep: 5,
            showSeconds: false,
            showMeridian: false
        });
    </script>
</body>

</html>