<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// Validate GET id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: marks');
  exit;
}

// Fetch mark row using prepared statement
$mark_id = null;
$mark = '';
$student_id = null;
$sub = null;
$cl = null;
$tm = null;
$as = null;
$status = null;
$rank = null;

$mstmt = mysqli_prepare($con, "SELECT * FROM marks WHERE mark_id = ?");
if ($mstmt) {
  mysqli_stmt_bind_param($mstmt, 'i', $id);
  mysqli_stmt_execute($mstmt);
  $mres = mysqli_stmt_get_result($mstmt);
  if ($mres && mysqli_num_rows($mres) > 0) {
    $row = mysqli_fetch_assoc($mres);
    $mark_id = $row['mark_id'];
    $mark = $row['marks'];
    $student_id = $row['student_id'];
    $sub = $row['subject_id'];
    $cl = $row['class_id'];
    $tm = $row['term_id'];
    $as = $row['assessment'];
    $status = $row['status'];
    $rank = $row['rank'];
  }
  mysqli_stmt_close($mstmt);
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>View Marks-School Manager</title>
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
</head>
<body>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                     Edit Mark
                    </header>
                          <div class="panel-body">
  <?php
  // Fetch student fullname
  $fullname = '';
  $sstmt = mysqli_prepare($con, "SELECT fullname FROM students WHERE student_id = ?");
  if ($sstmt) {
    mysqli_stmt_bind_param($sstmt, 'i', $student_id);
    mysqli_stmt_execute($sstmt);
    $sres = mysqli_stmt_get_result($sstmt);
    if ($sres && mysqli_num_rows($sres) > 0) {
      $srow = mysqli_fetch_assoc($sres);
      $fullname = $srow['fullname'] ?? '';
    }
    mysqli_stmt_close($sstmt);
  }

  ?>
                    
 <form method="POST" name='form' class="form" action=""  enctype="multipart/form-data">
                              <?php
                                        if (isset($_POST['mark'])) {
                                          $stdmark = trim($_POST['mark']);
                                          $errors = [];
                                          if (!is_numeric($stdmark)) {
                                             $errors[] = 'Mark should be an integer';
                                          } else {
                                            $stdmark = (int)$stdmark;
                                          }
                                          if (isset($rank) && is_numeric($rank) && $stdmark > (int)$rank) {
                                              $errors[] = 'Mark is greater than the allowed maximum (' . htmlspecialchars($rank, ENT_QUOTES) . ')';
                                          }
                                          if (!empty($errors)) {
                                              foreach ($errors as $error) {
                                                  echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                              }
                                          } else {
                                            $ust = mysqli_prepare($con, "UPDATE marks SET marks = ? WHERE mark_id = ?");
                                            if ($ust) {
                                                mysqli_stmt_bind_param($ust, 'ii', $stdmark, $id);
                                                mysqli_stmt_execute($ust);
                                                mysqli_stmt_close($ust);
                                            }
                                            echo '<div class="alert alert-success"><strong>' . htmlspecialchars($fullname, ENT_QUOTES) . '</strong> Marks Successfully Edited</div>';
                                          }
                                        }
                                                           ?>
                              
                             <div class="form-group"><label class="control-label">*<?php echo $fullname; ?></label>

                                                         <input type="text" value="<?php echo htmlspecialchars($mark, ENT_QUOTES); ?>" name="mark" class="form-control">
                                        
                                        </select>
                                                                                                        </div>
                             
                                                                            

                                                        <div class="hr-line-dashed"></div>
                            
                                                                                                  
                                <div class="form-group">
                                                                   
                                        <button class="btn btn-primary" type="submit">Edit Marks</button>
                                                              </div>
                            </form>
                              </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
 <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
</body>

</html>
 