<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] != 'yes')) {
  header('Location: login.php');
  exit;
}

// Validate attendance id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: attendance.php');
  exit;
}

// Fetch class name for the logged-in classteacher
$class = '';
$cstmt = mysqli_prepare($con, "SELECT `class` FROM classes WHERE class_id = ?");
if ($cstmt) {
  $class_id_for_stmt = (int)$_SESSION['class_id'];
  mysqli_stmt_bind_param($cstmt, 'i', $class_id_for_stmt);
  mysqli_stmt_execute($cstmt);
  $cres = mysqli_stmt_get_result($cstmt);
  if ($cres && mysqli_num_rows($cres) > 0) {
    $crow = mysqli_fetch_assoc($cres);
    $class = $crow['class'] ?? '';
  }
  mysqli_stmt_close($cstmt);
}

// Fetch attendance meta
$date = '';
$time = '';
$attendance_id = $id;
$attendees = [];
$astmt = mysqli_prepare($con, "SELECT * FROM attendance WHERE status = 1 AND attendance_id = ?");
if ($astmt) {
  mysqli_stmt_bind_param($astmt, 'i', $id);
  mysqli_stmt_execute($astmt);
  $ares = mysqli_stmt_get_result($astmt);
  if ($ares && mysqli_num_rows($ares) > 0) {
    $row1 = mysqli_fetch_assoc($ares);
    $date = $row1['date'];
    $time = $row1['time'];
    $attendance_id = $row1['attendance_id'];
  }
  mysqli_stmt_close($astmt);
}

// Fetch existing attendancedetails if needed later
$adstmt = mysqli_prepare($con, "SELECT * FROM attendancedetails WHERE attendance_id = ?");
if ($adstmt) {
  mysqli_stmt_bind_param($adstmt, 'i', $attendance_id);
  mysqli_stmt_execute($adstmt);
  $adres = mysqli_stmt_get_result($adstmt);
  if ($adres) {
    while ($arow = mysqli_fetch_assoc($adres)) {
      $attendees[] = $arow;
    }
  }
  mysqli_stmt_close($adstmt);
}
              ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Add <?php echo $class;?> Attendance</title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
 <link href="<?php echo BASE_URL;?>/datapicker/datepicker3.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                      Add <?php echo $class;?>  Attendance
                    </header>
                          <div class="panel-body">
                              <?php
                if (isset($_POST['date'], $_POST['term'], $_POST['time'])) {
                  // sanitize inputs
                  $date_raw = trim($_POST['date']);
                  $term = filter_var($_POST['term'], FILTER_VALIDATE_INT);
                  $time = strtoupper(trim($_POST['time'] ?? ''));
                  $attendance = isset($_POST['attendance']) && is_array($_POST['attendance']) ? $_POST['attendance'] : [];
                  $status = isset($_POST['status']) && is_array($_POST['status']) ? $_POST['status'] : [];

                  // normalize date to YYYY-MM-DD
                  $date_ts = strtotime($date_raw);
                  $date = $date_ts ? date('Y-m-d', $date_ts) : '';

                  $errors = [];
                  if (empty($date) || empty($term) || empty($time)) {
                    $errors[] = 'Some Fields are Empty';
                  }
                  if (!in_array($time, ['AM', 'PM'], true)) {
                    $errors[] = 'Invalid time selected';
                  }

                  if (!empty($errors)) {
                    foreach ($errors as $err) {
                      echo '<div class="alert alert-danger">' . htmlspecialchars($err, ENT_QUOTES) . '</div>';
                    }
                  } else {
                    // Insert attendance using prepared statement
                    $ins = mysqli_prepare($con, "INSERT INTO attendance(`date`, term_id, teacher_id, class_id, `time`, status) VALUES (?, ?, ?, ?, ?, 1)");
                    if ($ins) {
                      $teacher_id = (int)$_SESSION['teachersys'];
                      $class_id_sess = (int)$_SESSION['class_id'];
                      mysqli_stmt_bind_param($ins, 'siiss', $date, $term, $teacher_id, $class_id_sess, $time);
                      mysqli_stmt_execute($ins);
                      mysqli_stmt_close($ins);
                    }
                    $last_id = mysqli_insert_id($con);

                    // Prepare statement for inserting attendancedetails
                    $insd = mysqli_prepare($con, "INSERT INTO attendancedetails(attendance_id, student_id, details, status) VALUES (?, ?, ?, ?)");
                    if ($insd) {
                      for ($i = 0; $i < count($attendance); $i++) {
                        $stud = (int)$attendance[$i];
                        $st = isset($status[$i]) ? (int)$status[$i] : 0;
                        mysqli_stmt_bind_param($insd, 'iiis', $last_id, $stud, $empty = '', $st);
                        // note: bind_param requires variables; use empty string variable and status as int/string as appropriate
                        mysqli_stmt_execute($insd);
                      }
                      mysqli_stmt_close($insd);
                    }

                    // Ensure every student in class has a record; fetch students via prepared stmt
                    $sstmt = mysqli_prepare($con, "SELECT student_id FROM students WHERE class_id = ?");
                    if ($sstmt) {
                      mysqli_stmt_bind_param($sstmt, 'i', $class_id_sess);
                      mysqli_stmt_execute($sstmt);
                      $sres = mysqli_stmt_get_result($sstmt);
                      if ($sres) {
                        $checkstmt = mysqli_prepare($con, "SELECT 1 FROM attendancedetails WHERE attendance_id = ? AND student_id = ?");
                        $insabs = mysqli_prepare($con, "INSERT INTO attendancedetails(attendance_id, student_id, details, status) VALUES (?, ?, ?, ?)");
                        while ($srow = mysqli_fetch_assoc($sres)) {
                          $student_id = (int)$srow['student_id'];
                          // check
                          $exists = false;
                          if ($checkstmt) {
                            mysqli_stmt_bind_param($checkstmt, 'ii', $last_id, $student_id);
                            mysqli_stmt_execute($checkstmt);
                            $cres = mysqli_stmt_get_result($checkstmt);
                            if ($cres && mysqli_num_rows($cres) > 0) {
                              $exists = true;
                            }
                          }
                          if (!$exists && $insabs) {
                            $zero = 0;
                            $empty2 = '';
                            mysqli_stmt_bind_param($insabs, 'iiis', $last_id, $student_id, $empty2, $zero);
                            mysqli_stmt_execute($insabs);
                          }
                        }
                        if ($checkstmt) mysqli_stmt_close($checkstmt);
                        if ($insabs) mysqli_stmt_close($insabs);
                      }
                      mysqli_stmt_close($sstmt);
                    }

                    echo '<div class="alert alert-success">Attendance Successfully Added.</div>';
                  }
                }
                              ?>
                                 <form action="" method="post" > 
                                     <div class="row">
                                                             
                                                                        <div class="form-group col-lg-4" id="data_1">
                              <label class="control-label">Date</label>
                                      <div class="input-group date">
                                          <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="date" required="required" placeholder="Date">
                                                 </div>
                            </div>
                                                <div class="form-group col-lg-4">
                                      <label class="control-label">*Term and Year</label>                                
                                        <select name="term" class="form-control">
                                                                                           <?php
$terms=  mysqli_query($con,"SELECT  * FROM financialterms WHERE status=1");
  while($row=  mysqli_fetch_array($terms)){
  $financialterm_id=$row['financialterm_id'];
$term=$row['term'];
$year=$row['year'];
$startdate=$row['startdate'];
$enddate=$row['enddate'];
$status=$row['status'];
  ?>
                                            <option value="<?php echo $financialterm_id;?>"><?php echo 'Term '.$term.' '.$year;?></option>
  <?php } ?>
                                        </select>                                                                     
                                </div>
                              <div class="form-group col-lg-4">
                                      <label class="control-label">* Time</label>                                
                                        <select name="time" class="form-control">
                                            <option value="" selected="selected">AM or PM ?</option>        
                                            <option value="AM">AM</option>        
                                            <option value="PM">PM</option>        
                                            </select>
                                </div>
          <table  class="display table  table-striped" id="datatable">
        <thead>
        <tr>
            <th>&nbsp;</th>
            <th>Full Names</th>
             <th>Attendance</th>
            <th>Nationality</th>
            <th>Gender</th>                                                
                                                               
                  </tr>
        </thead>
        <tbody>
    
          <?php 
                        $students=  mysqli_query($con,"SELECT * FROM students WHERE status=1 AND class_id='".$_SESSION['class_id']."'");              
                                        while ($row = mysqli_fetch_array($students)) {
                                          $regnumber=$row['regnumber'];
                                          $student_id=$row['student_id'];
                                           $fullname=$row['fullname'];
                                          $gender=$row['gender'];
                                          $class_id=$row['class_id'];                                     
                                            $status=$row['status'];
                                            $nationality=$row['nationality'];
                                            $ext=$row['ext'];											
                                          										
                                                                                       ?>
                 <tr class="gradeA">
                         <td><input type="checkbox" class="hidden" id="attend<?php echo $student_id; ?>"  name="attendance[]" value="<?php echo $student_id; ?>"></td>
                                                             
                                            <td><?php echo $fullname; ?></td>
                                              <td>
                                                <select name="status[]" class="form-control select_all" data-id="<?php echo $student_id; ?>">
                                                    <option selected="selected" value="">Select status</option>
                                                    <option value="1">Present</option>
                                                    <option value="2"> Late</option>
                                                    <option value="0">Absent</option>
                                                </select>
                                                       </td>
                                            <td>
                                                <?php                                                                                      
                                            echo $nationality;
                                            ?></td>
                                                       <td><?php echo $gender; ?></td>
                                                                          							
                                                                                 
                
                                        </tr>
            <?php } ?>
        </tbody>
                        </table>
                                               <button type="submit" class="btn btn-danger" id="hid" name="submit" disabled>Submit</button>
                                 </form>
                          </div>
                              </section>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
    <script src="<?php echo BASE_URL;?>/datapicker/bootstrap-datepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>
<script>
//         var checkboxe = $("#datatable input[type='checkbox']"),
    submitButt= $("#hid");
// checkboxe.click(function() {
//     submitButt.attr("disabled", !checkboxe.is(":checked"));
// });
// function to check if all select box options are selected
function allSelected(selector) {
  let allSelected = true;
  selector.each(function() {
    // console.log(this.value)
    if (this.value == '') {
      // set submit button to disabled if any option is not selected
      submitButt.attr("disabled", true);
      allSelected = false;
    }
  });
  // set submit button to enabled if all options are selected
  if (allSelected) {
    submitButt.attr("disabled", false);
  }
}
// function to check/uncheck checkboxes based on selected dropdown option
function check (val,selector) {
    if (val == '1') {
      selector.attr('checked', true);
    } 
    else if (val == '2'){
      selector.attr('checked', true);
    }
    else {
      selector.attr('checked', false);
    }
}

    $(document).ready(function(){
      // add onchange event to dropdown
      $(".select_all").change(function() {
        console.log(this.value)
        const selector = `#attend${$(this).data('id')}`;
        // check/uncheck checkboxes based on dropdown option
        check(this.value, $(selector));
        allSelected($(".select_all"));
      });
    
            $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });
            });
</script>
</body>
</html>
