<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
include '../includes/conn.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location: discipline');
    exit;
}

$isTeacher = isset($_SESSION['teachersys']);
$level = (int)($_SESSION['schoolsyslevel'] ?? 0);
$isAdminFull = isset($_SESSION['schoolsys']) && $level === 1;
$isPrincipal = isset($_SESSION['schoolsys']) && $level === 2;
$isHeadOfSection = isset($_SESSION['schoolsys']) && $level === 4;
$teacher_id = $isTeacher ? (int)($_SESSION['teachersys'] ?? 0) : 0;

// fetch case
$q = mysqli_query($con, "SELECT * FROM discipline_cases WHERE id='" . $id . "' LIMIT 1");
$case = $q ? mysqli_fetch_assoc($q) : null;
if (!$case) {
    header('Location: discipline');
    exit;
}

$reporter = (int)($case['reporter_id'] ?? 0);
// permission: only full admins (level 1) or the reporting teacher (but not if that teacher is a Head of Section) may edit
// Principals (level 2) and Heads of Section (level 4) have view-only access
if (!$isAdminFull && !($isTeacher && !$isHeadOfSection && $reporter === $teacher_id)) {
    header('Location: login.php');
    exit;
}

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_id = isset($_POST['student_id']) ? (int)$_POST['student_id'] : 0;
    $incident_type = trim((string)($_POST['incident_type'] ?? ''));
    $description = trim((string)($_POST['description'] ?? ''));
    $action_taken = trim((string)($_POST['action_taken'] ?? ''));
    $severity = isset($_POST['severity']) ? (int)$_POST['severity'] : 1;

    if ($student_id <= 0) $errors[] = 'Select a valid student.';
    if ($incident_type === '') $errors[] = 'Enter incident type.';
    if ($description === '') $errors[] = 'Enter a description.';

    if (empty($errors)) {
        $stmt = mysqli_prepare($con, "UPDATE discipline_cases SET student_id=?, incident_type=?, description=?, action_taken=?, severity=? WHERE id=?");
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, 'isssii', $student_id, $incident_type, $description, $action_taken, $severity, $id);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);
            header('Location: discipline');
            exit;
        } else {
            $errors[] = 'Unable to update case.';
        }
    }
}

// students list
$students = [];
$s_q = mysqli_query($con, "SELECT student_id,fullname,regnumber FROM students WHERE status=1 ORDER BY fullname LIMIT 500");
if ($s_q) while ($r = mysqli_fetch_assoc($s_q)) $students[] = $r;

?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit Discipline Case</title>
<link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
<link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
<?php
    // show admin header/sidebar to full admins, principals, and Heads of Section (view-only), otherwise teacher nav
    if (!empty($isAdminFull) || !empty($isPrincipal) || !empty($isHeadOfSection)) {
        include __DIR__ . '/../includes/header.php';
    } else {
        include 'nav.php';
    }
?>
<section class="wrapper">
    <div class="row">
        <div class="col-lg-6">
            <section class="panel">
                <header class="panel-heading">Edit Discipline Case</header>
                <div class="panel-body">
                    <?php if (!empty($errors)) { foreach ($errors as $e) echo '<div class="alert alert-danger">'.htmlspecialchars($e).'</div>'; } ?>
                    <form method="POST" class="form">
                        <div class="form-group">
                            <label>Student</label>
                            <select name="student_id" class="form-control" required>
                                <option value="">Select student</option>
                                <?php foreach ($students as $st): ?>
                                    <option value="<?php echo (int)$st['student_id']; ?>" <?php echo ((int)$st['student_id'] === (int)$case['student_id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($st['fullname'] . ' (' . $st['regnumber'] . ')'); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Incident Type</label>
                            <input type="text" name="incident_type" class="form-control" required value="<?php echo htmlspecialchars($case['incident_type']); ?>">
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="4" required><?php echo htmlspecialchars($case['description']); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label>Action Taken</label>
                            <input type="text" name="action_taken" class="form-control" value="<?php echo htmlspecialchars($case['action_taken']); ?>">
                        </div>
                        <div class="form-group">
                            <label>Severity (1-5)</label>
                            <input type="number" name="severity" class="form-control" min="1" max="5" value="<?php echo (int)$case['severity']; ?>">
                        </div>
                        <div class="form-group">
                            <button class="btn btn-primary" type="submit">Save</button>
                            <a href="discipline" class="btn btn-default">Back</a>
                        </div>
                    </form>
                </div>
            </section>
        </div>
    </div>
</section>
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
</body>
</html>
