<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include '../includes/conn.php';
$isTeacher = isset($_SESSION['teachersys']);
$level = (int)($_SESSION['schoolsyslevel'] ?? 0);
$isAdminFull = isset($_SESSION['schoolsys']) && $level === 1;
$isPrincipal = isset($_SESSION['schoolsys']) && $level === 2;
$isHeadOfSection = isset($_SESSION['schoolsys']) && $level === 4;
$canViewPage = $isTeacher || $isAdminFull || $isPrincipal || $isHeadOfSection;
if (!$canViewPage) {
    header('Location: login.php');
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    echo 'Invalid id';
    exit;
}

$q = mysqli_query($con, "SELECT dc.*, s.fullname, s.regnumber, t.fullname AS reporter_name FROM discipline_cases dc LEFT JOIN students s ON s.student_id = dc.student_id LEFT JOIN teachers t ON t.teacher_id = dc.reporter_id WHERE dc.id='" . $id . "' LIMIT 1");
if (!$q || !($r = mysqli_fetch_assoc($q))) {
    echo 'Case not found';
    exit;
}

?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Discipline Case Details</title>
<link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
<?php
    if (!empty($isAdminFull) || !empty($isPrincipal) || !empty($isHeadOfSection)) {
        include __DIR__ . '/../includes/header.php';
    } else {
        include 'nav.php';
    }
?>
<section class="wrapper">
    <div class="row">
        <div class="col-lg-8">
            <section class="panel">
                <header class="panel-heading">Discipline Case Details</header>
                <div class="panel-body">
                    <h4><?php echo htmlspecialchars($r['fullname'] . (trim((string)($r['regnumber'] ?? '')) !== '' ? ' (' . $r['regnumber'] . ')' : '')); ?></h4>
                    <p><strong>Date:</strong> <?php echo htmlspecialchars($r['date']); ?></p>
                    <p><strong>Reported by:</strong> <?php echo htmlspecialchars($r['reporter_name']); ?></p>
                    <p><strong>Incident Type:</strong> <?php echo htmlspecialchars($r['incident_type']); ?></p>
                    <p><strong>Severity:</strong> <?php echo (int)$r['severity']; ?></p>
                    <p><strong>Description:</strong><br><?php echo nl2br(htmlspecialchars($r['description'])); ?></p>
                    <p><strong>Action Taken:</strong> <?php echo htmlspecialchars($r['action_taken']); ?></p>
                </div>
            </section>
        </div>
    </div>
</section>
</section>
</body>
</html>