<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
include '../includes/conn.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location: discipline');
    exit;
}

$isTeacher = isset($_SESSION['teachersys']);
$level = (int)($_SESSION['schoolsyslevel'] ?? 0);
$isAdminFull = isset($_SESSION['schoolsys']) && $level === 1;
$isPrincipal = isset($_SESSION['schoolsys']) && $level === 2;
$isHeadOfSection = isset($_SESSION['schoolsys']) && $level === 4;
$teacher_id = $isTeacher ? (int)($_SESSION['teachersys'] ?? 0) : 0;

// fetch case to check reporter
$q = mysqli_query($con, "SELECT reporter_id FROM discipline_cases WHERE id='" . $id . "' LIMIT 1");
$row = $q ? mysqli_fetch_assoc($q) : null;
if (!$row) {
    header('Location: discipline');
    exit;
}

$reporter = (int)($row['reporter_id'] ?? 0);

// permission: only full admins (level 1) or the reporting teacher (but not if that teacher is a Head of Section) may delete
// Principals (level 2) and Heads of Section (level 4) have view-only access
if (!$isAdminFull && !($isTeacher && !$isHeadOfSection && $reporter === $teacher_id)) {
    header('Location: login.php');
    exit;
}

// soft delete by setting status=0
$stmt = mysqli_prepare($con, "UPDATE discipline_cases SET status=0 WHERE id = ?");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

header('Location: discipline');
exit;

?>
