<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// Validate GET id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: marks');
  exit;
}

// Fetch mark details to verify it belongs to teacher's subject
$mark_row = null;
$mstmt = mysqli_prepare($con, "SELECT m.mark_id, m.subject_id, m.class_id FROM marks m WHERE m.mark_id = ?");
if ($mstmt) {
  mysqli_stmt_bind_param($mstmt, 'i', $id);
  mysqli_stmt_execute($mstmt);
  $mres = mysqli_stmt_get_result($mstmt);
  if ($mres && mysqli_num_rows($mres) > 0) {
    $mark_row = mysqli_fetch_assoc($mres);
  }
  mysqli_stmt_close($mstmt);
}

if (!$mark_row) {
  $_SESSION['error_msg'] = 'Mark not found.';
  header('Location: marks');
  exit;
}

// Verify teacher has permission to delete this mark (must teach the subject)
$session_teacher_id = (int)($_SESSION['teachersys'] ?? 0);
$can_delete = false;
if ($session_teacher_id > 0) {
  $chk_stmt = mysqli_prepare($con, "SELECT ts.teacher_id FROM teacher_subjects ts JOIN class_subjects cs ON ts.class_sub_id = cs.class_sub_id WHERE ts.teacher_id = ? AND cs.class_id = ? AND cs.subject_id = ? LIMIT 1");
  if ($chk_stmt) {
    mysqli_stmt_bind_param($chk_stmt, 'iii', $session_teacher_id, $mark_row['class_id'], $mark_row['subject_id']);
    mysqli_stmt_execute($chk_stmt);
    $chk_res = mysqli_stmt_get_result($chk_stmt);
    $can_delete = ($chk_res && mysqli_num_rows($chk_res) > 0);
    mysqli_stmt_close($chk_stmt);
  }
}

if (!$can_delete) {
  $_SESSION['error_msg'] = 'You are not authorized to delete this mark.';
  header('Location: marks');
  exit;
}

// Delete the mark (set status to 0 for soft delete)
$del_stmt = mysqli_prepare($con, "UPDATE marks SET status = 0 WHERE mark_id = ?");
if ($del_stmt) {
  mysqli_stmt_bind_param($del_stmt, 'i', $id);
  if (mysqli_stmt_execute($del_stmt)) {
    $_SESSION['success_msg'] = 'Mark successfully deleted.';
  } else {
    $_SESSION['error_msg'] = 'Failed to delete mark.';
  }
  mysqli_stmt_close($del_stmt);
} else {
  $_SESSION['error_msg'] = 'Database error.';
}

header('Location: marks');
exit;
?>
