<?php
include '../includes/conn.php';

// Validate GET parameters
$temp_id = filter_input(INPUT_GET, 'u', FILTER_VALIDATE_INT);
$code = filter_input(INPUT_GET, 't', FILTER_SANITIZE_STRING);
if (!$temp_id || !$code) {
	header('Location:login');
	exit;
}

// Use prepared statement to fetch temp entry
$checkStmt = mysqli_prepare($con, "SELECT user_id FROM temp WHERE temp_id = ? AND code = ? AND user = 'teacher' LIMIT 1");
if ($checkStmt) {
	mysqli_stmt_bind_param($checkStmt, 'is', $temp_id, $code);
	mysqli_stmt_execute($checkStmt);
	$cres = mysqli_stmt_get_result($checkStmt);
	if (!$cres || mysqli_num_rows($cres) < 1) {
		header('Location:login');
		exit;
	}
	$row = mysqli_fetch_assoc($cres);
	$id = (int)($row['user_id'] ?? 0);
	mysqli_stmt_close($checkStmt);
	if (!$id) {
		header('Location:login');
		exit;
	}
} else {
	// If prepare failed, fallback to redirect
	header('Location:login');
	exit;
}
     ?>
<!DOCTYPE html>
<!--[if IE 8]>         <html class="ie8"> <![endif]-->
<!--[if IE 9]>         <html class="ie9 gt-ie8"> <![endif]-->
<!--[if gt IE 9]><!--> <html class="gt-ie8 gt-ie9 not-ie"> <!--<![endif]-->

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<title>Enter Code -School System</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">

	<!-- Open Sans font from Google CDN -->
	<link href="http://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,400,600,700,300&amp;subset=latin" rel="stylesheet" type="text/css">

	<!-- Pixel Admin's stylesheets -->
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/pixel-admin.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/pages.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/rtl.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo BASE_URL; ?>/assets/stylesheets/themes.min.css" rel="stylesheet" type="text/css">
	<style>
		#signin-demo {
			position: fixed;
			right: 0;
			bottom: 0;
			z-index: 10000;
			background: rgba(0,0,0,.6);
			padding: 6px;
			border-radius: 3px;
		}
		#signin-demo img { cursor: pointer; height: 40px; }
		#signin-demo img:hover { opacity: .5; }
		#signin-demo div {
			color: #fff;
			font-size: 10px;
			font-weight: 600;
			padding-bottom: 6px;
		}
	</style>
<!-- / $DEMO -->

</head>

<body class="theme-default page-signin">


	<!-- Page background -->
	<div id="page-signin-bg">
		<!-- Background overlay -->
		<div class="overlay"></div>
		<!-- Replace this with your bg image -->
              <img src="<?php echo BASE_URL;?>/assets/demo/bimsbg.jpg" alt="">
	</div>
	<!-- / Page background -->

	<!-- Container -->
	<div class="signin-container">

		<!-- Left side -->
		

		<!-- Right side -->
		<div class="signin-form">
                <?php
				if(isset($_POST['password'],$_POST['repeat'])){
					$password = trim((string)($_POST['password'] ?? ''));
					$repeat = trim((string)($_POST['repeat'] ?? ''));
					$errors = [];
					if ($password === '' || $repeat === '') {
						$errors[] = 'Both Fields should not be empty';
					}
					if ($password !== $repeat) {
						$errors[] = 'The passwords do not match';
					}
					if (strlen($password) < 6) {
						$errors[] = 'Password should be at least 6 characters';
					}
					if (!empty($errors)) {
						foreach ($errors as $error) {
							echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
						}
					} else {
						$hash = password_hash($password, PASSWORD_DEFAULT);
						$updStmt = mysqli_prepare($con, "UPDATE teachers SET password = ? WHERE teacher_id = ?");
						if ($updStmt) {
							mysqli_stmt_bind_param($updStmt, 'si', $hash, $id);
							$ok = mysqli_stmt_execute($updStmt);
							if ($ok) {
								echo '<div class="alert alert-success">' . htmlspecialchars('New Password Successfully set. Click ', ENT_QUOTES) . '<a href="login">Here</a>' . htmlspecialchars(' to Login', ENT_QUOTES) . '</div>';
							} else {
								echo '<div class="alert alert-danger">' . htmlspecialchars('Database error: ' . mysqli_stmt_error($updStmt), ENT_QUOTES) . '</div>';
							}
							mysqli_stmt_close($updStmt);
						} else {
							echo '<div class="alert alert-danger">' . htmlspecialchars('Database error: could not prepare statement', ENT_QUOTES) . '</div>';
						}
					}
				}
                
                ?>
                 
            <form action="" method="POST" class="margin-bottom-0" name="form">
                    <div class="form-group m-b-20">
                        <input type="password" class="form-control input-lg" placeholder="password"  name="password" required="required"/>
                           <div id='form_password_errorloc' class='text-danger'></div>
                    </div>
                    <div class="form-group m-b-20">
                        <input type="password" class="form-control input-lg" placeholder="Re-enter password" name="repeat" required="required"/>
                           <div id='form_repeat_errorloc' class='text-danger'></div>
                    </div>
                    
                  <div class="form-actions">
                      <input type="submit" value="Set Password" class="signin-btn bg-primary">
                    </div>
                    
                </form>
    
		</div>
		<!-- Right side -->
	</div>
	<!-- / Container -->
<div class="not-a-member">
    <a href="login">Back to Login</a>
	</div>
	<!-- Get jQuery from Google CDN -->
<!--[if !IE]> -->
	<script type="text/javascript"> window.jQuery || document.write('<script src="js/jquery-1.10.2.min.js">'+"<"+"/script>"); </script>

<!-- Pixel Admin's javascripts -->
<script src="<?php echo BASE_URL; ?>/assets/javascripts/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/assets/javascripts/pixel-admin.min.js"></script>
 <script  src="<?php echo BASE_URL; ?>/js/gen_validatorv4.js" type="text/javascript"></script>
<script type="text/javascript">
	window.PixelAdmin.start(init);
        </script>
        <script type="text/javascript">
        var frmvalidator  = new Validator("form");
 frmvalidator.EnableOnPageErrorDisplay();
 frmvalidator.EnableMsgsTogether();
  frmvalidator.addValidation("password","minlength=6","*password  should atleast be 6 characters");
 frmvalidator.addValidation("repeat","eqelmnt=password", "*The passwords dont match");
</script>
</body>

</html>