<?php
include '../includes/conn.php';
 if(!isset($_SESSION['teachersys'])){
header('Location:login.php');
  exit;
   }
  $session_teacher = filter_var($_SESSION['teachersys'] ?? 0, FILTER_VALIDATE_INT);
  if (!$session_teacher) {
    header('Location:login.php');
    exit;
  }
// helper: normalize timestamps or Y-m-d strings for safe display
function normalize_date_for_display($value)
{
  if (empty($value) && $value !== '0') {
    return '';
  }
  if (is_numeric($value) && (int)$value > 0) {
    return date('d/M/Y', (int)$value);
  }
  $dt = DateTime::createFromFormat('Y-m-d', $value);
  if ($dt && $dt->getTimestamp() > 0) {
    return $dt->format('d/M/Y');
  }
  $ts = strtotime($value);
  if ($ts && $ts > 0) {
    return date('d/M/Y', $ts);
  }
  return '';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
 <link rel="shortcut icon" href="#" type="image/png">

  <title>Borrowed  Books</title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                      <section class="panel">
                    <header class="panel-heading">
                   Borrowed Books
                    </header>
                          <div class="panel-body">
                                           
            <?php
        $stmt = mysqli_prepare($con, "SELECT issue_id, book_id, date, duedate, returndate, serial, status FROM issuedbooks WHERE (status=0 OR status=1) AND student_id = ? AND borrower = 'teacher'");
        if ($stmt) {
          mysqli_stmt_bind_param($stmt, 'i', $session_teacher);
          mysqli_stmt_execute($stmt);
          $issuedbooks = mysqli_stmt_get_result($stmt);
        } else {
          $issuedbooks = false;
        }

                              if($issuedbooks && mysqli_num_rows($issuedbooks)>0){

 ?>
                   <table  class="display table  table-striped" id="dynamic-table">
                   <thead>
                                        <tr>
                                              <th>Book Title</th>
                                            <th>Author</th>
                                            <th>Serial No</th>
                                                 <th>Issue Date</th>
                                                 <th>Return Date</th>
                                                 <th>Status</th>
                                                <?php 
                                   
                                                                          $bookStmt = mysqli_prepare($con, "SELECT book_title, author FROM books WHERE book_id = ? LIMIT 1");
                                                                          while ($row = mysqli_fetch_assoc($issuedbooks)) {
                                                                            $issue_id = (int)($row['issue_id'] ?? 0);
                                                                             $book_id = (int)($row['book_id'] ?? 0);
                                                                                 $date = (int)($row['date'] ?? 0);
                                                                            $duedate = (int)($row['duedate'] ?? 0);
                                                                            $returndate = (int)($row['returndate'] ?? 0);
                                                                            $serial = $row['serial'] ?? '';
                                                                            $status = (int)($row['status'] ?? 0);
                                                                            $bookname = '';
                                                                            $author = '';
                                                                            if ($bookStmt && $book_id) {
                                                                              mysqli_stmt_bind_param($bookStmt, 'i', $book_id);
                                                                              mysqli_stmt_execute($bookStmt);
                                                                              $bres = mysqli_stmt_get_result($bookStmt);
                                                                              if ($bres && $brow = mysqli_fetch_assoc($bres)) {
                                                                                $bookname = $brow['book_title'] ?? '';
                                                                                $author = $brow['author'] ?? '';
                                                                              }
                                                                            }
                                                                              
                                                                                       ?>
               
                     <tr class="gradeA">
                                                              
                      <td><?php echo htmlspecialchars($bookname, ENT_QUOTES); ?></td>
                      <td><?php echo htmlspecialchars($author, ENT_QUOTES); ?></td>
                                          <td><?php echo htmlspecialchars($serial, ENT_QUOTES); ?></td>
                                          <td><?php echo htmlspecialchars(normalize_date_for_display($date), ENT_QUOTES); ?></td>
                                          <td><?php
                                          if($status==0){
                                          echo htmlspecialchars(normalize_date_for_display($duedate), ENT_QUOTES); 
                                          }else{
                                          echo htmlspecialchars(normalize_date_for_display($returndate), ENT_QUOTES); 
                                          }
                                          ?></td>
                                                                                  																																		
                                          <td>   
                                          <?php 
                                          if($status==1){
                                             echo '<label class="text-success"> Returned</label>';
                                          }else{
                                            echo '<label class="text-danger">Not Returned</label>';
                                          }
                                          ?>
                                          </td>
                                        </tr>
                                          <?php }
                                          if (isset($bookStmt) && $bookStmt) mysqli_stmt_close($bookStmt);
                                          if (isset($stmt) && $stmt) mysqli_stmt_close($stmt);
                                          ?>
                   </table>
                                        <?php } else{ ?>
                    
                        <div class="alert alert-danger"><?php echo htmlspecialchars('Oops!! No Library Record Yet', ENT_QUOTES); ?></div>
 <?php }?>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>
</html>
