<?php
include '../includes/conn.php';
 if(!isset($_SESSION['teachersys'])){
header('Location:login.php');
  exit;
   }

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location:attendance.php');
  exit;
}

// Load attendance record via prepared statement
$attendance = null;
$attendanceStmt = mysqli_prepare($con, "SELECT attendance_id, date, time FROM attendance WHERE status=1 AND attendance_id = ? LIMIT 1");
if ($attendanceStmt) {
  mysqli_stmt_bind_param($attendanceStmt, 'i', $id);
  mysqli_stmt_execute($attendanceStmt);
  $res = mysqli_stmt_get_result($attendanceStmt);
  if ($res && $row1 = mysqli_fetch_assoc($res)) {
    $date = $row1['date'] ?? '';  // date is now stored as DATE (Y-m-d)
    $time = $row1['time'] ?? '';
    $attendance_id = (int)($row1['attendance_id'] ?? 0);
  } else {
    // not found
    header('Location:attendance.php');
    exit;
  }
  mysqli_stmt_close($attendanceStmt);
} else {
  // fallback: redirect
  header('Location:attendance.php');
  exit;
}

// Helper function to format date from Y-m-d to d/M/Y
$date_formatted = '';
if ($date) {
  $date_obj = DateTime::createFromFormat('Y-m-d', $date);
  $date_formatted = $date_obj ? $date_obj->format('d/M/Y') : $date;
}
              ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Attendance for  <?php echo htmlspecialchars($date_formatted); ?></title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->
        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        Attendance Details for <?php echo htmlspecialchars($date_formatted) . ' ' . htmlspecialchars($time);?>
                        <span class="tools pull-right">
                            <a href="printattendancedetails.php?id=<?php echo $id; ?>" class="btn btn-info btn-sm"><i class="fa fa-print"></i> Print</a>
                        </span>
                    </header>
                </section>
            </div>
        </div>

        <div class="row">
           <div class="col-lg-4">
                      <section class="panel">
                    <header class="panel-heading">
             Attendees  for   <?php echo htmlspecialchars($date_formatted) . ' ' . htmlspecialchars($time);?> 
                    </header>
                          <div class="panel-body">
                              <table  class="display table  table-striped">
        <thead>
        <tr>
             <th>Fullname</th>
             <th>Gender</th>
                                 
                  </tr>
        </thead>
        <tbody>
    
          <?php 
                  $attDetStmt = mysqli_prepare($con, "SELECT student_id FROM attendancedetails WHERE attendance_id = ? AND status = 1");
                  if ($attDetStmt) {
                    mysqli_stmt_bind_param($attDetStmt, 'i', $attendance_id);
                    mysqli_stmt_execute($attDetStmt);
                    $attendees = mysqli_stmt_get_result($attDetStmt);
                    while ($row1 = mysqli_fetch_assoc($attendees)) {
                      $student_id = (int)($row1['student_id'] ?? 0);
                      $studentStmt = mysqli_prepare($con, "SELECT regnumber, student_id, fullname, gender FROM students WHERE student_id = ? LIMIT 1");
                      $fullname = '';
                      $gender = '';
                if ($studentStmt && $student_id) { 
                        mysqli_stmt_bind_param($studentStmt, 'i', $student_id);
                        mysqli_stmt_execute($studentStmt);
                        $sres = mysqli_stmt_get_result($studentStmt);
                        if ($sres && $srow = mysqli_fetch_assoc($sres)) {
                          $regnumber = $srow['regnumber'] ?? '';
                          $student_id = (int)($srow['student_id'] ?? 0);
                          $fullname = $srow['fullname'] ?? '';
                          $gender = $srow['gender'] ?? '';
                        }
                        mysqli_stmt_close($studentStmt);
                      }
                                                                                       ?>
     <tr class="gradeA"> 
                     <td> 
                     <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                   </td> 
                                          
             <td> 
            <?php 
               echo htmlspecialchars($gender, ENT_QUOTES);
              ?></td>
                                         
                                           <td>
                                                <?php 
                                             echo $gender;
                                            ?></td>
                                                                            
                                       
                                        </tr>
            <?php } 
                    mysqli_stmt_close($attDetStmt);
                  } ?>
        </tbody>
                        </table>
                          </div>
                          </section>
                          </div>
    <div class="col-lg-4">
    <section class="panel">
                    <header class="panel-heading">
             Late  for   <?php echo htmlspecialchars($date_formatted) . ' ' . htmlspecialchars($time);?> 
                    </header>
                          <div class="panel-body">
            <table  class="display table  table-striped">
                      <thead>
                      <tr>
                          <th>Fullname</th>
                          <th>Gender</th>
                          <th>&nbsp;</th>
                                              
                                </tr>
                      </thead>
                      <tbody>
    
                        <?php 
                                $attendees_L_stmt = mysqli_prepare($con, "SELECT student_id, details FROM attendancedetails WHERE attendance_id = ? AND status = 2");
                                if ($attendees_L_stmt) {
                                  mysqli_stmt_bind_param($attendees_L_stmt, 'i', $attendance_id);
                                  mysqli_stmt_execute($attendees_L_stmt);
                                  $attendees_L = mysqli_stmt_get_result($attendees_L_stmt);
                                  while ($row1 = mysqli_fetch_assoc($attendees_L)) {
                                                        $student_id = (int)($row1['student_id'] ?? 0);
                                                        $details = $row1['details'] ?? '';
                                                        $studentStmt = mysqli_prepare($con, "SELECT regnumber, student_id, fullname, gender FROM students WHERE student_id = ? LIMIT 1");
                                                        $fullname = '';
                                                        $gender = '';
                                                         if ($studentStmt && $student_id) { 
                                                          mysqli_stmt_bind_param($studentStmt, 'i', $student_id);
                                                          mysqli_stmt_execute($studentStmt);
                                                          $sres = mysqli_stmt_get_result($studentStmt);
                                                          if ($sres && $srow = mysqli_fetch_assoc($sres)) {
                                                            $regnumber = $srow['regnumber'] ?? '';
                                                            $student_id = (int)($srow['student_id'] ?? 0);
                                                            $fullname = $srow['fullname'] ?? '';
                                                            $gender = $srow['gender'] ?? '';
                                                          }
                                                          mysqli_stmt_close($studentStmt);
                                                        }
                                                                                                    ?>
                                <tr class="gradeA"> 
                                                                              <td> 
                                                                              <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                                                                      </td>                                         
                                                          <td> 
                                                                <?php 
                                                            echo htmlspecialchars($gender, ENT_QUOTES);
                                                            ?></td>
                                            <td> 
                                                                <?php 
                                                            echo htmlspecialchars($details, ENT_QUOTES);
                                                            ?></td>                                                
                                                    
                                                        </tr>
                            <?php }
                                    mysqli_stmt_close($attendees_L_stmt);
                                  } ?>
                      </tbody>
              </table>   
                          </div>
                          </section>
                          </div>
    <div class="col-lg-4">
    <section class="panel">
                    <header class="panel-heading">
             Absentees  for   <?php echo htmlspecialchars($date_formatted) . ' ' . htmlspecialchars($time);?> 
                    </header>
                          <div class="panel-body">
                              <table  class="display table  table-striped">
        <thead>
        <tr>
             <th>Fullname</th>
             <th>Gender</th>
             <th>&nbsp;</th>
                                 
                  </tr>
        </thead>
        <tbody>
    
          <?php 
                  $attendees=  mysqli_query($con,"SELECT * FROM attendancedetails WHERE attendance_id='$id' AND status=0") or die(mysqli_error($con));        
                                        while ($row1 = mysqli_fetch_array($attendees)) {                                       															
                                          $student_id=$row1['student_id'];	
                                          $details=$row1['details'];	
                                          $students=  mysqli_query($con,"SELECT * FROM students WHERE  student_id='$student_id'");              
                                        $row = mysqli_fetch_array($students);
                                          $regnumber=$row['regnumber'];
                                          $student_id=$row['student_id'];
                                           $fullname=$row['fullname'];
                                          $gender=$row['gender'];
                                      
                                                                                       ?>
                 <tr class="gradeA">
                                                               <td>
                                                               <?php echo $fullname; ?>
                                                       </td>                                         
                                           <td>
                                                <?php 
                                             echo $gender;
                                            ?></td>
                             <td>
                                                <?php 
                                             echo $details;
                                            ?></td>                                                
                                       
                                        </tr>
            <?php } ?>
        </tbody>
                        </table>
                          </div>
                          </section>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL;?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>

</body>
</html>
