<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if(!isset($_SESSION['teachersys'])){
  header('Location:login.php');
  exit;
}

// Validate input and session values
$term_id = filter_input(INPUT_GET, 'term', FILTER_VALIDATE_INT);
if (!$term_id) {
  header('Location:dashboard.php');
  exit;
}

// Get teacher ID to show all their attendance records
$teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;

// Load term info
$term = '';
$year = '';
$termStmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
if ($termStmt) {
  mysqli_stmt_bind_param($termStmt, 'i', $term_id);
  mysqli_stmt_execute($termStmt);
  $tres = mysqli_stmt_get_result($termStmt);
  if ($tres && $trow = mysqli_fetch_assoc($tres)) {
    $term = $trow['term'] ?? '';
    $year = $trow['year'] ?? '';
  }
  mysqli_stmt_close($termStmt);
}

// Show "All Classes" since teacher can add attendance for multiple classes
$class = 'All Your Classes';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Attendance for  <?php echo $class.' Term '.$term.' '.$year;?></title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                   Attendance for  <?php echo $class.' Term '.$term.' '.$year;?>
                   <a href="printattendance.php?term=<?php echo $term_id; ?>" class="btn btn-info btn-sm pull-right" target="_blank"><i class="fa fa-print"></i> Print</a>
                    </header>
                          <div class="panel-body">
                              <table  class="display table  table-striped" id="dynamic-table-2">
        <thead>
        <tr>
             <th>Date</th>
             <th>Class</th>
             <th>Time</th>
             <th>Attendees</th>
             <th>Late</th>
                <th>Absentees</th>                                                
                <th>Action</th>        
                  </tr>
        </thead>
        <tbody>
    
          <?php 
                          // Show all attendance records created by this teacher for the selected term
                          $attStmt = mysqli_prepare($con, "SELECT a.attendance_id, a.date, a.time, a.class_id, c.class FROM attendance a LEFT JOIN classes c ON a.class_id = c.class_id WHERE a.status=1 AND a.term_id=? AND a.teacher_id=? ORDER BY a.date DESC, a.time DESC");
                          if ($attStmt) {
                            mysqli_stmt_bind_param($attStmt, 'ii', $term_id, $teacher_id);
                            mysqli_stmt_execute($attStmt);
                            $attendance = mysqli_stmt_get_result($attStmt);
                            while ($row1 = mysqli_fetch_assoc($attendance)) {
                              $date = $row1['date'] ?? '';  // date is now stored as DATE (Y-m-d)
                              $time = $row1['time'] ?? '';
                              $attendance_id = (int)($row1['attendance_id'] ?? 0);
                              $class_name = $row1['class'] ?? 'Unknown';
                              // Format date for display
                              $date_formatted = '';
                              if ($date) {
                                $date_obj = DateTime::createFromFormat('Y-m-d', $date);
                                $date_formatted = $date_obj ? $date_obj->format('d/M/Y') : $date;
                              }
                                                                                         ?>
                 <tr class="gradeA">
                                                               <td>
                                                               <?php echo htmlspecialchars($date_formatted); ?>
                                                       </td>
                                                       <td><?php echo htmlspecialchars($class_name); ?></td>
                                                       <td><?php echo $time; ?></td>
                                            <td>
                                                <?php 
                                            $countStmt = mysqli_prepare($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE attendance_id = ? AND status = ?");
                                            $cnt = 0;
                                            if ($countStmt) {
                                              $s = 1; // attendees
                                              mysqli_stmt_bind_param($countStmt, 'ii', $attendance_id, $s);
                                              mysqli_stmt_execute($countStmt);
                                              $cres = mysqli_stmt_get_result($countStmt);
                                              if ($cres && $crow = mysqli_fetch_assoc($cres)) $cnt = (int)$crow['cnt'];
                                              echo htmlspecialchars((string)$cnt, ENT_QUOTES);
                                            }
                                            ?></td>
                                            <td>
                                                <?php
                                            $cntLate = 0;
                                            if ($countStmt) {
                                              $s = 2; // late
                                              mysqli_stmt_bind_param($countStmt, 'ii', $attendance_id, $s);
                                              mysqli_stmt_execute($countStmt);
                                              $cres = mysqli_stmt_get_result($countStmt);
                                              if ($cres && $crow = mysqli_fetch_assoc($cres)) $cntLate = (int)$crow['cnt'];
                                              echo htmlspecialchars((string)$cntLate, ENT_QUOTES);
                                            }
                                            ?></td>
                                           <td>
                                                <?php 
                                            $cntAbs = 0;
                                            if ($countStmt) {
                                              $s = 0; // absent
                                              mysqli_stmt_bind_param($countStmt, 'ii', $attendance_id, $s);
                                              mysqli_stmt_execute($countStmt);
                                              $cres = mysqli_stmt_get_result($countStmt);
                                              if ($cres && $crow = mysqli_fetch_assoc($cres)) $cntAbs = (int)$crow['cnt'];
                                              echo htmlspecialchars((string)$cntAbs, ENT_QUOTES);
                                            }
                                            if (isset($countStmt) && $countStmt) mysqli_stmt_close($countStmt);
                                            ?></td>
                                                                            
                                           <td><a href="attendancedetails?id=<?php echo $attendance_id; ?>" class="btn btn-xs btn-info">Details</a>
                                           <!-- <a href="editattendancedetails?id=<?php echo $attendance_id; ?>" class="btn btn-xs btn-primary">Edit</a> -->
                                             <a href="removeattendance?id=<?php echo $attendance_id; ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $attendance_id;?>()">Remove</a>
                                           </td>
                                                 <script type="text/javascript">
function confirm_delete<?php echo $attendance_id; ?>() {
  return confirm('You are about To Remove this item. Are you sure you want to proceed?');
}
</script>             
                                        </tr>
      <?php 
        }
      }
        if (isset($attStmt) && $attStmt) mysqli_stmt_close($attStmt);
      ?>
        </tbody>
                        </table>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL;?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>
<script>
    $(document).ready(function(){
        $('#dynamic-table-2').dataTable(
            {
                "aaSorting": [[ 0, "desc" ]]
            }
        );
    })
  </script>
</body>
</html>
