<?php
include '../includes/conn.php';
 if(!isset($_SESSION['teachersys'])){
header('Location:login.php');
    exit;
     }
    $session_teacher = filter_var($_SESSION['teachersys'] ?? 0, FILTER_VALIDATE_INT);
    if (!$session_teacher) {
        header('Location:login.php');
        exit;
    }
   ?>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Notifications | School Manager</title>

    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Data Tables -->
    <link href="<?php echo BASE_URL; ?>/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

        
        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
         
        </div>
            <ul class="nav navbar-top-links navbar-right">
             
              
                                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">                
                <div class="col-lg-10">
                    <h2>Notifications</h2>
                    <ol class="breadcrumb">
                         <li> <a href=""><i class="fa fa-home"></i> Home</a></li>
                                  
                        <li class="active">
                            <strong>View Notifications</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content animated fadeInRight">
            <div class="row">
               
                <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>All Notifications <small>Sort, search</small></h5>
                                  </div>
                    <div class="ibox-content">
                             <?php
                  // Fetch notifications for this teacher using a prepared statement
                  $notifStmt = mysqli_prepare($con, "SELECT * FROM notifications WHERE sendertype='Teachers' AND sender = ? ORDER BY timestamp DESC");
                  mysqli_stmt_bind_param($notifStmt, 'i', $session_teacher);
                  mysqli_stmt_execute($notifStmt);
                  $getnotification = mysqli_stmt_get_result($notifStmt);
                  if ($getnotification && mysqli_num_rows($getnotification) > 0) {
                         
 ?>
                    <table class="table table-striped table-bordered table-hover dataTables-example" >
                   <thead>
                                    <tr>
                                                            <?php    
                                                                while ($row = mysqli_fetch_assoc($getnotification)) {
                                                                    $notification_id = (int)($row['notification_id'] ?? 0);
                                                                    $sender = (int)($row['sender'] ?? 0);
                                                                    $reciever = $row['reciever'] ?? null;
                                                                    $sendertype = $row['sendertype'] ?? '';
                                                                    $messagetype = $row['messagetype'] ?? '';
                                                                    $notification = strip_tags($row['notification'] ?? '');
                                                                    $timestamp = (int)($row['timestamp'] ?? 0);

                                                                    // Fetch sender info once (sender is the session teacher for this view)
                                                                    $fullname = '';
                                                                    $designation = '';
                                                                    $teacherStmt = mysqli_prepare($con, "SELECT fullname, designation FROM teachers WHERE teacher_id = ? LIMIT 1");
                                                                    if ($teacherStmt) {
                                                                        mysqli_stmt_bind_param($teacherStmt, 'i', $sender);
                                                                        mysqli_stmt_execute($teacherStmt);
                                                                        $rs = mysqli_stmt_get_result($teacherStmt);
                                                                        if ($rs && $rw = mysqli_fetch_assoc($rs)) {
                                                                            $fullname = $rw['fullname'] ?? '';
                                                                            $designation = $rw['designation'] ?? '';
                                                                        }
                                                                        mysqli_stmt_close($teacherStmt);
                                                                    }

                                                                    // Resolve recipient label
                                                                    $to = '';
                                                                    if ($messagetype === 'all') {
                                                                        $to = 'All Parents';
                                                                    } elseif ($messagetype === 'class') {
                                                                        $rId = filter_var($reciever, FILTER_VALIDATE_INT);
                                                                        if ($rId) {
                                                                            $stmtc = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
                                                                            mysqli_stmt_bind_param($stmtc, 'i', $rId);
                                                                            mysqli_stmt_execute($stmtc);
                                                                            $rc = mysqli_stmt_get_result($stmtc);
                                                                            if ($rc && $rcr = mysqli_fetch_assoc($rc)) $to = $rcr['class'] ?? '';
                                                                            if ($stmtc) mysqli_stmt_close($stmtc);
                                                                        }
                                                                    } elseif ($messagetype === 'single') {
                                                                        $rId = filter_var($reciever, FILTER_VALIDATE_INT);
                                                                        if ($rId) {
                                                                            $stmtp = mysqli_prepare($con, "SELECT parent_name FROM parents WHERE parent_id = ? LIMIT 1");
                                                                            mysqli_stmt_bind_param($stmtp, 'i', $rId);
                                                                            mysqli_stmt_execute($stmtp);
                                                                            $rp = mysqli_stmt_get_result($stmtp);
                                                                            if ($rp && $rpr = mysqli_fetch_assoc($rp)) $to = $rpr['parent_name'] ?? '';
                                                                            if ($stmtp) mysqli_stmt_close($stmtp);
                                                                        }
                                                                    } elseif ($messagetype === 'section') {
                                                                        $rId = filter_var($reciever, FILTER_VALIDATE_INT);
                                                                        if ($rId) {
                                                                            $stmtcc = mysqli_prepare($con, "SELECT classcategory FROM classcategories WHERE classcategory_id = ? LIMIT 1");
                                                                            mysqli_stmt_bind_param($stmtcc, 'i', $rId);
                                                                            mysqli_stmt_execute($stmtcc);
                                                                            $rcc = mysqli_stmt_get_result($stmtcc);
                                                                            if ($rcc && $rccr = mysqli_fetch_assoc($rcc)) $to = $rccr['classcategory'] ?? '';
                                                                            if ($stmtcc) mysqli_stmt_close($stmtcc);
                                                                        }
                                                                    }
                                                                                                                    																					?>
                                                $to=$row['parent_name'];
                                                                                            }
                                                                                                if($messagetype=='section'){
                                                $getreciever= mysqli_query($con,"SELECT * FROM classcategories WHERE classcategory_id='$reciever'");
                                                $row=  mysqli_fetch_array($getreciever);
                                                $to=$row['classcategory'];
                                                                                            }
                                          										
                                                                                       ?>
               
                       <tr class="gradeA">
                                   <td>
                                   <?php echo htmlspecialchars(date('d/M/Y', (int)$timestamp), ENT_QUOTES);?>
                               </td>
                                                                                     
                                             <td><?php echo htmlspecialchars($fullname . ', ' . $designation, ENT_QUOTES); ?></td>
                        <td><?php echo htmlspecialchars(mb_substr($notification, 0, 100) . '...', ENT_QUOTES); ?></td>    
                        <td><?php echo htmlspecialchars($to, ENT_QUOTES); ?></td>
											
                                                                     
                                                                                        </td>
                                                                                                  
											
                          <td><a href="announcement?id=<?php echo $notification_id; ?>" class="btn btn-success btn-xs">Details</a>
                           <a href="editannouncement?id=<?php echo $notification_id; ?>" class="btn btn-primary btn-xs"><i class="fa fa-edit"></i> Edit</a>
                               <a href="removeannouncement?id=<?php echo $notification_id; ?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $notification_id;?>()"><i class="fa fa-times"></i> Remove</a>
                                                          <script type="text/javascript">
function confirm_delete<?php echo $notification_id; ?>() {
  return confirm('You are about To Remove this Item.Are you sure you want to proceed?');
}
</script>              
                                                                                        </td>
                                        </tr>
                    </tr>
                <?php  }?>       
                    </tbody>
                                    </table>
 <?php }?>
                    </div>
                </div>
            </div>
            </div>
          
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <script src="<?php echo BASE_URL; ?>/js/plugins/jeditable/jquery.jeditable.js"></script>

    <!-- Data Tables -->
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/dataTables.bootstrap.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() {
            $('.dataTables-example').dataTable();

            /* Init DataTables */
            var oTable = $('#editable').dataTable();

            /* Apply the jEditable handlers to the table */
            oTable.$('td').editable( 'http://webapplayers.com/example_ajax.php', {
                "callback": function( sValue, y ) {
                    var aPos = oTable.fnGetPosition( this );
                    oTable.fnUpdate( sValue, aPos[0], aPos[1] );
                },
                "submitdata": function ( value, settings ) {
                    return {
                        "row_id": this.parentNode.getAttribute('id'),
                        "column": oTable.fnGetPosition( this )[2]
                    };
                },

                "width": "90%"
            } );


        });

        function fnClickAddRow() {
            $('#editable').dataTable().fnAddData( [
                "Custom row",
                "New row",
                "New row",
                "New row",
                "New row" ] );

        }
    </script>
</body>

</html>