<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');
if (!isset($_SESSION['teachersys'])) {
  echo json_encode(['success' => false, 'error' => 'Not authenticated']);
  exit;
}
$id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
$mark = isset($_POST['mark']) ? trim($_POST['mark']) : '';
if (!$id) {
  echo json_encode(['success' => false, 'error' => 'Invalid id']);
  exit;
}
if ($mark === '' || !is_numeric($mark)) {
  echo json_encode(['success' => false, 'error' => 'Mark must be numeric']);
  exit;
}
$markVal = (int)$mark;
// get rank limit if available
$gstmt = mysqli_prepare($con, "SELECT rank FROM marks WHERE mark_id = ? LIMIT 1");
if ($gstmt) {
  mysqli_stmt_bind_param($gstmt, 'i', $id);
  mysqli_stmt_execute($gstmt);
  $gres = mysqli_stmt_get_result($gstmt);
  if ($gres && mysqli_num_rows($gres) > 0) {
    $grow = mysqli_fetch_assoc($gres);
    $rank = isset($grow['rank']) ? (int)$grow['rank'] : null;
  } else {
    $rank = null;
  }
  mysqli_stmt_close($gstmt);
} else {
  $rank = null;
}
if ($rank !== null && is_numeric($rank) && $markVal > (int)$rank) {
  echo json_encode(['success' => false, 'error' => 'Mark is greater than allowed maximum (' . htmlspecialchars($rank, ENT_QUOTES) . ')']);
  exit;
}
$ust = mysqli_prepare($con, "UPDATE marks SET marks = ? WHERE mark_id = ?");
if (!$ust) {
  echo json_encode(['success' => false, 'error' => 'Update prepare failed']);
  exit;
}
mysqli_stmt_bind_param($ust, 'ii', $markVal, $id);
mysqli_stmt_execute($ust);
mysqli_stmt_close($ust);
echo json_encode(['success' => true, 'message' => 'Mark updated']);
