<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');
if (!isset($_SESSION['teachersys'])) {
  echo json_encode(['success' => false, 'error' => 'Not authenticated']);
  exit;
}
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  echo json_encode(['success' => false, 'error' => 'Invalid id']);
  exit;
}
$stmt = mysqli_prepare($con, "SELECT m.mark_id, m.marks, m.rank, m.date, s.fullname FROM marks m LEFT JOIN students s ON m.student_id = s.student_id WHERE m.mark_id = ? LIMIT 1");
if (!$stmt) {
  echo json_encode(['success' => false, 'error' => 'Query prepare failed']);
  exit;
}
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$out = ['success' => false];
if ($res && mysqli_num_rows($res) > 0) {
  $row = mysqli_fetch_assoc($res);
  $date = $row['date'];
  $date_formatted = '';
  if (!empty($date)) {
    $d = DateTime::createFromFormat('Y-m-d', $date);
    if ($d && $d->format('Y-m-d') === $date) $date_formatted = $d->format('d/M/Y'); else { $ts = strtotime($date); $date_formatted = $ts !== false ? date('d/M/Y', $ts) : $date; }
  }
  $out = [
    'success' => true,
    'data' => [
      'mark_id' => (int)$row['mark_id'],
      'marks' => $row['marks'],
      'rank' => isset($row['rank']) ? $row['rank'] : null,
      'date' => $date,
      'date_formatted' => $date_formatted,
      'student_name' => $row['fullname'] ?? ''
    ]
  ];
}
mysqli_stmt_close($stmt);
echo json_encode($out);
