<?php
// ensure session is started
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location:login.php');
  exit;
}
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location:timetable.php');
  exit;
}

// Try to prefill 'periods per week' from the most recent weekly plan for this class
$periodsperweek_default = '';
if (isset($con) && $id) {
  $stmt = mysqli_prepare($con, "SELECT periodsperweek FROM weeklyplans WHERE class_sub_id = ? AND status = 1 ORDER BY weekly_plan_id DESC LIMIT 1");
  if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    if ($res && ($row = mysqli_fetch_assoc($res))) {
      $periodsperweek_default = $row['periodsperweek'] ?? '';
    }
    mysqli_stmt_close($stmt);
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Weekly Plan</title>
  <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>  
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->

</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-11">
          <?php
          if (isset($_POST['submit'])) {
            // Validate dates and inputs
            // Use the raw YYYY-MM-DD values from the date inputs to avoid strtotime/timezone mismatches
            $start_input = trim((string)($_POST['startdate'] ?? ''));
            $end_input = trim((string)($_POST['enddate'] ?? ''));
            $start_valid = preg_match('/^\d{4}-\d{2}-\d{2}$/', $start_input);
            $end_valid = preg_match('/^\d{4}-\d{2}-\d{2}$/', $end_input);

            $term = filter_input(INPUT_POST, 'term', FILTER_VALIDATE_INT);
            $learning_objectives = $_POST['learning_objectives'] ?? '';
            $resources = $_POST['resources'] ?? '';
            $teaching_summary = $_POST['teaching_summary'] ?? '';
            $main_activity = $_POST['main_activity'] ?? '';
            $plenary = $_POST['plenary'] ?? '';
            $periodsperweek = trim((string)($_POST['periodsperweek'] ?? ''));
            $additional_activity = $_POST['additional_activity'] ?? '';

            if (!$start_valid || !$end_valid || !$term) {
              echo '<div class="alert alert-danger">' . htmlspecialchars('Oops!! Some Fields Are Empty or invalid dates', ENT_QUOTES) . '</div>';
            } else {
              // Prepare insert for weeklyplans
              $insertWpSql = "INSERT INTO weeklyplans(class_sub_id,teacher_id,startdate,enddate,bookpages,periodsperweek,year,term,timestamp,status) VALUES (?,?,?,?,?,?,?,?,?,?)";
              $insertWp = mysqli_prepare($con, $insertWpSql);
              if (!$insertWp) {
                echo '<div class="alert alert-danger">' . htmlspecialchars('Database error: could not prepare statement', ENT_QUOTES) . '</div>';
              } else {
                // Store the raw input dates (already in YYYY-MM-DD format from the browser date input)
                $startdate_db = $start_input;
                $enddate_db = $end_input;
                $bookpages = '';
                $periodsperweek_db = $periodsperweek;
                $year_db = 0;
                $term_db = (int)$term;
                $timestamp_db = isset($timenow) ? (string)$timenow : date('Y-m-d H:i:s');
                $status_db = 1;
                $teacher_id = filter_var($_SESSION['teachersys'] ?? 0, FILTER_VALIDATE_INT) ?: 0;

                mysqli_stmt_bind_param($insertWp, 'iissssiisi', $id, $teacher_id, $startdate_db, $enddate_db, $bookpages, $periodsperweek_db, $year_db, $term_db, $timestamp_db, $status_db);
                $ok = mysqli_stmt_execute($insertWp);
                if (!$ok) {
                  echo '<div class="alert alert-danger">' . htmlspecialchars('Error saving weekly plan: ' . mysqli_stmt_error($insertWp), ENT_QUOTES) . '</div>';
                } else {
                  $last_id = mysqli_insert_id($con);

                  // Insert plan details
                  $insertPdSql = "INSERT INTO plan_details(weekly_plan_id,learning_objectives,resources,teaching_summary,main_activity,plenary,additional_activity,status) VALUES (?,?,?,?,?,?,?,?)";
                  $insertPd = mysqli_prepare($con, $insertPdSql);
                  if ($insertPd) {
                    $status_pd = 1;
                    mysqli_stmt_bind_param($insertPd, 'issssssi', $last_id, $learning_objectives, $resources, $teaching_summary, $main_activity, $plenary, $additional_activity, $status_pd);
                    $ok2 = mysqli_stmt_execute($insertPd);
                    if (!$ok2) {
                      echo '<div class="alert alert-danger">' . htmlspecialchars('Error saving plan details: ' . mysqli_stmt_error($insertPd), ENT_QUOTES) . '</div>';
                    } else {
                      echo '<div class="alert alert-success">' . htmlspecialchars('Weekly Plan successfully Added', ENT_QUOTES) . '</div>';
                    }
                    mysqli_stmt_close($insertPd);
                  } else {
                    echo '<div class="alert alert-danger">' . htmlspecialchars('Database error: could not prepare plan details statement', ENT_QUOTES) . '</div>';
                  }
                }
                mysqli_stmt_close($insertWp);
              }
            }
          }

          ?>
          <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
            <section class="panel">
              <header class="panel-heading">
                Add Weekly Plan
              </header>
              <div class="panel-body">

                <div class="row">
                  <div class="form-group col-lg-4" >
                    <label class=" control-label">*Start & End Dates</label>
                    <div class="input-daterange input-group" >
                      <input type="date" class="input-sm form-control" name="startdate" required="required" />
                      <span class="input-group-addon">to</span>
                      <input type="date" class="input-sm form-control" name="enddate" required="required" />
                    </div>

                  </div>


                  <div class="form-group col-lg-4"><label class="control-label">Number of Periods per Week</label>
                    <input type="number" name="periodsperweek" class="form-control" placeholder="Periods per Week" min="1" value="<?php echo htmlspecialchars($periodsperweek_default ?? '', ENT_QUOTES); ?>">
                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">Select Term</label>
                    <select name="term" class="form-control">
                      <?php
                      $terms = mysqli_query($con, "SELECT * FROM financialterms WHERE status=1");
                      while ($row = mysqli_fetch_assoc($terms)) {
                        $financialterm_id = (int)($row['financialterm_id'] ?? 0);
                        $term_label = htmlspecialchars('Term ' . ($row['term'] ?? '') . ' ' . ($row['year'] ?? ''), ENT_QUOTES);
                      ?>
                        <option value="<?php echo $financialterm_id; ?>"><?php echo $term_label; ?></option>
                      <?php } ?>
                    </select>                   
                  </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                    </div>
                    <div class="form-group col-lg-12">
                      <label class="control-label">Learning Objectives</label>
                      <textarea class="ckeditor" id="editor1" name="learning_objectives" rows="4"></textarea>
                    </div>
                    <div class="form-group col-lg-12">
                      <label class="control-label">Resources</label>
                      <textarea class="ckeditor" id="editor2" name="resources" rows="4"></textarea>
                    </div>
                    <div class="form-group col-lg-12">
                      <label class="control-label">Teaching Summary</label>
                      <textarea class="ckeditor" id="editor3" name="teaching_summary"></textarea>
                    </div>
                    <div class="form-group col-lg-12">
                      <label class="control-label">Main Activity</label>
                      <textarea class="ckeditor" name="main_activity" rows="4"></textarea>
                    </div>
                    <div class="form-group col-lg-12">
                      <label class="control-label">Plenary</label>
                      <textarea class="ckeditor" name="plenary" rows="4"></textarea>
                    </div>
                    <div class="form-group col-lg-12">
                      <label class="control-label">Additional Activity</label>
                      <textarea class="ckeditor" name="additional_activity" rows="4"></textarea>
                    </div>
                   
                  </div>
              </div>
            </section>

       

            <div class="form-group col-lg-12">
              <button class="btn btn-primary" type="submit" name="submit">Add Plan</button>
            </div>

          </form>
        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>

  </div>
  <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

  <script>
    $('#data_5 .input-daterange').datepicker({
      keyboardNavigation: false,
      forceParse: false,
      autoclose: true
    });
  </script>
  <script>
    $('.drug_button').click(function(e) { //on add input button click
      e.preventDefault();
      $(document).ready(function() {

        $('.pharmacy-sec').append('<div class="row"><div class="col-lg-12"><strong style="font-size:16px;color:#000">ADD LESSON PLAN</strong></div><div class="form-group col-lg-4"><label class="control-label">Period</label><input type="text" name="period[]" class="form-control" placeholder="Enter Period" ></div><div class="form-group col-lg-4" id="data_2">  <label class="control-label">Date</label>  <div class="input-group date"><span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="getdate[]" placeholder="select date"> </div> </div><div class="form-group col-lg-3"><label class="control-label">Page numbers</label><input type="text" name="pagenumbers[]" class="form-control" placeholder="Enter Page Numbers" > </div><div class="col-lg-12">  <strong style="color: #000;margin-bottom: 10px;float: left">SIX LESSON PLAN STEPS</strong> </div> <div class="form-group col-lg-4"> <label class="control-label">Objective (use Action Key words)</label><textarea class="form-control" name="objectives[]" rows="4"></textarea> </div> <div class="form-group col-lg-4"> <label class="control-label">Topic of Todays Lesson</label><textarea class="form-control" name="topictoday[]" rows="4"></textarea> </div> <div class="form-group col-lg-4"> <label class="control-label">Review of the previous lesson</label> <textarea class="form-control" name="previouslesson[]" rows="4"></textarea> </div> <div class="form-group col-lg-4">  <label class="control-label">Introduction of the new Lesson</label> <textarea class="form-control" name="lessonintroduction[]" rows="4"></textarea> </div> <div class="form-group col-lg-4"> <label class="control-label">New Lesson</label> <textarea class="form-control" name="newlesson[]" rows="4"></textarea>  </div> <div class="form-group col-lg-4"> <label class="control-label">Review of the Lesson</label> <textarea class="form-control" name="lessonreview[]" rows="4"></textarea></div> <div class="form-group col-lg-4"><label class="control-label">Individual Practice</label> <textarea class="form-control" name="individualpractice[]" rows="4"></textarea> </div><button class="remove_drug  btn btn-danger btn-xs" style="margin-top:20px"><i class="fa fa-minus"></i></button>');
      });
      $('.pharmacy-sec').on("click", ".remove_drug", function(e) { //user click on remove text
        e.preventDefault();
        $(this).parent('div').remove();
        x--;
      });
      $('#data_2 .input-group.date').datepicker({
        todayBtn: "linked",
        keyboardNavigation: false,
        forceParse: false,
        calendarWeeks: true,
        autoclose: true
      });
    });
    $('#data_1 .input-group.date').datepicker({
      todayBtn: "linked",
      keyboardNavigation: false,
      forceParse: false,
      calendarWeeks: true,
      autoclose: true
    });
  </script>

</body>

</html>