<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location:login.php');
  exit;
}
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location:timetable.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Weekly Plan</title>

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-11">
          <?php
          if (isset($_POST['submit'])) {
            // Validate and normalize inputs
            $term = filter_input(INPUT_POST, 'term', FILTER_VALIDATE_INT);

            // Robust date parsing to avoid strtotime day/month ambiguity
            $parse_date = function ($input) {
              $s = trim((string)$input);
              if ($s === '') return null;
              // Try dd/mm/yyyy first (matches our datepicker format)
              $formats = ['d/m/Y', 'Y-m-d', 'd-m-Y', 'm/d/Y'];
              foreach ($formats as $fmt) {
                $d = DateTime::createFromFormat($fmt, $s);
                if ($d && $d->format($fmt) === $s) return $d;
              }
              // last resort: try strtotime
              $ts = strtotime($s);
              if ($ts !== false) return (new DateTime())->setTimestamp($ts);
              return null;
            };

            $start_dt = isset($_POST['startdate']) ? $parse_date($_POST['startdate']) : null;
            $end_dt = isset($_POST['enddate']) ? $parse_date($_POST['enddate']) : null;
            // $period = $_POST['period'];
            // $getdate = $_POST['getdate'];
            // $pagenumbers = $_POST['pagenumbers'];
            // $objectives = $_POST['objectives'];
            // $topictoday = $_POST['topictoday'];
            // $previouslesson = $_POST['previouslesson'];
            // $lessonintroduction = $_POST['lessonintroduction'];
            // $newlesson = $_POST['newlesson'];
            // $guidedpractice = $_POST['guidedpractice'];
            // $lessonreview = $_POST['lessonreview'];
            // $individualpractice = $_POST['individualpractice'];
            // $teachingaids = $_POST['teachingaids'];
            if (!$start_dt || !$end_dt || !$term) {
              echo '<div class="alert alert-danger">' . htmlspecialchars('Oops!! Some Fields Are Empty or dates are invalid', ENT_QUOTES) . '</div>';
            } else {
              // $addbook =  mysqli_query($con, "INSERT INTO weeklyplans(class_sub_id,teacher_id,startdate,enddate,bookpages,periodsperweek,year,term,weeklyplandoc,timestamp,status) VALUES('$id','" . $_SESSION['teachersys'] . "','$startdate','$enddate','','','','$term','$weeklyplandoc','$timenow',1)");
              // $last_id =  mysqli_insert_id($con);
              // $lessons = sizeof($getdate);
              // for ($i = 0; $i < $lessons; $i++) {
              //   $status = 1;
              //   $byrs = $con->prepare("INSERT INTO lessonplans(weeklyplan_id,period,date,pagenumbers,objectives,topictoday,previouslesson,lessonintroduction,newlesson,guidedpractice,lessonreview,individualpractice,teachingaids,status)  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)") or die(mysqli_error($con));
              //   $byrs->bind_param('issssssssssssi', $last_id, $period[$i], $getdate[$i], $pagenumbers[$i], $objectives[$i], $topictoday[$i], $previouslesson[$i], $lessonintroduction[$i], $newlesson[$i], $guidedpractice[$i], $lessonreview[$i], $individualpractice[$i], $teachingaids[$i], $status);
              //   $byrs->execute();
              // }
              // echo '<div class="alert alert-success">Weekly Plan succesfully Added</div>';

              $upload_dir = __DIR__ . "/../uploads/weekly_plans/";
              if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
              }

              // Prepare insert statement once
              $insertSql = "INSERT INTO `weeklyplans` (`class_sub_id`,`teacher_id`,`startdate`,`enddate`,`bookpages`,`periodsperweek`,`year`,`term`,`weeklyplandoc`,`timestamp`,`status`) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
              $insertStmt = mysqli_prepare($con, $insertSql);
              if (!$insertStmt) {
                $msg = 'Database error: could not prepare statement';
                echo '<div class="alert alert-danger">' . htmlspecialchars($msg, ENT_QUOTES) . '</div>';
                if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) {
                  echo '<div class="alert alert-danger">DB prepare error: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES) . '</div>';
                }
              }

              // Handle file uploads
              if (!empty($_FILES['weeklyplandoc'])) {
                $files = $_FILES['weeklyplandoc'];
                $file_count = is_array($files['name']) ? count($files['name']) : 0;

                for ($i = 0; $i < $file_count; $i++) {
                  if (($files['error'][$i] ?? 1) !== UPLOAD_ERR_OK) continue;

                  $file_name = $files['name'][$i];
                  $file_tmp = $files['tmp_name'][$i];
                  $file_size = $files['size'][$i] ?? 0;
                  $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

                  // Basic checks
                  if ($file_ext !== 'pdf') {
                    echo '<div class="alert alert-danger">' . htmlspecialchars('Only PDF files are allowed!', ENT_QUOTES) . '</div>';
                    continue;
                  }
                  if ($file_size > 5 * 1024 * 1024) { // 5 MB limit
                    echo '<div class="alert alert-danger">' . htmlspecialchars('File too large; max 5MB', ENT_QUOTES) . '</div>';
                    continue;
                  }

                  // Build a safe, unique filename
                  $safeBase = preg_replace('/[^a-zA-Z0-9_-]/', '', pathinfo($file_name, PATHINFO_FILENAME));
                  $unique = uniqid((string)$id . '_' . (string)($_SESSION['teachersys'] ?? 't'), true);
                  $destName = $safeBase . '_' . $unique . '.' . $file_ext;
                  $destPath = $upload_dir . $destName;

                  if (move_uploaded_file($file_tmp, $destPath)) {
                    // Convert DateTime to integer timestamps for compatibility with existing display code
                    $startdate_db = (int)$start_dt->getTimestamp();
                    $enddate_db = (int)$end_dt->getTimestamp();
                    $bookpages = '';
                    $periodsperweek = isset($_POST['periodsperweek']) && $_POST['periodsperweek'] !== '' ? (int)$_POST['periodsperweek'] : 0;
                    $year = '';
                    $term_int = (int)$term;
                    $weeklyplandoc_db = 'uploads/weekly_plans/' . $destName; // path relative to project root
                    $timestamp_db = isset($timenow) ? (string)$timenow : date('Y-m-d H:i:s');
                    $status = 1;

                    if ($insertStmt) {
                      // use local variables for bind_param (required by mysqli)
                      $class_sub_id_db = (int)$id;
                      $teacher_id_db = (int)($_SESSION['teachersys'] ?? 0);
                      $startdate_db_local = $startdate_db;
                      $enddate_db_local = $enddate_db;
                      $bookpages_db = $bookpages;
                      $periodsperweek_db = $periodsperweek;
                      $year_db = $year;
                      $term_db = (int)$term_int;
                      $weeklyplandoc_db_local = $weeklyplandoc_db;
                      $timestamp_db_local = $timestamp_db;
                      $status_db = (int)$status;

                      // startdate and enddate are integers (timestamps) to match other pages that expect epoch ints
                      $bound = mysqli_stmt_bind_param($insertStmt, 'iiiisssissi', $class_sub_id_db, $teacher_id_db, $startdate_db_local, $enddate_db_local, $bookpages_db, $periodsperweek_db, $year_db, $term_db, $weeklyplandoc_db_local, $timestamp_db_local, $status_db);
                      if ($bound === false) {
                        if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) {
                          echo '<div class="alert alert-danger">Bind error: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES) . '</div>';
                        }
                      } else {
                        $exec = mysqli_stmt_execute($insertStmt);
                        if (!$exec) {
                          echo '<div class="alert alert-danger">' . htmlspecialchars('Error saving to database', ENT_QUOTES) . '</div>';
                          if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) {
                            echo '<div class="alert alert-danger">DB error: ' . htmlspecialchars(mysqli_stmt_error($insertStmt), ENT_QUOTES) . '</div>';
                          }
                        }
                      }
                    }
                  } else {
                    echo '<div class="alert alert-danger">' . htmlspecialchars('Error uploading file!', ENT_QUOTES) . '</div>';
                  }
                }

                if ($insertStmt) mysqli_stmt_close($insertStmt);

                echo '<div class="alert alert-success">' . htmlspecialchars('Weekly Plan successfully Added', ENT_QUOTES) . '</div>';
              }
            }
          }

          ?>
          <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
            <section class="panel">
              <header class="panel-heading">
                Add Weekly Plan
              </header>
              <div class="panel-body">

                <div class="row">
                  <div class="form-group col-lg-4" id="data_5">
                    <label class=" control-label">*Start & End Dates</label>
                    <div class="input-daterange input-group" id="datepicker">
                      <input type="text" class="input-sm form-control" name="startdate" required="required" />
                      <span class="input-group-addon">to</span>
                      <input type="text" class="input-sm form-control" name="enddate" required="required" />
                    </div>

                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">Periods per Week</label>
                    <input type="number" name="periodsperweek" class="form-control" placeholder="Enter periods per week" min="0">
                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">Select Term</label>
                    <select name="term" class="form-control" required>
                      <option value="" selected="selected">Select ...</option>
                      <?php
                      $termsRes = mysqli_query($con, "SELECT financialterm_id, term, year FROM financialterms WHERE status = 1 ORDER BY year DESC, financialterm_id DESC");
                      if ($termsRes) {
                        while ($t = mysqli_fetch_assoc($termsRes)) {
                          $fid = (int)($t['financialterm_id'] ?? 0);
                          $tname = $t['term'] ?? '';
                          $tyear = $t['year'] ?? '';
                          $label = 'Term ' . $tname . ' ' . $tyear;
                      ?>
                          <option value="<?php echo $fid; ?>"><?php echo htmlspecialchars($label, ENT_QUOTES); ?></option>
                      <?php
                        }
                      }
                      ?>
                    </select>
                  </div>
                </div>
              </div>
            </section>

            <section class="panel">
              <header class="panel-heading">
                Add Weekly Plan
              </header>
              <div class="panel-body">
                <div class="pharmacy-sec">
                  <div class="row">
                    <div class="form-group col-lg-11">
                      <label class="control-label">Upload Weekly Plan (PDF)</label>
                      <input type="file" name="weeklyplandoc[]" class="form-control" accept=".pdf" required>
                      <small class="text-muted">Please upload a PDF file containing your weekly lesson plan</small>
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <button class="drug_button btn btn-info btn-xs">Add more</button>
                </div>

              </div>

            </section>

            <div class="form-group col-lg-12">
              <button class="btn btn-primary" type="submit" name="submit">Add Plan</button>
            </div>

          </form>
        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>

  </div>
  <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

  <script>
    $('#data_5 .input-daterange').datepicker({
      keyboardNavigation: false,
      forceParse: false,
      autoclose: true,
      format: 'dd/mm/yyyy'
    });
  </script>
  <script>
    $('.drug_button').click(function(e) { //on add input button click
      e.preventDefault();
      $(document).ready(function() {
        $('.pharmacy-sec').append(`
          <div class="row">
            <div class="col-lg-12">
              <strong style="font-size:14px;color:#000">ADD WEEKLY PLAN</strong>
            </div>
            <div class="form-group col-lg-11">
              <label class="control-label">Upload Weekly Plan (PDF)</label>
              <input type="file" name="weeklyplandoc[]" class="form-control" accept=".pdf" required>
              <small class="text-muted">Please upload a PDF file containing your weekly lesson plan</small>
            </div>
            <button class="remove_drug btn btn-danger btn-sm" style="margin-top:20px">
              <i class="fa fa-minus"></i>
            </button>
          </div>
        `);
      });

      $('.pharmacy-sec').on("click", ".remove_drug", function(e) { //user click on remove text
        e.preventDefault();
        $(this).parent('div').remove();
      });
    });
  </script>

</body>

</html>