<?php
if (session_status() === PHP_SESSION_NONE) session_start();
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] != 'yes')) {
    header('Location:login.php');
    exit;
}

// sanitize inputs: stream (st) may be 0 for classes without streams
$cl = isset($_GET['cl']) ? (int)$_GET['cl'] : 0;
$st = isset($_GET['st']) ? (int)$_GET['st'] : 0; // allow 0
if ($cl <= 0) {
    header('Location: timetable');
    exit;
}
// If the user is a class teacher, ensure they can only edit their own class timetable
$teacher_class = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
if (isset($_SESSION['classteacher']) && $_SESSION['classteacher'] === 'yes') {
    // Require a valid session class assignment and enforce it matches the requested class
    if ($teacher_class <= 0 || $teacher_class !== $cl) {
        header('Location: timetable');
        exit;
    }
}
// $day = $_GET['day'];
$stream = null;
$class = '';
$stmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $cl);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $class_col);
    if (mysqli_stmt_fetch($stmt)) $class = $class_col;
    mysqli_stmt_close($stmt);
}
$stream = null;
$stmt = mysqli_prepare($con, "SELECT stream FROM streams WHERE stream_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $st);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $stream_col);
    if (mysqli_stmt_fetch($stmt)) $stream = $stream_col;
    mysqli_stmt_close($stmt);
}
// $getdays =  mysqli_query($con, "SELECT * FROM days WHERE short='$day'");
// $roww = mysqli_fetch_array($getdays);
// $fullday = $roww['day'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="t">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>Add Timetable for <?php echo htmlspecialchars($class . ' ' . $stream, ENT_QUOTES); ?></title>

    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/ckeditor/ckeditor.js"></script>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/ckeditor/samples/sample.css">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
    <link href="<?php echo BASE_URL; ?>/css/chosen/chosen.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
        <?php include 'nav.php';
        //   echo str_replace('\', ' ',$organisation);
        ?>

        <section class="wrapper">
            <!-- page start-->

            <div class="row">
                <div class="col-lg-8">
                    <section class="panel">
                        <header class="panel-heading">
                            Add <?php echo $class . ' ' . $stream; ?> Timetable
                        </header>
                        <div class="panel-body">
                            <?php
                            if (isset($_POST['submit'])) {
                                $classsubject = $_POST['classsubject'];
                                $starttime = $_POST['starttime'];
                                $activity = $_POST['activity'];
                                $endtime = $_POST['endtime'];
                                $days = $_POST['days'];

                                if ((empty($starttime)) || (empty($endtime))) {
                                    $errors[] = 'Some Fields are Empty';
                                }

                                if ((empty($classsubject)) && (empty($activity))) {
                                    $errors[] = 'Class Subject or Activity should be Filled';
                                }

                                if (empty($days)) {
                                    $errors[] = 'Please select a day';
                                }

                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<div class="alert alert-danger">' . $error . '</div>';
                                    }
                                } else {
                                    $timetablecount = count($starttime);

                                    // use the correct primary key column name `timetable_id`
                                    // Quote identifiers to avoid issues with reserved words like day
                                    $selStmt = mysqli_prepare($con, "SELECT `timetable_id` FROM `timetables` WHERE `class_id`=? AND `stream_id`=? AND `day`=? AND `starttime`=? AND `endtime`=? LIMIT 1");
                                    $updStmt = mysqli_prepare($con, "UPDATE `timetables` SET `activity`=? WHERE `timetable_id`=?");
                                    $insStmt = mysqli_prepare($con, "INSERT INTO `timetables` (`class_id`, `stream_id`, `activity`, `starttime`, `endtime`, `day`, `position`, `status`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

                                    for ($i = 0; $i < $timetablecount; $i++) {
                                        $status = 1;
                                        $day = $days[$i] ?? '';
                                        $stTime = $starttime[$i] ?? '';
                                        $enTime = $endtime[$i] ?? '';

                                        // choose activity value (either explicit activity or selected classsubject)
                                        $actVal = trim((string)($activity[$i] ?? ''));
                                        if ($actVal === '') $actVal = trim((string)($classsubject[$i] ?? ''));

                                        // If a subject option was selected with prefix, map to class_sub_id string
                                        if (strpos($actVal, 'cs_') === 0) {
                                            $actVal = substr($actVal, 3); // existing class_sub_id as string
                                        } elseif (strpos($actVal, 's_') === 0) {
                                            // subject selected that is not yet in class_subjects: find or insert class_subjects
                                            $subject_sel = (int)substr($actVal, 2);
                                            $found_cs = null;
                                            $findCs = mysqli_prepare($con, "SELECT class_sub_id FROM class_subjects WHERE class_id = ? AND subject_id = ? LIMIT 1");
                                            if ($findCs) {
                                                mysqli_stmt_bind_param($findCs, 'ii', $cl, $subject_sel);
                                                mysqli_stmt_execute($findCs);
                                                mysqli_stmt_bind_result($findCs, $found_cs_id);
                                                if (mysqli_stmt_fetch($findCs)) {
                                                    $found_cs = (int)$found_cs_id;
                                                }
                                                mysqli_stmt_close($findCs);
                                            }
                                            if ($found_cs) {
                                                $actVal = (string)$found_cs;
                                            } else {
                                                // create a new class_subject link
                                                $insCs = mysqli_prepare($con, "INSERT INTO class_subjects (class_id, subject_id) VALUES (?, ?)");
                                                if ($insCs) {
                                                    mysqli_stmt_bind_param($insCs, 'ii', $cl, $subject_sel);
                                                    if (mysqli_stmt_execute($insCs)) {
                                                        $new_cs_id = mysqli_insert_id($con);
                                                        $actVal = (string)$new_cs_id;
                                                    }
                                                    mysqli_stmt_close($insCs);
                                                }
                                            }
                                        }

                                        if ($day === '' || $stTime === '' || $enTime === '') continue;

                                        if ($selStmt) {
                                            mysqli_stmt_bind_param($selStmt, 'iisss', $cl, $st, $day, $stTime, $enTime);
                                            mysqli_stmt_execute($selStmt);
                                            mysqli_stmt_store_result($selStmt);
                                            if (mysqli_stmt_num_rows($selStmt) > 0) {
                                                mysqli_stmt_bind_result($selStmt, $existingId);
                                                mysqli_stmt_fetch($selStmt);
                                                if ($updStmt) {
                                                    mysqli_stmt_bind_param($updStmt, 'si', $actVal, $existingId);
                                                    mysqli_stmt_execute($updStmt);
                                                }
                                            } else {
                                                if ($insStmt) {
                                                    $position = $i;
                                                    // class_id (i), stream_id (i), activity (s), starttime (s), endtime (s), day (s), position (i), status (i)
                                                    mysqli_stmt_bind_param($insStmt, 'iissssii', $cl, $st, $actVal, $stTime, $enTime, $day, $position, $status);
                                                    $execIns = mysqli_stmt_execute($insStmt);
                                                    if (!$execIns) {
                                                        // show a helpful message in dev to diagnose why insert failed
                                                        echo '<div class="alert alert-danger">Insert failed: ' . htmlspecialchars(mysqli_stmt_error($insStmt)) . '</div>';
                                                    }
                                                }
                                            }
                                            mysqli_stmt_free_result($selStmt);
                                        }
                                    }

                                    if ($selStmt) mysqli_stmt_close($selStmt);
                                    if ($updStmt) mysqli_stmt_close($updStmt);
                                    if ($insStmt) mysqli_stmt_close($insStmt);

                                    echo '<div class="alert alert-success">Timetable Successfully Updated. <a href="timetable?class=' . $cl . '_' . $st . '">View Timetable</a></div>';
                                }
                            }
                            ?>
                            <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                                <div class="alert alert-info">Either select a <strong>subject</strong> or Enter <strong>activity</strong> for a particular time session but not both</div>

                                <?php
                                // Get all days
                                $days_query = mysqli_query($con, "SELECT * FROM days");
                                $days = array();
                                while ($day_row = mysqli_fetch_array($days_query)) {
                                    $days[] = $day_row;
                                }
                                ?>

                                <div class="pharmacy-sec">
                                    <div class="row">
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Subject</label>
                                            <select data-placeholder="Choose subject..." name="classsubject[]" class="chosen-select" style="width:100%;" tabindex="2">
                                                <option value="">Select Subject</option>
                                                <?php
                                                // list existing class_subjects for this class (prefix with cs_)
                                                $class_subjects = mysqli_query($con, "SELECT cs.class_sub_id, cs.subject_id, c.class, s.subject FROM class_subjects cs JOIN classes c ON cs.class_id=c.class_id JOIN subjects s ON cs.subject_id=s.subject_id WHERE cs.class_id='" . (int)$cl . "'");
                                                while ($row = mysqli_fetch_assoc($class_subjects)) {
                                                    $class_sub_id = $row['class_sub_id'];
                                                    $class_name_opt = $row['class'];
                                                    $subject_name_opt = $row['subject'];
                                                ?>
                                                    <option value="cs_<?php echo $class_sub_id; ?>"><?php echo htmlspecialchars($class_name_opt . ':' . $subject_name_opt, ENT_QUOTES); ?></option>
                                                <?php }

                                                // offer other subjects not yet linked to this class (prefix with s_)
                                                $existing_subjects = mysqli_query($con, "SELECT subject_id FROM class_subjects WHERE class_id='" . (int)$cl . "'");
                                                $existing_ids = [];
                                                if ($existing_subjects) {
                                                    while ($er = mysqli_fetch_assoc($existing_subjects)) $existing_ids[] = (int)$er['subject_id'];
                                                }
                                                $not_in_clause = '';
                                                if (!empty($existing_ids)) $not_in_clause = ' WHERE subject_id NOT IN (' . implode(',', $existing_ids) . ')';
                                                $other_subjects = mysqli_query($con, "SELECT subject_id, subject FROM subjects" . $not_in_clause . " ORDER BY subject");
                                                if ($other_subjects && mysqli_num_rows($other_subjects) > 0) {
                                                    echo '<optgroup label="Other Subjects">';
                                                    while ($sr = mysqli_fetch_assoc($other_subjects)) {
                                                        $sid = (int)$sr['subject_id'];
                                                        $sname = $sr['subject'];
                                                        echo '<option value="s_' . $sid . '">' . htmlspecialchars($sname, ENT_QUOTES) . '</option>';
                                                    }
                                                    echo '</optgroup>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Activity (Enter if isn't a subject e.g Lunch)</label>
                                            <input type="text" class="form-control" name="activity[]" placeholder="enter activity">
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Start Time (Click on clock icon)</label>
                                            <div class="input-group bootstrap-timepicker">
                                                <input type="text" class="form-control timepicker-24" name="starttime[]" required="required">
                                                <span class="input-group-btn">
                                                    <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">End Time (Click on Clock icon)</label>
                                            <div class="input-group bootstrap-timepicker">
                                                <input type="text" class="form-control timepicker-24" name="endtime[]" required="required">
                                                <span class="input-group-btn">
                                                    <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Select Day</label>
                                            <select name="days[]" class="form-control" required="required">
                                                <option value="">Select Day</option>
                                                <?php foreach ($days as $day): ?>
                                                    <option value="<?php echo $day['short']; ?>"><?php echo $day['day']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <button class="drug_button btn btn-info btn-xs">Add more</button>
                                </div>
                                <div class="form-group">
                                    <button class="btn btn-primary" type="submit" name="submit">Submit</button>
                                </div>
                            </form>
                        </div>
                    </section>
                </div>
            </div>
        </section>

        </div>

        </div>


        </div>
        <!-- page end-->
    </section>


    </div>
    <!-- main content end-->
    </section>

    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/chosen/chosen.jquery.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/pickers-init.js?<?php echo time(); ?>"></script>
    <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
    <script>
        $('.drug_button').click(function(e) { //on add input button click
            e.preventDefault();
            $(document).ready(function() {
                // Get the days options HTML
                var daysOptions = '';
                <?php foreach ($days as $day): ?>
                    daysOptions += '<option value="<?php echo $day['short']; ?>"><?php echo $day['day']; ?></option>';
                <?php endforeach; ?>

                $('.pharmacy-sec').append(`<div class="row">
                    <div class="form-group col-lg-6">
                        <label class="control-label">Subject</label>
                        <select data-placeholder="Choose Subject..." name="classsubject[]" class="chosen-select" style="width:100%;" tabindex="2">
                            <option value="">Select Subject</option>
                            <?php
                            // list all class_subjects (prefixed cs_)
                            $class_subjects = mysqli_query($con, "SELECT cs.class_sub_id, cs.subject_id, c.class, s.subject FROM class_subjects cs JOIN classes c ON cs.class_id=c.class_id JOIN subjects s ON cs.subject_id=s.subject_id ORDER BY c.class, s.subject");
                            while ($row = mysqli_fetch_assoc($class_subjects)) {
                                $class_sub_id = $row['class_sub_id'];
                                $class_name_opt = $row['class'];
                                $subject_name_opt = $row['subject'];
                                echo '<option value="cs_' . $class_sub_id . '">' . htmlspecialchars($class_name_opt . ':' . $subject_name_opt, ENT_QUOTES) . '</option>';
                            }

                            // additionally offer standalone subjects (not grouped) -- these will be filtered client-side by the class-specific select when needed
                            $other_subjects = mysqli_query($con, "SELECT subject_id, subject FROM subjects ORDER BY subject");
                            if ($other_subjects) {
                                echo '<optgroup label="All Subjects">';
                                while ($sr = mysqli_fetch_assoc($other_subjects)) {
                                    $sid = (int)$sr['subject_id'];
                                    $sname = $sr['subject'];
                                    echo '<option value="s_' . $sid . '">' . htmlspecialchars($sname, ENT_QUOTES) . '</option>';
                                }
                                echo '</optgroup>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="form-group col-lg-6">
                        <label class="control-label">Activity</label>
                        <input type="text" class="form-control" name="activity[]" placeholder="enter activity">
                    </div>
                    <div class="form-group col-lg-6">
                        <label class="control-label">Start Time</label>
                        <div class="input-group bootstrap-timepicker">
                            <input type="text" class="form-control timepicker-24" name="starttime[]" required="required">
                            <span class="input-group-btn">
                                <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="form-group col-lg-6">
                        <label class="control-label">End Time</label>
                        <div class="input-group bootstrap-timepicker">
                            <input type="text" class="form-control timepicker-24" name="endtime[]" required="required">
                            <span class="input-group-btn">
                                <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="form-group col-lg-6">
                        <label class="control-label">Select Day</label>
                        <select name="days[]" class="form-control" required="required">
                            <option value="">Select Day</option>
                            ${daysOptions}
                        </select>
                    </div>
                    <button class="remove_drug btn btn-danger btn-xs" style="margin-top:20px"><i class="fa fa-minus"></i> Remove</button>
                </div>`);

                // Initialize timepicker and chosen for the new elements
                $('.timepicker-24').timepicker({
                    autoclose: true,
                    minuteStep: 5,
                    showSeconds: false,
                    showMeridian: false
                });

                var config = {
                    '.chosen-select': {},
                    '.chosen-select-deselect': {
                        allow_single_deselect: true
                    },
                    '.chosen-select-no-single': {
                        disable_search_threshold: 10
                    },
                    '.chosen-select-no-results': {
                        no_results_text: 'Oops, nothing found!'
                    },
                    '.chosen-select-width': {
                        width: "95%"
                    }
                }
                for (var selector in config) {
                    $(selector).chosen(config[selector]);
                }
            });
        });
    </script>
</body>

</html>