<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
   header('Location:login.php');
   exit;
}

// normalize session teacher id
$session_teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add Subject Report-School Manager</title>
          <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
   <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
            <link href="<?php echo BASE_URL; ?>/css/chosen/chosen.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
           
    <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                  Add Report
                    </header>
                          <div class="panel-body">      
        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['report'], $_POST['term'], $_POST['topics'], $_POST['class'], $_POST['student'])) {
          $errors = [];
          $report_raw = (string)($_POST['report'] ?? '');
          $term = (int)($_POST['term'] ?? 0);
          $class_raw = (string)($_POST['class'] ?? '');
          $student = (int)($_POST['student'] ?? 0);
          $topics_raw = trim((string)($_POST['topics'] ?? ''));

          $split = explode(',', $class_raw);
          $class_id = (int)current($split);
          $subject = (int)end($split);

          if ($report_raw === '' || $term <= 0 || $student <= 0) {
            $errors[] = 'Enter All Fields to Proceed';
          }

          // check duplicate using prepared statement
          if (empty($errors)) {
            $chk_stmt = mysqli_prepare($con, "SELECT 1 FROM subjecttermreports WHERE term_id=? AND class_id=? AND subject_id=? AND student_id=? AND teacher_id=? AND status=1 LIMIT 1");
            if ($chk_stmt) {
              mysqli_stmt_bind_param($chk_stmt, 'iiiii', $term, $class_id, $subject, $student, $session_teacher_id);
              mysqli_stmt_execute($chk_stmt);
              mysqli_stmt_store_result($chk_stmt);
              if (mysqli_stmt_num_rows($chk_stmt) > 0) {
                $errors[] = 'Report already Added';
              }
              mysqli_stmt_close($chk_stmt);
            } else {
              $errors[] = 'Database error';
            }
          }

          if (!empty($errors)) {
            foreach ($errors as $error) {
              echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>';
            }
          } else {
            // insert using prepared statement
            $ins = mysqli_prepare($con, "INSERT INTO subjecttermreports (term_id, class_id, subject_id, teacher_id, student_id, topics, report, timestamp, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 1)");
            if ($ins) {
              $topics_clean = $topics_raw;
              $report_clean = $report_raw;
              $tstamp = isset($timenow) ? $timenow : date('Y-m-d H:i:s');
              mysqli_stmt_bind_param($ins, 'iiiissss', $term, $class_id, $subject, $session_teacher_id, $student, $topics_clean, $report_clean, $tstamp);
              $ok = mysqli_stmt_execute($ins);
              if ($ok) {
                echo '<div class="alert alert-success">Report Successfully Added</div>';
              } else {
                echo '<div class="alert alert-danger">Insert failed: ' . htmlspecialchars(mysqli_stmt_error($ins)) . '</div>';
              }
              mysqli_stmt_close($ins);
            } else {
              echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars(mysqli_error($con)) . '</div>';
            }
          }
        }
        ?>
                        
<form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
      <div class="form-group">
                                  <label class="control-label">*Term and Year</label>                                
                                        <select name="term" class="form-control">
                                            <option value="" selected="selected">Select Term ...</option>
                                                                                           <?php
$terms=  mysqli_query($con,"SELECT  * FROM financialterms WHERE status=1");
  while($row=  mysqli_fetch_array($terms)){
  $financialterm_id=$row['financialterm_id'];
$term=$row['term'];
$year=$row['year'];
$status=$row['status'];
  ?>
   <option value="<?php echo $financialterm_id;?>"><?php echo 'Term '.$term.' '.$year;?></option>
  <?php } ?>
                                        </select>                                                                     
                                </div>
        <div class="form-group"><label class="control-label">* Student</label>
                         <select name='student'  data-placeholder="Choose a Student..." class="chosen-select" style="width:100%;" tabindex="2" >
                             <option value="" selected="selected">Select student..</option>
                                                                                                        <?php 
                                   $students=  mysqli_query($con,"SELECT * FROM students WHERE status=1");              
                                        while ($row = mysqli_fetch_array($students)) {
                                          $regnumber=$row['regnumber'];
                                          $student_id=$row['student_id'];
                                          $class_id=$row['class_id'];
                                           $fullname=$row['fullname'];                                                        
                              $getclasses=  mysqli_query($con,"SELECT * FROM classes WHERE class_id='$class_id'");
                                       $row2=  mysqli_fetch_array($getclasses);
                                       $class=$row2['class'];
                                       
                                                     ?>
                                                     <option value="<?php echo $student_id; ?>"><?php   echo $fullname.'('.$class.')'; ?></option>
                                    <?php } ?>
                                         </select>
                                                                                                       </div>
      <div class="form-group"><label class="control-label">* Class and subject</label>
                                    <select name='class' class="form-control" >
                                                                                                        <?php 
                                                    $teacher_subjects=mysqli_query($con,"SELECT * FROM teacher_subjects WHERE teacher_id='".$_SESSION['teachersys']."'");
                                    while ($row = mysqli_fetch_array($teacher_subjects)) {
                                          $class_sub_id=$row['class_sub_id'];
                                           $class_subjects=mysqli_query($con,"SELECT * FROM class_subjects WHERE class_sub_id='$class_sub_id'");
                                    while ($row1 = mysqli_fetch_array($class_subjects)) {
                                            $class_id=$row1['class_id'];
                                       $subject_id=$row1['subject_id'];
                                   $getclasses=  mysqli_query($con,"SELECT * FROM classes WHERE class_id='$class_id'");
                                       $row2=  mysqli_fetch_array($getclasses);
                                       $class=$row2['class'];
                                        $getsubjects=  mysqli_query($con,"SELECT * FROM subjects WHERE subject_id='$subject_id'");
                                       $row3=  mysqli_fetch_array($getsubjects);
                                       $subject=$row3['subject'];                                       
                                                     ?>
                                                     <option value="<?php echo $class_id.','.$subject_id; ?>"><?php   echo $class.':'.$subject; ?></option>
                                    <?php }}?>
                                         </select>                                                                          
                                </div>                     
       <div class="form-group">
                                                          <label>Topics Covered (Seperate them with commas)*</label>
                                                          <input type="text" name="topics"  required="required" class="form-control">
                                                    </div>
                                               <div class="form-group">
                                      <label class="control-label">Report</label>                                
                                   <textarea class="ckeditor" id="editor1" name="report">                                            
                                                </textarea>                                             
                                </div>
                                  
                                                     <div class="hr-line-dashed"></div>                            
                                                                                                  
                                <div class="form-group">                                                                    
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                                                 </div>
                            </form>
                       </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        
    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/chosen/chosen.jquery.js"></script>
<script>
    var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }
            </script>

  
</body>

</html>
 