<?php
if (session_status() === PHP_SESSION_NONE) session_start();
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] !== 'yes')) {
    header('Location:login.php');
    exit;
}

// ensure class_id and teachersys are available and casted
$session_class_id = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
$session_teachersys = isset($_SESSION['teachersys']) ? (string)$_SESSION['teachersys'] : '';
?>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add  subject - School Manager</title>
    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">
    <!--<link href="css/plugins/iCheck/custom.css" rel="stylesheet">-->
    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
      <link href="<?php echo BASE_URL; ?>/css/plugins/chosen/chosen.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

                            
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2>Add New Learning Area</h2>
                    <ol class="breadcrumb">
                        <li>              <a href=""><i class="fa fa-home"></i> Home</a>                    </li>
                        <li>                         <a>learning areas</a>                       </li>
                        <li class="active">
                            <strong>Add New</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content">
                                <div class="row">
                <div class="col-lg-8">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>Add New Learning Area <small>All  fields marked (*) shouldn't be left blank</small></h5>
                           
                        </div>
                        <div class="ibox-content">
                            <?php
                            // Process POST (sanitized / prepared)
                            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['subject'], $_POST['type'])) {
                                $subject_raw = trim((string)($_POST['subject'] ?? ''));
                                $type_raw = trim((string)($_POST['type'] ?? ''));

                                if ($subject_raw === '' || $type_raw === '') {
                                    echo '<div class="alert alert-danger">All Fields are Required</div>';
                                } else {
                                    // fetch class/category info to validate allowed types
                                    $category_id = 0;
                                    if ($session_class_id > 0) {
                                        $class_q = mysqli_query($con, "SELECT * FROM classes WHERE class_id=" . $session_class_id . " LIMIT 1");
                                        if ($class_q && mysqli_num_rows($class_q) > 0) {
                                            $class_row = mysqli_fetch_assoc($class_q);
                                            $category_id = isset($class_row['category_id']) ? (int)$class_row['category_id'] : 0;
                                        }
                                    }

                                    // allowed types depending on class category
                                    $allowed = [];
                                    if ($category_id === 3) {
                                        $allowed = ['prime', 'specific'];
                                    } else {
                                        $allowed = ['subject', 'session'];
                                    }

                                    if (!in_array($type_raw, $allowed, true)) {
                                        echo '<div class="alert alert-danger">Invalid type selected.</div>';
                                    } else {
                                        // use prepared statement for insert
                                        $stmt = mysqli_prepare($con, "INSERT INTO subjects (subject, type, class_id, creator, status) VALUES (?, ?, ?, ?, 1)");
                                        if ($stmt) {
                                            $subject_clean = $subject_raw;
                                            $type_clean = $type_raw;
                                            // types: subject (s), type (s), class_id (i), creator (s)
                                            mysqli_stmt_bind_param($stmt, 'ssis', $subject_clean, $type_clean, $session_class_id, $session_teachersys);
                                            $ok = mysqli_stmt_execute($stmt);
                                            if ($ok) {
                                                echo '<div class="alert alert-success"><i class="fa fa-check"></i> Learning Area Successfully Added</div>';
                                            } else {
                                                $err = htmlspecialchars(mysqli_stmt_error($stmt), ENT_QUOTES);
                                                echo '<div class="alert alert-danger">Insert failed: ' . $err . '</div>';
                                            }
                                            mysqli_stmt_close($stmt);
                                        } else {
                                            $err = htmlspecialchars(mysqli_error($con), ENT_QUOTES);
                                            echo '<div class="alert alert-danger">Database error: ' . $err . '</div>';
                                        }
                                    }
                                }
                            }
                            ?>
    $getclasses = mysqli_query($con, "SELECT * FROM classes WHERE class_id='" . $session_class_id . "' LIMIT 1");
    $row3 = $getclasses ? mysqli_fetch_assoc($getclasses) : null;
    $class = $row3['class'] ?? '';
    $category_id = isset($row3['category_id']) ? (int)$row3['category_id'] : 0;
?>
                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
                                  <div class="form-group"><label class="control-label"> *Learning Area Name</label>
<input type="text" name="subject" class="form-control "  placeholder="Enter  name" required="required">
                                                                     
                                </div>
          <div class="form-group"><label class="control-label"> *Type</label>
                  <select name="type" class="form-control ">
                      <option value="" selected="selected">Select type..</option>
                            <?php
                                                      if ($category_id == 3) {
                                                          ?>
                      <option value="prime">Prime Areas</option>
                      <option value="specific">Specific Areas</option>
                                                      <?php }else{?>
                      <option value="subject">Academic Subject</option>
                      <option value="session">Spark Session</option>
                                                      <?php }?>
                  </select>
                                                                   
                                </div>
                                                                                                                                
                                <div class="form-group">
                                        <button class="btn btn-primary" type="submit">Add</button>
                              
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/plugins/chosen/chosen.jquery.js"></script>
    <!-- iCheck -->
   <script language="JavaScript" src="<?php echo BASE_URL; ?>/js/gen_validatorv4.js" type="text/javascript"></script>
</body>

</html>
 <script type="text/javascript">
     
                    var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }

 
</script>