<?php
if (session_status() === PHP_SESSION_NONE) session_start();
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$class = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($class <= 0) {
  echo '<div class="alert alert-danger">Invalid class id</div>';
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add Marks-School Manager</title>
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                     Select to Proceed
                    </header>
                          <div class="panel-body">      
      <?php
      if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $term = isset($_POST['term']) ? (int)$_POST['term'] : 0;
        $date_ts = strtotime((string)($_POST['date'] ?? ''));
        $date = $date_ts ? (int)$date_ts : 0;

        $errors = [];
        if ($term <= 0) {
          $errors[] = 'Term Not Selected';
        }
        if ($date <= 0) {
          $errors[] = 'Date Not Selected';
        }

        if (!empty($errors)) {
          foreach ($errors as $error) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>';
          }
        } else {
          $params = http_build_query([
            'cl' => $class,
            'tm' => $term,
            'dt' => $date,
          ]);
          $url = 'addstudentcomment.php?' . $params;
          echo '<script>window.location = ' . json_encode($url) . ';</script>';
          exit;
        }
      }
      ?>
                        
<form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
<div class="form-group" id="data_1">
                              <label class="control-label">Report Date</label>
                                                         <div class="input-group date">
                                                             <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="date" placeholder="select date" required="required">
                                      </div>
                            </div>
                                  <div class="hr-line-dashed"></div>
                                  <div class="form-group">
                                      <label class="control-label">*Term and Year</label>                                
                    <select name="term" class="form-control">
                                               <?php
                        $terms = mysqli_query($con, "SELECT financialterm_id,term,year FROM financialterms");
                        if ($terms) {
                          while ($row = mysqli_fetch_assoc($terms)) {
                            $financialterm_id = (int)($row['financialterm_id'] ?? 0);
                            $termName = $row['term'] ?? '';
                            $year = $row['year'] ?? '';
                            ?>
                          <option value="<?php echo $financialterm_id;?>"><?php echo htmlspecialchars('Term ' . $termName . ' ' . $year, ENT_QUOTES);?></option>
                              <?php }
                        }
                        ?>
                    </select>                                                                     
                                </div>
                                  
                                                     <div class="hr-line-dashed"></div>                            
                                                                                                  
                                <div class="form-group">                                                                    
                                        <button class="btn btn-primary" type="submit">Proceed</button>
                                                                 </div>
                            </form>
                       </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
<script>
   // add event listerner for on change of class_subject 
   $(document).on('change', '#class_subject', function() {
    var report_type = $(this).find(':selected').data('report');
    if(report_type == '1'){
        $('#paper_1').hide();
        $('#paper_2').val('1');
    }else{
        $('#paper_1').show();
         $('#paper_2').val('');
    }
   });
  $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });   
</script>
  
</body>

</html>
 