<?php
if (session_status() === PHP_SESSION_NONE) session_start();
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || (($_SESSION['classteacher'] ?? '') !== 'yes')) {
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>

  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Add Report-School Manager</title>
  <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-10">
          <section class="panel">
            <header class="panel-heading">
              Add Report
            </header>
            <div class="panel-body">
              <?php
              if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['report'], $_POST['term'])) {
                $report = trim((string)($_POST['report'] ?? ''));
                $term = isset($_POST['term']) ? (int)$_POST['term'] : 0;
                $errors = [];
                if ($report === '' || $term <= 0) {
                  $errors[] = 'Enter All Fields to Proceed';
                }

                // check duplicate using prepared statement
                $teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
                $check_stmt = mysqli_prepare($con, "SELECT 1 FROM reports WHERE term_id=? AND teacher_id=? AND status=1 LIMIT 1");
                if ($check_stmt) {
                  mysqli_stmt_bind_param($check_stmt, 'ii', $term, $teacher_id);
                  mysqli_stmt_execute($check_stmt);
                  mysqli_stmt_store_result($check_stmt);
                  if (mysqli_stmt_num_rows($check_stmt) > 0) {
                    $errors[] = 'Report already Added';
                  }
                  mysqli_stmt_close($check_stmt);
                }

                if (!empty($errors)) {
                  foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>';
                  }
                } else {
                  $ins = mysqli_prepare($con, "INSERT INTO reports(term_id,teacher_id,report,timestamp,status) VALUES(?,?,?,?,1)");
                  if ($ins) {
                    $timestamp = $timenow ?? date('Y-m-d H:i:s');
                    mysqli_stmt_bind_param($ins, 'iiss', $term, $teacher_id, $report, $timestamp);
                    mysqli_stmt_execute($ins);
                    mysqli_stmt_close($ins);
                    echo '<div class="alert alert-success">Report Successfully Added</div>';
                  } else {
                    echo '<div class="alert alert-danger">Unable to save report.</div>';
                  }
                }
              }
              ?>

              <form method="POST" name='form' class="form" action="" enctype="multipart/form-data">
                <div class="form-group">
                  <label class="control-label">*Term and Year</label>
                  <select name="term" class="form-control">
                    <option value="" selected="selected">Select Term ...</option>
                    <?php
                    $terms = mysqli_query($con, "SELECT financialterm_id,term,year FROM financialterms WHERE status=1");
                    if ($terms) {
                      while ($row = mysqli_fetch_assoc($terms)) {
                        $financialterm_id = (int)($row['financialterm_id'] ?? 0);
                        $termName = $row['term'] ?? '';
                        $year = $row['year'] ?? '';
                    ?>
                      <option value="<?php echo $financialterm_id; ?>"><?php echo htmlspecialchars('Term ' . $termName . ' ' . $year); ?></option>
                    <?php }
                    }
                    ?>
                  </select>
                </div>
                <div class="form-group">
                  <label class="control-label">Report</label>
                  <textarea class="ckeditor" id="editor1" name="report">
                                                </textarea>
                </div>

                <div class="hr-line-dashed"></div>

                <div class="form-group">
                  <button class="btn btn-primary" type="submit">Submit</button>
                </div>
              </form>
            </div>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
  <script>
    $('#data_1 .input-group.date').datepicker({
      todayBtn: "linked",
      keyboardNavigation: false,
      forceParse: false,
      calendarWeeks: true,
      autoclose: true
    });
  </script>

</body>

</html>