<?php
if (session_status() === PHP_SESSION_NONE) session_start();
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add Past Paper-School Manager</title>
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                  Add Past Paper
                    </header>
                          <div class="panel-body">    
      <?php
      if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $class = trim((string)($_POST['class'] ?? ''));
        $title = trim((string)($_POST['title'] ?? ''));
        $errors = [];

        if ($class === '' || $title === '') {
          $errors[] = 'All Fields are Required';
        }

        if (!empty($_FILES['image']['name'])) {
          $image_name = $_FILES['image']['name'];
          $image_size = $_FILES['image']['size'];
          $image_temp = $_FILES['image']['tmp_name'];
          $allowed_ext = ['doc','docx','pdf'];
          $imgext = explode('.', $image_name);
          $imgext2 = strtolower(end($imgext));
          $image_ext = $imgext2;
          if (!in_array($image_ext, $allowed_ext, true)) {
            $errors[] = 'File type not allowed';
          }
          // 10MB limit
          if ($image_size > 10 * 1024 * 1024) {
            $errors[] = 'Maximum file size is 10MB';
          }
        } else {
          $errors[] = 'Please select a file to upload';
        }

        if (!empty($errors)) {
          foreach ($errors as $error) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>';
          }
        } else {
          $split = explode(',', $class);
          $class_id = (int) current($split);
          $subject = (int) end($split);

          // insert record and move file safely
          $stmt = mysqli_prepare($con, "INSERT INTO pastpapers(class_id,subject_id,title,teacher_id,ext,timestamp,status) VALUES(?,?,?,?,?,? ,1)");
            if ($stmt) {
            // types: class_id(i), subject_id(i), title(s), teacher_id(i), ext(s), timestamp(s)
            $teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
            mysqli_stmt_bind_param($stmt, 'iisiss', $class_id, $subject, $title, $teacher_id, $image_ext, $timenow);
            mysqli_stmt_execute($stmt);
            $last_id = (int) mysqli_insert_id($con);
            mysqli_stmt_close($stmt);

            $image_file_name = md5((string)$last_id) . '.' . $image_ext;
            $dest = __DIR__ . '/../images/pastpapers/' . $image_file_name;
            if (!is_dir(dirname($dest))) {
              mkdir(dirname($dest), 0777, true);
            }
            if (move_uploaded_file($image_temp, $dest)) {
              echo '<div class="alert alert-success">Past paper Successfully Posted</div>';
            } else {
              echo '<div class="alert alert-danger">Failed to move uploaded file.</div>';
            }
          } else {
            echo '<div class="alert alert-danger">Unable to save past paper.</div>';
          }
        }
      }
      ?>
 <form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
    <div class="form-group">
         <label class="control-label">* Past Paper Name</label>
         <input type="text" name="title" class="form-control" placeholder="Enter Past paper name">
     </div>
                                        <div class="form-group"><label class="control-label">* Class and subject</label>
                          <select name='class' class="form-control">
                    <option value="" selected="selected">Select Class and Subject...</option>
                    <?php
                    $teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
                    
                    // First, get the class the teacher represents (as class teacher)
                    $teacher_class_id = 0;
                    $teacher_info = mysqli_prepare($con, "SELECT class_id FROM teachers WHERE teacher_id = ? LIMIT 1");
                    if ($teacher_info) {
                        mysqli_stmt_bind_param($teacher_info, 'i', $teacher_id);
                        mysqli_stmt_execute($teacher_info);
                        $teacher_res = mysqli_stmt_get_result($teacher_info);
                        if ($teacher_res && $teacher_row = mysqli_fetch_assoc($teacher_res)) {
                            $teacher_class_id = (int)($teacher_row['class_id'] ?? 0);
                        }
                        mysqli_stmt_close($teacher_info);
                    }
                    
                    // If teacher has a class they represent, add it as an option
                    if ($teacher_class_id > 0) {
                        $class_name_query = mysqli_query($con, "SELECT class FROM classes WHERE class_id='{$teacher_class_id}' LIMIT 1");
                        if ($class_name_query && $class_row = mysqli_fetch_assoc($class_name_query)) {
                            $class_name = $class_row['class'] ?? '';
                            echo '<option value="' . htmlspecialchars($teacher_class_id . ',0') . '">' . htmlspecialchars($class_name . ' (Class Teacher - All Subjects)') . '</option>';
                        }
                    }
                    
                    // Then, get all subjects the teacher teaches
                    $t = mysqli_prepare($con, "SELECT class_sub_id FROM teacher_subjects WHERE teacher_id=?");
                    if ($t) {
                      mysqli_stmt_bind_param($t, 'i', $teacher_id);
                      mysqli_stmt_execute($t);
                      $res = mysqli_stmt_get_result($t);
                      while ($row = mysqli_fetch_assoc($res)) {
                        $class_sub_id = (int)($row['class_sub_id'] ?? 0);
                        $cs = mysqli_query($con, "SELECT class_id,subject_id FROM class_subjects WHERE class_sub_id=" . $class_sub_id);
                        if ($cs) {
                          while ($row1 = mysqli_fetch_assoc($cs)) {
                            $class_id = (int)($row1['class_id'] ?? 0);
                            $subject_id = (int)($row1['subject_id'] ?? 0);
                            $getclasses = mysqli_query($con, "SELECT class FROM classes WHERE class_id=" . $class_id . " LIMIT 1");
                            $class_name = '';
                            if ($getclasses) {
                              $r2 = mysqli_fetch_assoc($getclasses);
                              $class_name = $r2['class'] ?? '';
                            }
                            $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id=" . $subject_id . " LIMIT 1");
                            $subject_name = '';
                            if ($getsubjects) {
                              $r3 = mysqli_fetch_assoc($getsubjects);
                              $subject_name = $r3['subject'] ?? '';
                            }
                            $val = $class_id . ',' . $subject_id;
                            $label = htmlspecialchars($class_name . ':' . $subject_name);
                            echo '<option value="' . $val . '">' . $label . '</option>';
                          }
                        }
                      }
                      mysqli_stmt_close($t);
                    }
                    ?>
                     </select>
                                                                          
                                </div>         
     <div class="form-group">
                                                          <label>Upload File(Must be word document or PDF)*</label>
                                                          <input type="file" name="image"  id="filer_input" required="required">
                                                    </div>
                                   
                                <div class="form-group">                                                                
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                                              </div>
                            </form>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
  
</body>

</html>
 